/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.core.Context;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.BlnSeq;
import org.basex.query.value.seq.BytSeq;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.DecSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.FltSeq;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.ShrSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public final class Store
implements Closeable {
    private static final String NAME = Util.className(Store.class).toLowerCase(Locale.ENGLISH);
    private static final Pattern PATTERN = Pattern.compile(NAME + "-(.*)\\.basex");
    private final TokenObjMap<Value> map = new TokenObjMap();
    private final Context context;
    private String name = "";
    private boolean dirty = true;
    private boolean init;
    private static final int SEQUENCE = 63;
    private static final MethodHandle[] METHODS;
    private static final Map<Class<?>, Integer> CLASS_IDS;

    public Store(Context context) {
        this.context = context;
    }

    public synchronized Value keys() {
        this.init();
        TokenList list = new TokenList(this.map.size());
        for (byte[] key : this.map) {
            list.add(key);
        }
        return StrSeq.get(list);
    }

    public synchronized Value get(byte[] key) {
        this.init();
        Value value = this.map.get(key);
        return value != null ? value : Empty.VALUE;
    }

    public synchronized void put(byte[] key, Value value) {
        this.init();
        this.dirty = true;
        if (value.isEmpty()) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    public synchronized void remove(byte[] key) {
        this.init();
        this.dirty = true;
        this.map.remove(key);
    }

    public synchronized void clear() {
        this.init = true;
        this.dirty = true;
        this.map.clear();
    }

    public synchronized Value list() {
        TokenList list = new TokenList();
        for (IOFile file : this.context.soptions.dbPath().children()) {
            Matcher m = PATTERN.matcher(file.name());
            if (!m.matches()) continue;
            list.add(m.group(1));
        }
        return StrSeq.get(list);
    }

    public synchronized boolean read(String store, QueryContext qc) throws IOException, QueryException {
        IOFile file = this.file(store);
        boolean exists = file.exists();
        if (!exists && !Store.standard(store)) {
            return false;
        }
        this.name = store;
        this.init = true;
        this.dirty = false;
        this.map.clear();
        if (exists) {
            try (DataInput in = new DataInput(file);){
                for (int s = in.readNum() - 1; s >= 0; --s) {
                    this.map.put(in.readToken(), Store.read(in, qc));
                }
            }
        }
        return true;
    }

    public synchronized void write(String store) throws IOException, QueryException {
        this.init();
        this.name = store;
        this.dirty = false;
        IOFile file = this.file(store);
        if (Store.standard(store) && this.map.isEmpty()) {
            file.delete();
        } else {
            file.parent().md();
            try (DataOutput out = new DataOutput(file);){
                int size = 0;
                Iterator<byte[]> iter = this.map.iterator();
                while (iter.hasNext()) {
                    ++size;
                    iter.next();
                }
                out.writeNum(size);
                for (byte[] key : this.map) {
                    out.writeToken(key);
                    Store.write(out, this.map.get(key));
                }
            }
        }
    }

    public synchronized boolean delete(String store) {
        IOFile file = this.file(store);
        return file.exists() && file.delete();
    }

    @Override
    public synchronized void close() {
        try {
            if (this.init && this.name.isEmpty() && this.dirty) {
                this.write("");
            }
        }
        catch (IOException | QueryException ex) {
            Util.stack(ex);
        }
    }

    private synchronized void init() {
        if (this.init) {
            return;
        }
        try (QueryContext qc = new QueryContext(this.context);){
            this.read("", qc);
        }
        catch (IOException | QueryException ex) {
            Util.stack(ex);
        }
    }

    private IOFile file(String store) {
        TokenBuilder tb = new TokenBuilder().add(NAME);
        if (!Store.standard(store)) {
            tb.add(45).add(store);
        }
        return this.context.soptions.dbPath(tb.add(".basex").toString());
    }

    private static boolean standard(String store) {
        return store.isEmpty();
    }

    public static synchronized void write(DataOutput out, Value value) throws IOException, QueryException {
        out.writeNum(value.seqType().type.index());
        long size = value.size();
        out.writeLong(size);
        if (size == 1L) {
            value.write(out);
        } else if (size > 1L) {
            Integer classId = CLASS_IDS.get(value.getClass());
            if (classId == null) {
                out.writeNum(63);
                boolean same = value.sameType();
                out.writeBool(same);
                for (Item item : value) {
                    if (!same) {
                        out.writeNum(item.type.index());
                    }
                    item.write(out);
                }
            } else {
                out.writeNum(classId);
                value.write(out);
            }
        }
    }

    public static synchronized Value read(DataInput in, QueryContext qc) throws IOException, QueryException {
        qc.checkStop();
        int id = in.readNum();
        Type type = Types.type(id);
        long size = in.readLong();
        if (size == 0L) {
            return Empty.VALUE;
        }
        if (size == 1L) {
            return type.read(in, qc);
        }
        int classId = in.readNum();
        if (classId == 63) {
            ValueBuilder vb = new ValueBuilder(qc);
            boolean same = in.readBool();
            for (long s = 0L; s < size; ++s) {
                Type tp = same ? type : Types.type(in.readNum());
                vb.add(tp.read(in, qc));
            }
            return vb.value(type);
        }
        try {
            return METHODS[classId].invoke(in, type, qc);
        }
        catch (Throwable th) {
            throw new IOException(th);
        }
    }

    static {
        CLASS_IDS = new HashMap();
        try {
            Class[] classes = new Class[]{BlnSeq.class, BytSeq.class, DblSeq.class, DecSeq.class, FltSeq.class, IntSeq.class, ShrSeq.class, StrSeq.class, SingletonSeq.class, RangeSeq.class};
            METHODS = new MethodHandle[classes.length];
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodType mt = MethodType.methodType(Value.class, DataInput.class, Type.class, QueryContext.class);
            for (int c = classes.length - 1; c >= 0; --c) {
                CLASS_IDS.put(classes[c], c);
                Store.METHODS[c] = lookup.findStatic(classes[c], "read", mt);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            Util.stack(ex);
            throw Util.notExpected(ex, new Object[0]);
        }
    }
}

