/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.basex.build.Builder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.IOStream;
import org.basex.io.in.TarEntry;
import org.basex.io.in.TarInputStream;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class DirParser
extends Parser {
    private static final int SKIPLOG = 10;
    private final StringList skipped = new StringList();
    private final Pattern filter;
    private final String dir;
    private final String original;
    private final boolean archives;
    private final boolean skipCorrupt;
    private final boolean addBinary;
    private final boolean dtd;
    private final boolean binaryParser;
    private final boolean archiveName;
    private IO lastSrc;
    private Parser parser;
    private int resources;

    public DirParser(IO source, MainOptions options) {
        super(source, options);
        boolean isDir;
        boolean bl = isDir = source instanceof IOFile && source.isDir();
        if (isDir) {
            this.dir = source.path().replaceAll("/$", "") + "/";
            this.original = this.dir;
        } else {
            this.dir = source.dir();
            this.original = source.path();
        }
        this.skipCorrupt = options.get(MainOptions.SKIPCORRUPT);
        this.archives = options.get(MainOptions.ADDARCHIVES);
        this.archiveName = options.get(MainOptions.ARCHIVENAME);
        this.addBinary = options.get(MainOptions.ADDRAW);
        this.dtd = options.get(MainOptions.DTD);
        this.binaryParser = options.get(MainOptions.PARSER) == MainOptions.MainParser.RAW;
        this.filter = !isDir && !source.isArchive() ? null : Pattern.compile(IOFile.regex(options.get(MainOptions.CREATEFILTER)));
    }

    @Override
    public void parse(Builder build) throws IOException {
        build.meta.inputsize = 0L;
        build.meta.original = this.original;
        this.parse(build, this.source);
    }

    private void parse(Builder builder, IO input) throws IOException {
        block27: {
            if (input instanceof IOFile && input.isDir()) {
                for (IOFile f : ((IOFile)input).children()) {
                    this.parse(builder, f);
                }
            } else {
                if (this.archives && input.isArchive()) {
                    Object name = input.name().toLowerCase(Locale.ENGLISH);
                    InputStream in = input.inputStream();
                    if (((String)name).endsWith(".tar") || ((String)name).endsWith(".tgz") || ((String)name).endsWith(".tar.gz")) {
                        if (!((String)name).endsWith(".tar")) {
                            in = new GZIPInputStream(in);
                        }
                        try (TarInputStream is = new TarInputStream(in);){
                            TarEntry te;
                            while ((te = is.getNextEntry()) != null) {
                                if (te.isDirectory()) continue;
                                this.source = this.newStream(is, te.getName(), input);
                                this.source.length(te.getSize());
                                this.parseResource(builder);
                            }
                        }
                    }
                    if (((String)name).endsWith(".gz")) {
                        try (GZIPInputStream is = new GZIPInputStream(in);){
                            name = input.name().replaceAll("\\.[^.]+$", "");
                            if (!Strings.contains((String)name, '.')) {
                                name = (String)name + ".xml";
                            }
                            this.source = this.newStream(is, (String)name, input);
                            this.parseResource(builder);
                        }
                    }
                    try (ZipInputStream is = new ZipInputStream(in);){
                        ZipEntry ze;
                        while ((ze = is.getNextEntry()) != null) {
                            if (ze.isDirectory()) continue;
                            this.source = this.newStream(is, ze.getName(), input);
                            this.source.length(ze.getSize());
                            this.parseResource(builder);
                        }
                        break block27;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new IOException(ex);
                    }
                }
                this.source = input;
                this.parseResource(builder);
            }
        }
    }

    private IOStream newStream(InputStream is, String path, IO input) {
        return new IOStream(is, (String)(this.archiveName ? input.path() + "/" + path : path));
    }

    private void parseResource(Builder builder) throws IOException {
        boolean include;
        builder.checkStop();
        String name = this.source.name();
        String targ = this.target;
        String path = this.source.path();
        if (path.endsWith("/" + name)) {
            if ((path = path.substring(0, path.length() - name.length())).startsWith(this.dir)) {
                path = path.substring(this.dir.length());
            }
            targ = (targ + path).replace("//", "/");
        }
        boolean bl = this.filter == null || this.filter.matcher(Prop.CASE ? name : name.toLowerCase(Locale.ENGLISH)).matches() ? true : (include = false);
        if (include ? this.binaryParser : this.addBinary) {
            builder.binary(targ + name, this.source);
        } else if (include) {
            boolean ok = true;
            IO in = this.source;
            if (this.skipCorrupt) {
                try {
                    if (!(this.source instanceof IOContent) && !this.dtd) {
                        in = new IOContent(this.source.read());
                        in.name(name);
                    }
                    this.parser = Parser.singleParser(in, this.options, targ);
                    MemBuilder.build("", this.parser);
                }
                catch (IOException ex) {
                    Util.debug(ex);
                    this.skipped.add(this.source.path());
                    ok = false;
                }
            }
            if (ok) {
                this.parser = Parser.singleParser(in, this.options, targ);
                this.parser.parse(builder);
            }
            this.parser = null;
        }
        long l = this.source.length();
        if (l != -1L) {
            builder.meta.inputsize += l;
        }
        if (Prop.debug && (++this.resources & 0x3FF) == 0) {
            Util.err(";", new Object[0]);
        }
    }

    @Override
    public String info() {
        TokenBuilder tb = new TokenBuilder();
        if (!this.skipped.isEmpty()) {
            tb.add(Text.SKIPPED).add(":").add(Text.NL);
            int s = this.skipped.size();
            for (int i = 0; i < s && i < 10; ++i) {
                tb.add("- ").add((String)this.skipped.get(i)).add(Text.NL);
            }
            if (s > 10) {
                tb.add("- ").addExt(Text.MORE_SKIPPED_X, s - 10).add(Text.NL);
            }
        }
        return tb.toString();
    }

    @Override
    public String detailedInfo() {
        return this.parser != null ? this.parser.detailedInfo() : this.source.path();
    }

    @Override
    public double progressInfo() {
        if (this.parser != null) {
            return this.parser.progressInfo();
        }
        if (this.lastSrc == this.source) {
            return 1.0;
        }
        this.lastSrc = this.source;
        return Math.random();
    }

    @Override
    public void close() throws IOException {
        if (this.parser != null) {
            this.parser.close();
        }
    }
}

