/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.cmd.XQuery;
import org.basex.http.HTTPConnection;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTSession;
import org.basex.io.serial.SerializerOptions;
import org.basex.util.options.Options;

class RESTQuery
extends RESTCmd {
    RESTQuery(RESTSession session, Map<String, String[]> bindings) {
        super(session);
        for (Command cmd : session) {
            if (!(cmd instanceof XQuery)) continue;
            XQuery xq = (XQuery)cmd;
            bindings.forEach((key, value) -> xq.bind(key, (Object)value[0], value[1]));
        }
    }

    @Override
    protected void run0() throws IOException {
        this.query();
    }

    private void query() throws IOException {
        HTTPConnection conn = this.session.conn;
        SerializerOptions sopts = conn.sopts();
        this.context.options.set(MainOptions.SERIALIZER, (Options)sopts);
        this.context.setExternal((Object)conn.requestCtx);
        conn.initResponse();
        ServletOutputStream os = conn.response.getOutputStream();
        for (Command cmd : this.session) {
            if (cmd instanceof XQuery) {
                sopts.assign(((XQuery)cmd).parameters(this.context));
                conn.initResponse();
            }
            this.run(cmd, (OutputStream)os);
        }
    }

    static RESTQuery get(RESTSession session, String query, Map<String, String[]> bindings) throws IOException {
        String uri = session.conn.context.soptions.get(StaticOptions.WEBPATH);
        return new RESTQuery(session.add(new XQuery(query).baseURI(uri)), bindings);
    }
}

