/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.basex.build.csv.CsvParserOptions;
import org.basex.build.html.HtmlOptions;
import org.basex.build.html.HtmlParser;
import org.basex.build.json.JsonParserOptions;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.BufferInput;
import org.basex.io.in.InputException;
import org.basex.io.in.NewlineInput;
import org.basex.io.in.TextInput;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.io.parse.json.JsonConverter;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.list.ANodeList;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.seq.Empty;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.http.HTTPText;
import org.basex.util.http.MediaType;
import org.basex.util.list.ByteList;

public final class Payload {
    private static final byte[] DECLSTART = Token.token("<?xml");
    private static final byte[] DECLEND = Token.token("?>");
    private final ItemList payloads;
    private final InputStream input;
    private final InputInfo info;
    private final MainOptions options;

    public Payload(InputStream input, boolean body, InputInfo info, MainOptions options) {
        this.input = input;
        this.info = info;
        this.options = options;
        this.payloads = body ? new ItemList() : null;
    }

    FNode parse(MediaType type, String encoding) throws IOException, QueryException {
        FBuilder body;
        if (type.isMultipart()) {
            byte[] boundary = this.boundary(type);
            body = FElem.build(HTTPText.Q_HTTP_MULTIPART).add(HTTPText.Q_BOUNDARY, boundary);
            ANodeList parts = new ANodeList();
            this.extractParts(Token.concat(HTTPText.DASHES, boundary), parts);
            for (ANode node : parts) {
                body.add(node);
            }
        } else {
            body = FElem.build(HTTPText.Q_HTTP_BODY);
            if (this.payloads != null) {
                InputStream in = "gzip".equals(encoding) ? new GZIPInputStream(this.input) : this.input;
                this.payloads.add(this.parse(BufferInput.get(in).content(), type));
            }
        }
        return body.add(HTTPText.Q_MEDIA_TYPE, type.type()).finish();
    }

    Value value() {
        return this.payloads.value();
    }

    private Value parse(byte[] payload, MediaType type) throws QueryException {
        try {
            return Payload.value(payload, type, this.options);
        }
        catch (IOException ex) {
            throw QueryError.HC_PARSE_X.get(this.info, ex);
        }
    }

    private void extractParts(byte[] sep, ANodeList parts) throws IOException, QueryException {
        byte[] l;
        do {
            if ((l = this.readLine()) != null) continue;
            throw QueryError.HC_REQ_X.get(this.info, "No body specified for http:part");
        } while (!Token.eq(sep, l));
        while (this.extractPart(sep, Token.concat(sep, HTTPText.DASHES), parts)) {
        }
    }

    private boolean extractPart(byte[] sep, byte[] end, ANodeList parts) throws IOException, QueryException {
        byte[] line = this.readLine();
        if (line == null || Token.eq(line, end)) {
            return false;
        }
        MediaType type = MediaType.TEXT_PLAIN;
        boolean base64 = false;
        byte[] l = line;
        while (l != null && l.length > 0) {
            int pos = Token.indexOf(l, 58);
            if (pos > 0) {
                String key = Token.string(Token.substring(l, 0, pos));
                String value = Token.string(Token.trim(Token.substring(l, pos + 1)));
                if (key.equalsIgnoreCase("Content-Type")) {
                    type = new MediaType(value);
                } else if (key.equalsIgnoreCase("Content-Transfer-Encoding")) {
                    base64 = value.equals("base64");
                }
                if (!value.isEmpty() && parts != null) {
                    parts.add(FElem.build(HTTPText.Q_HTTP_HEADER).add(HTTPText.Q_NAME, key).add(HTTPText.Q_VALUE, value).finish());
                }
            }
            l = this.readLine();
        }
        if (parts != null) {
            parts.add(FElem.build(HTTPText.Q_HTTP_BODY).add(HTTPText.Q_MEDIA_TYPE, type).finish());
        }
        ByteList bl = new ByteList();
        while ((line = this.readLine()) != null && !Token.eq(line, sep)) {
            if (Token.eq(line, end)) {
                while (this.readLine() != null) {
                }
                break;
            }
            if (!bl.isEmpty()) {
                bl.add(HTTPText.CRLF);
            }
            bl.add(line);
        }
        if (this.payloads != null) {
            String encoding = type.parameter("charset");
            byte[] part = new TextInput(bl.finish()).encoding(encoding).content();
            this.payloads.add(this.parse(base64 ? Base64.decode(part) : part, type));
        }
        return true;
    }

    private byte[] readLine() throws IOException {
        int b;
        ByteList bl = new ByteList();
        while ((b = this.input.read()) != -1) {
            while (b == 13) {
                b = this.input.read();
                if (b == 10) {
                    return bl.finish();
                }
                bl.add(13);
                if (b != -1) continue;
                return bl.finish();
            }
            bl.add(b);
        }
        return bl.isEmpty() ? null : bl.finish();
    }

    private byte[] boundary(MediaType type) throws QueryException {
        String b = type.parameter("boundary");
        if (b == null) {
            throw QueryError.HC_REQ_X.get(this.info, "No separation boundary specified");
        }
        return Token.token(b);
    }

    public HashMap<String, Value> multiForm(MediaType type) throws IOException, QueryException {
        byte[] line;
        byte[] bound = Token.concat(HTTPText.DASHES, this.boundary(type));
        byte[] last = Token.concat(bound, HTTPText.DASHES);
        HashMap<String, Value> data = new HashMap<String, Value>();
        ByteList cont = new ByteList();
        int lines = -1;
        String name = "";
        String filename = null;
        while ((line = this.readLine()) != null) {
            if (lines >= 0) {
                if (Token.startsWith(line, bound)) {
                    Value value = data.get(name);
                    if (filename != null) {
                        XQMap map = value instanceof XQMap ? (XQMap)value : XQMap.empty();
                        Str file = Str.get(filename);
                        B64 contents = B64.get(cont.next());
                        Value files = ((ItemList)((Object)new ItemList().add(map.get(file, this.info)).add(contents))).value();
                        value = map.put(file, files, this.info);
                    } else {
                        Str v = Str.get(cont.next());
                        Value value2 = value = value == null ? v : ((ItemList)((Object)new ItemList().add(value).add(v))).value();
                    }
                    if (!name.isEmpty()) {
                        data.put(name, value);
                    }
                    lines = -1;
                    if (!Token.eq(line, last)) continue;
                    break;
                }
                if (lines++ > 0) {
                    cont.add(HTTPText.CRLF);
                }
                cont.add(line);
                continue;
            }
            if (Token.startsWith(Token.lc(line), HTTPText.CONTENT_DISPOSITION)) {
                name = Token.contains(line, Token.token("name=")) ? Token.string(line).replaceAll("^.*?name=\"|\".*", "").replaceAll("\\[]", "") : null;
                filename = Token.contains(line, Token.token("filename=")) ? Token.string(line).replaceAll("^.*filename=\"|\"$", "") : null;
                continue;
            }
            if (line.length != 0) continue;
            lines = 0;
        }
        return data;
    }

    public static Value value(byte[] body, MediaType type, MainOptions options) throws IOException, QueryException {
        IOContent io = Payload.prepare(body, type);
        if (io.length() == 0L) {
            return Empty.VALUE;
        }
        if (type.isJSON()) {
            JsonParserOptions opts = new JsonParserOptions(options.get(MainOptions.JSONPARSER));
            opts.assign(type);
            return JsonConverter.get(opts).convert(io);
        }
        if (type.isCSV()) {
            CsvParserOptions opts = new CsvParserOptions(options.get(MainOptions.CSVPARSER));
            opts.assign(type);
            return CsvConverter.get(opts).convert(io);
        }
        if (type.is(MediaType.TEXT_HTML)) {
            HtmlOptions opts = new HtmlOptions(options.get(MainOptions.HTMLPARSER));
            opts.assign(type);
            return new DBNode(new HtmlParser((IO)io, options, opts));
        }
        if (type.isXml()) {
            return new DBNode(io);
        }
        if (type.isText()) {
            return Str.get(io.read());
        }
        if (type.is(MediaType.APPLICATION_X_WWW_FORM_URLENCODED)) {
            try {
                byte[] decoded = Token.decodeUri(io.read(), true);
                int cp = XMLToken.invalid(decoded);
                if (cp != -1) {
                    throw new InputException(cp);
                }
                return Str.get(decoded);
            }
            catch (IllegalArgumentException ex) {
                Util.debug(ex);
                throw new IOException(ex.getMessage());
            }
        }
        if (type.isMultipart()) {
            try (ArrayInput is = io.inputStream();){
                Payload payload = new Payload(is, true, null, options);
                payload.extractParts(Token.concat(HTTPText.DASHES, payload.boundary(type)), null);
                Value value = payload.value();
                return value;
            }
        }
        return B64.get(io.read());
    }

    private static IOContent prepare(byte[] body, MediaType type) throws IOException {
        byte[] data = body;
        boolean xml = type.isXml();
        boolean text = type.isText();
        if (xml || text) {
            int d;
            data = new NewlineInput(body).encoding(type.parameter("charset")).content();
            if (xml && Token.startsWith(data, DECLSTART) && (d = Token.indexOf(data, DECLEND, DECLSTART.length)) != -1) {
                data = Token.substring(data, d + DECLEND.length);
            }
        }
        return new IOContent(data);
    }
}

