/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.ArrayList;
import java.util.Scanner;
import org.basex.core.Text;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class Table {
    private static final int DIST = 2;
    public final TokenList header = new TokenList();
    public final BoolList align = new BoolList();
    public final ArrayList<TokenList> contents = new ArrayList();
    public String description;

    public Table() {
    }

    public Table(String input) {
        if (input.isEmpty()) {
            return;
        }
        Scanner scan = new Scanner(input);
        byte[] line = Token.token(scan.nextLine());
        IntList il = new IntList();
        int l = 0;
        int ll = line.length;
        while (l < ll) {
            il.add(l);
            while (++l + 1 < ll && (line[l] != 32 || line[l + 1] != 32)) {
            }
            this.header.add(Token.substring(line, il.get(il.size() - 1), l));
            while (++l < ll && line[l] == 32) {
            }
        }
        il.add(l);
        scan.nextLine();
        int s = il.size() - 1;
        while ((line = Token.token(scan.nextLine())).length != 0) {
            TokenList entry = new TokenList();
            for (int e = 0; e < s; ++e) {
                entry.add(Token.trim(Token.substring(line, il.get(e), il.get(e + 1))));
            }
            this.contents.add(entry);
        }
    }

    public Table sort() {
        this.contents.sort((tl1, tl2) -> Token.diff(Token.lc((byte[])tl1.get(0)), Token.lc((byte[])tl2.get(0))));
        return this;
    }

    public Table toTop(byte[] top) {
        for (int i = 0; i < this.contents.size(); ++i) {
            if (!Token.eq(top, (byte[])this.contents.get(i).get(0))) continue;
            this.contents.add(0, this.contents.remove(i));
            break;
        }
        return this;
    }

    public byte[] finish() {
        int u;
        int[] ind = new int[this.header.size()];
        int size = this.header.size();
        for (int s = 0; s < size; ++s) {
            for (TokenList e : this.contents) {
                ind[s] = Math.max(ind[s], ((byte[])e.get(s)).length);
            }
            ind[s] = Math.max(ind[s], ((byte[])this.header.get(s)).length);
        }
        TokenBuilder tb = new TokenBuilder();
        for (u = 0; u < size; ++u) {
            byte[] s = (byte[])this.header.get(u);
            int is = ind[u] - s.length + 2;
            tb.add(s);
            for (int i = 0; i < is; ++i) {
                tb.add(32);
            }
        }
        tb.add(Text.NL);
        for (u = 0; u < size; ++u) {
            for (int i = 0; i < ind[u] + (u + 1 == size ? 0 : 2); ++i) {
                tb.add(45);
            }
        }
        tb.add(Text.NL);
        for (TokenList e : this.contents) {
            for (int u2 = 0; u2 < size; ++u2) {
                int i;
                byte[] s = (byte[])e.get(u2);
                int is = ind[u2] - s.length;
                if (u2 < this.align.size() && this.align.get(u2)) {
                    for (i = 0; i < is; ++i) {
                        tb.add(32);
                    }
                    tb.add(s);
                } else {
                    tb.add(s);
                    for (i = 0; i < is; ++i) {
                        tb.add(32);
                    }
                }
                for (i = 0; i < 2; ++i) {
                    tb.add(32);
                }
            }
            tb.add(Text.NL);
        }
        if (this.description != null) {
            tb.add(Text.NL).addExt(this.description, this.contents.size()).add(".");
        }
        return tb.finish();
    }

    public String toString() {
        return Token.string(this.finish());
    }
}

