/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.var.Var;
import org.basex.util.Array;
import org.basex.util.Prop;
import org.basex.util.TokenBuilder;

public final class QueryStack {
    private static final int INIT = 8;
    private Value[] stack = new Value[8];
    private Var[] vars = new Var[8];
    private int start;
    private int end;

    public int enterFrame(int size) {
        int e = this.end;
        int ne = e + size;
        this.ensureCapacity(ne);
        int s = this.start;
        this.start = e;
        this.end = ne;
        return s;
    }

    public void reuseFrame(int size) {
        int s = this.start;
        this.ensureCapacity(s + size);
        Value[] stck = this.stack;
        int e = this.end;
        while (--e >= s) {
            stck[e] = null;
        }
        this.end = s + size;
    }

    public void exitFrame(int frame) {
        int sl;
        int len;
        int s = this.start;
        Value[] stck = this.stack;
        int en = this.end;
        while (--en >= s) {
            stck[en] = null;
        }
        this.end = s;
        this.start = frame;
        for (len = sl = stck.length; len > 8 && sl <= len >> 2; len >>= 1) {
        }
        if (len != sl) {
            this.resize(len);
        }
    }

    private void ensureCapacity(int size) {
        int sl;
        int len;
        for (len = sl = this.stack.length; size > len; len <<= 1) {
        }
        if (len != sl) {
            this.resize(len);
        }
    }

    private void resize(int size) {
        int os = this.end;
        Value[] nst = new Value[size];
        Array.copy(this.stack, os, nst);
        this.stack = nst;
        Var[] nvr = new Var[size];
        Array.copy(this.vars, os, nvr);
        this.vars = nvr;
    }

    public Value get(Var var) {
        return this.stack[this.start + var.slot];
    }

    public void set(Var var, Value value, QueryContext qc) throws QueryException {
        int pos = this.start + var.slot;
        this.stack[pos] = var.checkType(value, qc, false);
        this.vars[pos] = var;
    }

    public String dump() {
        TokenBuilder tb = new TokenBuilder().add("Local Variables").add(58);
        int i = this.end;
        while (--i >= 0) {
            if (this.vars[i] == null) continue;
            tb.add(Prop.NL).add("  $").add(this.vars[i].name).add(" := ").add(this.stack[i]);
            if (i != this.start || i <= 0) continue;
            tb.add(Prop.NL).add("Global Variables").add(58);
        }
        return tb.toString();
    }

    public String toString() {
        return new TokenBuilder().add(this.getClass()).add(91).addAll(this.stack, ", ").add(93).toString();
    }
}

