/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.inspect;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class InspectStaticContext
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        StaticContext sctx;
        Item func = this.arg(0).item(qc, this.info);
        String name = this.toString(this.arg(1), qc);
        if (func.isEmpty()) {
            sctx = this.sc;
        } else {
            if (!((func = this.toFunction(func, qc)) instanceof FuncItem)) {
                throw QueryError.INVFUNCITEM_X_X.get(this.info, func.type, func);
            }
            sctx = ((FuncItem)func).sc;
        }
        switch (name) {
            case "base-uri": {
                return sctx.baseURI();
            }
            case "namespaces": {
                int n;
                MapBuilder mb = new MapBuilder(this.info);
                Atts nsp = sctx.ns.list;
                int ns = nsp.size();
                for (n = 0; n < ns; ++n) {
                    mb.put(Str.get(nsp.name(n)), (Value)Str.get(nsp.value(n)));
                }
                nsp = NSGlobal.NS;
                ns = nsp.size();
                for (n = 0; n < ns; ++n) {
                    Str key = Str.get(nsp.name(n));
                    if (mb.contains(key)) continue;
                    mb.put(key, (Value)Str.get(nsp.value(n)));
                }
                return mb.map();
            }
            case "element-namespace": {
                return sctx.elemNS == null ? Empty.VALUE : Uri.get(sctx.elemNS);
            }
            case "function-namespace": {
                return sctx.funcNS == null ? Empty.VALUE : Uri.get(sctx.funcNS);
            }
            case "collation": {
                return Uri.get(sctx.collation == null ? QueryText.COLLATION_URI : sctx.collation.uri());
            }
            case "ordering": {
                return Str.get(sctx.ordered ? "ordered" : "unordered");
            }
            case "construction": {
                return Str.get(sctx.strip ? "strip" : "preserve");
            }
            case "default-order-empty": {
                return Str.get(sctx.orderGreatest ? "greatest" : "least");
            }
            case "boundary-space": {
                return Str.get(sctx.spaces ? "preserve" : "strip");
            }
            case "copy-namespaces": {
                TokenList tl = new TokenList(2L);
                tl.add(sctx.preserveNS ? "preserve" : "no-preserve");
                tl.add(sctx.inheritNS ? "inherit" : "no-inherit");
                return StrSeq.get(tl);
            }
            case "decimal-formats": {
                MapBuilder mb = new MapBuilder(this.info);
                sctx.decFormat(Token.EMPTY);
                for (byte[] format : sctx.decFormats) {
                    DecFormatter df = sctx.decFormats.get(format);
                    mb.put(Str.get(format), (Value)new MapBuilder(this.info).put("decimal-separator", Token.cpToken(df.decimal)).put("exponent-separator", Token.cpToken(df.exponent)).put("grouping-separator", Token.cpToken(df.grouping)).put("percent", Token.cpToken(df.percent)).put("per-mille", Token.cpToken(df.permille)).put("zero-digit", Token.cpToken(df.zero)).put("digit", Token.cpToken(df.optional)).put("pattern-separator", Token.cpToken(df.pattern)).put("infinity", df.inf).put("NaN", df.nan).put("minus-sign", Token.cpToken(df.minus)).map());
                }
                return mb.map();
            }
        }
        throw QueryError.INSPECT_UNKNOWN_X.get(this.info, name);
    }
}

