/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import java.util.Date;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.index.resource.ResourceType;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.db.DbAccess;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.DateTime;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public class DbList
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.defined(0) ? this.resources(qc) : DbList.list(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.defined(0) ? this.resources(qc).value(qc, this) : DbList.list(qc);
    }

    private static Value list(QueryContext qc) {
        Context ctx = qc.context;
        StringList dbs = ctx.listDBs();
        TokenList list = new TokenList(dbs.size());
        for (String name : dbs) {
            list.add(name);
        }
        return StrSeq.get(list);
    }

    private Iter resources(QueryContext qc) throws QueryException {
        final Data data = this.toData(qc);
        String path = this.defined(1) ? this.toString(this.arg(1), qc) : "";
        final IntList docs = data.resources.docs(path);
        final StringList binaries = data.resources.paths(path, ResourceType.BINARY);
        final StringList values = data.resources.paths(path, ResourceType.VALUE);
        final int ds = docs.size();
        final int bs = ds + binaries.size();
        int size = bs + values.size();
        return new BasicIter<Str>((long)size){

            @Override
            public Str get(long i) {
                return i < this.size ? Str.get(this.path((int)i)) : null;
            }

            @Override
            public Value value(QueryContext q, Expr expr) throws QueryException {
                TokenList tl = new TokenList(Seq.initialCapacity(this.size));
                int i = 0;
                while ((long)i < this.size) {
                    tl.add(this.path(i));
                    ++i;
                }
                return StrSeq.get(tl);
            }

            private byte[] path(int i) {
                return i < ds ? data.text(docs.get(i), true) : Token.token(i < bs ? (String)binaries.get(i - ds) : (String)values.get(i - bs));
            }
        };
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        return (this.defined(0) ? this.dataLock(this.arg(0), false, visitor) : visitor.lock((String)null)) && super.accept(visitor);
    }

    static FNode dir(String path, long mdate) {
        String date = DateTime.format(new Date(mdate));
        return FElem.build(DbAccess.Q_DIR).add(path).add(DbAccess.Q_MODIFIED_DATE, date).finish();
    }

    static FNode resource(String path, long mdate, long size, ResourceType type) {
        FBuilder elem = FElem.build(DbAccess.Q_RESOURCE).add(path);
        elem.add(DbAccess.Q_TYPE, (Object)type);
        elem.add(DbAccess.Q_CONTENT_TYPE, type.contentType(path));
        elem.add(DbAccess.Q_MODIFIED_DATE, DateTime.format(new Date(mdate)));
        elem.add(DbAccess.Q_SIZE, size);
        return elem.finish();
    }
}

