/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.XQData;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class DynFuncCall
extends FuncCall {
    private final StaticContext sc;
    private final boolean updating;
    private boolean ndt;
    private int[] inlinedFrom;

    public DynFuncCall(InputInfo info, StaticContext sc, Expr expr, Expr ... args) {
        this(info, sc, false, false, expr, args);
    }

    public DynFuncCall(InputInfo info, StaticContext sc, boolean updating, boolean ndt, Expr expr, Expr ... args) {
        super(info, ExprList.concat(args, expr));
        this.sc = sc;
        this.updating = updating;
        this.ndt = ndt;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        if (this.body().has(Flag.NDT)) {
            this.ndt = true;
        }
        return super.compile(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr func = this.body();
        int nargs = this.exprs.length - 1;
        FuncType ft = func.funcType();
        if (ft != null) {
            if (ft.argTypes != null && ft.argTypes.length != nargs) {
                throw QueryError.INVARITY_X_X_X.get(this.info, QueryError.arguments(nargs), ft.argTypes.length, func.toErrorString());
            }
            if (!this.sc.mixUpdates && !this.updating && ft.anns.contains(Annotation.UPDATING)) {
                throw QueryError.FUNCUP_X.get(this.info, func);
            }
            SeqType dt = ft.declType;
            this.exprType.assign(ft instanceof MapType ? dt.union(Occ.ZERO) : dt);
        }
        if (func instanceof XQData) {
            if (nargs == 1) {
                this.arg(0, arg -> arg.simplifyFor(CompileContext.Simplify.DATA, cc));
            }
            if (this.allAreValues(false)) {
                return cc.preEval(this);
            }
        }
        if (func instanceof XQFunctionExpr) {
            if (!(func instanceof FuncItem) || !this.comesFrom((FuncItem)func)) {
                XQFunctionExpr fe = (XQFunctionExpr)((Object)func);
                this.checkUp(fe, this.updating, this.sc);
                Expr inlined = fe.inline(Arrays.copyOf(this.exprs, nargs), cc);
                if (inlined != null) {
                    return inlined;
                }
            }
        } else if (func instanceof Value) {
            throw QueryError.INVFUNCITEM_X_X.get(this.info, this.toItem((Expr)func, (QueryContext)cc.qc).type, func);
        }
        return this;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(Arrays.copyOf(this.exprs, this.exprs.length - 1));
        this.body().checkUp();
    }

    public void markInlined(FuncItem item) {
        int[] nArray;
        int hash = item.hashCode();
        if (this.inlinedFrom == null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = hash;
        } else {
            nArray = Array.add(this.inlinedFrom, hash);
        }
        this.inlinedFrom = nArray;
    }

    private boolean comesFrom(FuncItem item) {
        if (this.inlinedFrom != null) {
            int hash = item.hashCode();
            for (int h : this.inlinedFrom) {
                if (hash != h) continue;
                return true;
            }
        }
        return false;
    }

    private Expr body() {
        return this.exprs[this.exprs.length - 1];
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        Expr[] copy = DynFuncCall.copyAll((CompileContext)cc, vm, (Expr[])this.exprs);
        int last = copy.length - 1;
        Expr[] args = Arrays.copyOf(copy, last);
        DynFuncCall call = new DynFuncCall(this.info, this.sc, this.updating, this.ndt, copy[last], args);
        if (this.inlinedFrom != null) {
            call.inlinedFrom = (int[])this.inlinedFrom.clone();
        }
        return this.copyType(call);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.dynFuncCall(this) && DynFuncCall.visitAll(visitor, this.exprs);
    }

    @Override
    FItem evalFunc(QueryContext qc) throws QueryException {
        Item item = this.toItem(this.body(), qc);
        if (!(item instanceof FItem)) {
            throw QueryError.INVFUNCITEM_X_X.get(this.info, item.type, item);
        }
        FItem func = this.checkUp((FItem)item, this.updating, this.sc);
        int nargs = this.exprs.length - 1;
        if (func.arity() != nargs) {
            throw QueryError.INVARITY_X_X_X.get(this.info, QueryError.arguments(nargs), func.arity(), func.toErrorString());
        }
        return func;
    }

    @Override
    Value[] evalArgs(QueryContext qc) throws QueryException {
        int el = this.exprs.length - 1;
        Value[] args = new Value[el];
        for (int e = 0; e < el; ++e) {
            args[e] = this.exprs[e].value(qc);
        }
        return args;
    }

    @Override
    public boolean has(Flag ... flags) {
        boolean upd;
        boolean bl = upd = this.updating || this.sc.mixUpdates;
        if (Flag.UPD.in(flags) && upd) {
            return true;
        }
        if (Flag.NDT.in(flags) && (this.ndt || upd)) {
            return true;
        }
        Flag[] flgs = Flag.NDT.remove(Flag.UPD.remove(flags));
        return flgs.length != 0 && super.has(flgs);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof DynFuncCall && this.updating == ((DynFuncCall)obj).updating && super.equals(obj);
    }

    @Override
    public String description() {
        return this.body().description() + "(...)";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "tailCall", this.tco), this.exprs);
    }

    @Override
    public void toString(QueryString qs) {
        int el = this.exprs.length - 1;
        qs.token(this.exprs[el]).token('(');
        for (int e = 0; e < el; ++e) {
            if (e > 0) {
                qs.token(", ");
            }
            qs.token(this.exprs[e]);
        }
        qs.token(')');
    }
}

