/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.Objects;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Condition
extends Single {
    private final boolean start;
    private final Var item;
    private final Var pos;
    private final Var prev;
    private final Var next;

    public Condition(boolean start, Var item, Var pos, Var prev, Var next, Expr expr, InputInfo info) {
        super(info, expr, SeqType.ITEM_ZM);
        this.start = start;
        this.item = item;
        this.pos = pos;
        this.prev = prev;
        this.next = next;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.expr = this.expr.compile(cc);
        return this.optimize(cc);
    }

    @Override
    public Condition optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.EBV, cc);
        return this;
    }

    void compile(Expr ex, CompileContext cc) throws QueryException {
        SeqType st = ex.seqType();
        if (this.item != null) {
            this.item.refineType(st.with(Occ.EXACTLY_ONE), 1L, cc);
        }
        if (this.pos != null) {
            this.pos.refineType(SeqType.INTEGER_O, 1L, cc);
        }
        if (this.prev != null) {
            this.prev.refineType(st.with(Occ.ZERO_OR_ONE), -1L, cc);
        }
        if (this.next != null) {
            this.next.refineType(st.with(Occ.ZERO_OR_ONE), -1L, cc);
        }
        this.compile(cc);
    }

    @Override
    public Condition inline(InlineContext ic) throws QueryException {
        return (Condition)super.inline(ic);
    }

    @Override
    public Condition copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Condition(this.start, cc.copy(this.item, vm), cc.copy(this.pos, vm), cc.copy(this.prev, vm), cc.copy(this.next, vm), this.expr.copy(cc, vm), this.info));
    }

    int nVars() {
        int i = 0;
        if (this.item != null) {
            ++i;
        }
        if (this.pos != null) {
            ++i;
        }
        if (this.prev != null) {
            ++i;
        }
        if (this.next != null) {
            ++i;
        }
        return i;
    }

    boolean usesNext() {
        return this.next != null;
    }

    void writeVars(Var[] arr, int p) {
        int i = p;
        if (this.item != null) {
            arr[i++] = this.item;
        }
        if (this.pos != null) {
            arr[i++] = this.pos;
        }
        if (this.prev != null) {
            arr[i++] = this.prev;
        }
        if (this.next != null) {
            arr[i] = this.next;
        }
    }

    boolean matches(QueryContext qc, Item it, long ps, Item pr, Item nx) throws QueryException {
        this.bind(qc, it, ps, pr, nx);
        return this.expr.ebv(qc, this.info).bool(this.info);
    }

    void bind(QueryContext qc, Item it, long ps, Item pr, Item nx) throws QueryException {
        if (this.item != null) {
            qc.set(this.item, it);
        }
        if (this.pos != null) {
            qc.set(this.pos, Int.get(ps));
        }
        if (this.prev != null) {
            qc.set(this.prev, pr == null ? Empty.VALUE : pr);
        }
        if (this.next != null) {
            qc.set(this.next, nx == null ? Empty.VALUE : nx);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return !(this.item != null && !visitor.declared(this.item) || this.pos != null && !visitor.declared(this.pos) || this.prev != null && !visitor.declared(this.prev) || this.next != null && !visitor.declared(this.next) || !this.expr.accept(visitor));
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition c = (Condition)obj;
        return Objects.equals(this.item, c.item) && Objects.equals(this.pos, c.pos) && Objects.equals(this.prev, c.prev) && Objects.equals(this.next, c.next) && super.equals(obj);
    }

    @Override
    public void toXml(QueryPlan plan) {
        FBuilder elem = plan.create(this.start ? "start" : "end", this.item);
        if (this.pos != null) {
            elem.add(plan.create("at", this.pos));
        }
        if (this.prev != null) {
            elem.add(plan.create("previous", this.prev));
        }
        if (this.next != null) {
            elem.add(plan.create("next", this.next));
        }
        plan.add(elem, this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.start ? "start" : "end");
        if (this.item != null) {
            qs.token(this.item);
        }
        if (this.pos != null) {
            qs.token("at").token(this.pos);
        }
        if (this.prev != null) {
            qs.token("previous").token(this.prev);
        }
        if (this.next != null) {
            qs.token("next").token(this.next);
        }
        qs.token("when").token(this.expr);
    }
}

