/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTNot;
import org.basex.query.expr.ft.FTOr;
import org.basex.query.iter.FTIter;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTMatches;
import org.basex.query.util.index.IndexCosts;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.value.node.FTNode;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;

public final class FTAnd
extends FTExpr {
    public FTAnd(InputInfo info, FTExpr[] exprs) {
        super(info, exprs);
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        super.compile(cc);
        boolean not = true;
        for (FTExpr expr : this.exprs) {
            not &= expr instanceof FTNot;
        }
        if (not) {
            int el = this.exprs.length;
            for (int e = 0; e < el; ++e) {
                this.exprs[e] = this.exprs[e].exprs[0];
            }
            return (FTExpr)cc.replaceWith(this, new FTNot(this.info, (FTExpr)new FTOr(this.info, this.exprs)));
        }
        return this;
    }

    @Override
    public FTNode item(QueryContext qc, InputInfo ii) throws QueryException {
        FTNode item = this.exprs[0].item(qc, this.info);
        int el = this.exprs.length;
        for (int e = 1; e < el; ++e) {
            FTAnd.and(item, this.exprs[e].item(qc, this.info));
        }
        return item;
    }

    @Override
    public FTIter iter(QueryContext qc) throws QueryException {
        int el = this.exprs.length;
        final FTIter[] iters = new FTIter[el];
        final FTNode[] nodes = new FTNode[el];
        for (int e = 0; e < el; ++e) {
            iters[e] = this.exprs[e].iter(qc);
            nodes[e] = iters[e].next();
        }
        return new FTIter(){

            @Override
            public FTNode next() throws QueryException {
                int il = nodes.length;
                for (int i = 0; i < il; ++i) {
                    if (nodes[i] == null) {
                        return null;
                    }
                    int d = nodes[0].pre() - nodes[i].pre();
                    if (d == 0) continue;
                    if (d < 0) {
                        i = 0;
                    }
                    nodes[i] = iters[i].next();
                    i = -1;
                }
                FTNode item = nodes[0];
                for (int i = 1; i < il; ++i) {
                    FTAnd.and(item, nodes[i]);
                    nodes[i] = iters[i].next();
                }
                nodes[0] = iters[0].next();
                return item;
            }
        };
    }

    private static void and(FTNode node1, FTNode node2) {
        FTMatches all = new FTMatches((byte)Math.max(node1.matches().pos, node2.matches().pos));
        for (FTMatch match1 : node1.matches()) {
            for (FTMatch match2 : node2.matches()) {
                all.add(new FTMatch(match1.size() + match2.size()).add(match1).add(match2));
            }
        }
        node1.score(Scoring.avg(node1.score() + node2.score(), 2));
        node1.matches(all);
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        IndexCosts costs = IndexCosts.ZERO;
        for (FTExpr expr : this.exprs) {
            if (!expr.indexAccessible(ii)) {
                return false;
            }
            costs = IndexCosts.add(costs, ii.costs);
        }
        ii.costs = costs;
        return true;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new FTAnd(this.info, (FTExpr[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof FTAnd && super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        qs.tokens(this.exprs, " ftand ", true);
    }
}

