/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Pragma;
import org.basex.query.expr.Single;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.value.Value;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Extension
extends Single {
    private final Pragma pragma;

    public Extension(InputInfo info, Pragma pragma, Expr expr) {
        super(info, expr, SeqType.ITEM_ZM);
        this.pragma = pragma;
    }

    @Override
    public void checkUp() throws QueryException {
        this.expr.checkUp();
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        Object state = this.pragma.init(cc.qc, this.info);
        try {
            this.expr = this.expr.compile(cc);
        }
        finally {
            this.pragma.finish(cc.qc, state);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        return this.expr instanceof Value && !this.expr.seqType().mayBeFunction() ? this.expr : this.adoptType(this.expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Object state = this.pragma.init(qc, this.info);
        try {
            Value value = this.expr.value(qc);
            return value;
        }
        finally {
            this.pragma.finish(qc, state);
        }
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Extension(this.info, this.pragma.copy(), this.expr.copy(cc, vm)));
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.pragma.has(flags) || super.has(flags);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        this.pragma.accept(visitor);
        return super.accept(visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        QueryContext qc = ii.cc.qc;
        Object state = this.pragma.init(qc, this.info);
        try {
            boolean bl = this.expr.indexAccessible(ii);
            return bl;
        }
        finally {
            this.pragma.finish(qc, state);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Extension && this.pragma.equals(((Extension)obj).pragma) && super.equals(obj);
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.pragma, this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.pragma).brace(this.expr);
    }
}

