/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.util.HashMap;
import org.basex.build.csv.CsvSerialOptions;
import org.basex.build.json.JsonSerialOptions;
import org.basex.core.BaseXException;
import org.basex.io.IO;
import org.basex.io.serial.SerialMethod;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.func.FuncOptions;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenMap;
import org.basex.util.options.EnumOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.OptionsOption;
import org.basex.util.options.StringOption;

public final class SerializerOptions
extends Options {
    public static final EnumOption<Options.YesNo> BYTE_ORDER_MARK = new EnumOption<Options.YesNo>("byte-order-mark", Options.YesNo.NO);
    public static final StringOption CDATA_SECTION_ELEMENTS = new StringOption("cdata-section-elements", "");
    public static final StringOption DOCTYPE_PUBLIC = new StringOption("doctype-public", "");
    public static final StringOption DOCTYPE_SYSTEM = new StringOption("doctype-system", "");
    public static final StringOption ENCODING = new StringOption("encoding", "UTF-8");
    public static final EnumOption<Options.YesNo> ESCAPE_URI_ATTRIBUTES = new EnumOption<Options.YesNo>("escape-uri-attributes", Options.YesNo.NO);
    public static final EnumOption<Options.YesNo> INCLUDE_CONTENT_TYPE = new EnumOption<Options.YesNo>("include-content-type", Options.YesNo.YES);
    public static final EnumOption<Options.YesNo> INDENT = new EnumOption<Options.YesNo>("indent", Options.YesNo.NO);
    public static final StringOption SUPPRESS_INDENTATION = new StringOption("suppress-indentation", "");
    public static final StringOption MEDIA_TYPE = new StringOption("media-type", "");
    public static final EnumOption<SerialMethod> METHOD = new EnumOption<SerialMethod>("method", SerialMethod.BASEX);
    public static final StringOption NORMALIZATION_FORM = new StringOption("normalization-form", "none");
    public static final EnumOption<Options.YesNo> OMIT_XML_DECLARATION = new EnumOption<Options.YesNo>("omit-xml-declaration", Options.YesNo.YES);
    public static final EnumOption<Options.YesNoOmit> STANDALONE = new EnumOption<Options.YesNoOmit>("standalone", Options.YesNoOmit.OMIT);
    public static final EnumOption<Options.YesNo> UNDECLARE_PREFIXES = new EnumOption<Options.YesNo>("undeclare-prefixes", Options.YesNo.NO);
    public static final StringOption USE_CHARACTER_MAPS = new StringOption("use-character-maps", "");
    public static final StringOption ITEM_SEPARATOR = new StringOption("item-separator");
    public static final StringOption VERSION = new StringOption("version", "");
    public static final StringOption HTML_VERSION = new StringOption("html-version", "");
    public static final StringOption PARAMETER_DOCUMENT = new StringOption("parameter-document", "");
    public static final EnumOption<Options.YesNo> ALLOW_DUPLICATE_NAMES = new EnumOption<Options.YesNo>("allow-duplicate-names", Options.YesNo.NO);
    public static final EnumOption<SerialMethod> JSON_NODE_OUTPUT_METHOD = new EnumOption<SerialMethod>("json-node-output-method", SerialMethod.XML);
    public static final OptionsOption<CsvSerialOptions> CSV = new OptionsOption<CsvSerialOptions>("csv", new CsvSerialOptions());
    public static final OptionsOption<JsonSerialOptions> JSON = new OptionsOption<JsonSerialOptions>("json", new JsonSerialOptions());
    public static final EnumOption<Newline> NEWLINE = new EnumOption<Newline>("newline", "\r".equals(Prop.NL) ? Newline.CR : ("\n".equals(Prop.NL) ? Newline.NL : Newline.CRNL));
    public static final EnumOption<Options.YesNo> TABULATOR = new EnumOption<Options.YesNo>("tabulator", Options.YesNo.NO);
    public static final NumberOption INDENTS = new NumberOption("indents", 2);
    public static final NumberOption LIMIT = new NumberOption("limit", -1);
    public static final EnumOption<Options.YesNo> BINARY = new EnumOption<Options.YesNo>("binary", Options.YesNo.YES);
    public static final EnumOption<Options.YesNo> INDENT_ATTRIBUTES = new EnumOption<Options.YesNo>("indent-attributes", Options.YesNo.NO);

    public boolean yes(EnumOption<Options.YesNo> option) {
        return this.get(option) == Options.YesNo.YES;
    }

    public SerializerOptions() {
    }

    public SerializerOptions(SerializerOptions opts) {
        super(opts);
    }

    public void parse(String name, byte[] value, StaticContext sc, InputInfo ii) throws QueryException {
        try {
            this.assign(name, Token.string(value));
        }
        catch (BaseXException ex) {
            for (Option<?> o : this) {
                if (!o.name().equals(name)) continue;
                throw QueryError.SER_X.get(ii, ex);
            }
            throw QueryError.OUTINVALID_X.get(ii, ex);
        }
        if (name.equals(PARAMETER_DOCUMENT.name())) {
            HashMap<String, String> free;
            ANode root;
            Uri uri = Uri.get(value);
            if (!uri.isValid()) {
                throw QueryError.INVURI_X.get(ii, new Object[]{value});
            }
            if (!uri.isAbsolute()) {
                uri = sc.baseURI().resolve(uri, ii);
            }
            IO io = IO.get(Token.string(uri.string()));
            try {
                root = new DBNode(io).childIter().next();
            }
            catch (IOException ex) {
                throw QueryError.OUTDOC_X.get(ii, ex);
            }
            if (root != null) {
                FuncOptions.serializer(root, this, ii);
            }
            if (!(free = this.free()).isEmpty()) {
                throw QueryError.SEROPTION_X.get(ii, free.keySet().iterator().next());
            }
            for (ANode child : root.childIter()) {
                if (child.type != NodeType.ELEMENT || !Token.string(child.qname().local()).equals(USE_CHARACTER_MAPS.name())) continue;
                String map = SerializerOptions.characterMap(child);
                if (map == null) {
                    throw QueryError.SEROPTION_X.get(ii, USE_CHARACTER_MAPS.name());
                }
                this.set(USE_CHARACTER_MAPS, map);
            }
        }
    }

    public static String characterMap(ANode elem) {
        if (elem.attributeIter().next() != null) {
            return null;
        }
        TokenMap map = new TokenMap();
        for (ANode child : elem.childIter()) {
            if (child.type != NodeType.ELEMENT) continue;
            byte[] name = child.qname().local();
            if (Token.eq(name, QueryText.CHARACTER_MAP)) {
                byte[] key = null;
                byte[] val = null;
                for (ANode attr : child.attributeIter()) {
                    byte[] att = attr.name();
                    if (Token.eq(att, QueryText.CHARACTER)) {
                        key = attr.string();
                        continue;
                    }
                    if (Token.eq(att, QueryText.MAP_STRING)) {
                        val = attr.string();
                        continue;
                    }
                    return null;
                }
                if (key == null || val == null || map.get(key) != null) {
                    return null;
                }
                map.put(key, val);
                continue;
            }
            return null;
        }
        TokenBuilder tb = new TokenBuilder();
        for (byte[] key : map) {
            if (!tb.isEmpty()) {
                tb.add(44);
            }
            tb.add(key).add(61).add(Token.string(map.get(key)).replace(",", ",,"));
        }
        return tb.toString();
    }

    public static enum Newline {
        NL("\\n", "\n"),
        CR("\\r", "\r"),
        CRNL("\\r\\n", "\r\n");

        private final String name;
        private final String newline;

        private Newline(String name, String newline) {
            this.name = name;
            this.newline = newline;
        }

        String newline() {
            return this.newline;
        }

        public String toString() {
            return this.name;
        }
    }
}

