/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import org.basex.data.Data;
import org.basex.gui.view.ViewData;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;

final class MapList
extends IntList {
    double[] weight;

    MapList() {
    }

    MapList(int[] v) {
        super(v);
    }

    @Override
    public MapList sort() {
        this.sort(this.weight, false);
        return this;
    }

    void initWeights(int[] textLen, int nchildren, Data data, int w) {
        int i;
        this.weight = new double[this.size];
        if (w == 0) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                this.weight[i2] = (double)ViewData.size(data, this.list[i2]) / (double)nchildren;
            }
            return;
        }
        double sizeP = (double)w / 100.0;
        long sum = 0L;
        for (i = 0; i < this.size; ++i) {
            sum = (long)((double)sum + this.weight(textLen, data, i));
        }
        if (sizeP < 1.0) {
            for (i = 0; i < this.size; ++i) {
                this.weight[i] = sizeP * this.weight(textLen, data, i) / (double)sum + (1.0 - sizeP) * (double)ViewData.size(data, this.list[i]) / (double)nchildren;
            }
        } else {
            for (i = 0; i < this.size; ++i) {
                this.weight[i] = this.weight(textLen, data, i) / (double)sum;
            }
        }
    }

    private double weight(int[] textLen, Data data, int i) {
        byte[] val;
        double d = textLen != null ? (double)textLen[this.list[i]] : ((val = data.attValue(ViewData.sizeID(data), this.list[i])) != null ? (double)Token.toLong(val) : 0.0);
        return d > 1.0 ? d : 1.0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(Util.className(this) + "[");
        for (int i = 0; i < this.size; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.list[i]);
            if (this.weight == null) continue;
            sb.append('/').append(this.weight[i]);
        }
        return sb.append(']').toString();
    }
}

