/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.text.DecimalFormat;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXSerial;
import org.basex.gui.layout.BaseXSlider;
import org.basex.gui.layout.ColumnLayout;
import org.basex.gui.layout.RowLayout;
import org.basex.util.Performance;

final class DialogResultPrefs
extends BaseXBack {
    private static final int[] MAXRESULTS = new int[]{50000, 100000, 250000, 500000, 1000000, 2500000, Integer.MAX_VALUE};
    private static final int[] MAXTEXT = new int[]{0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, Integer.MAX_VALUE};
    private final GUI gui;
    private final BaseXSerial serial;
    private final BaseXSlider resultsMax;
    private final BaseXSlider textMax;
    private final BaseXLabel resultsLabel;
    private final BaseXLabel textLabel;

    DialogResultPrefs(BaseXDialog dialog) {
        this.border(8).setLayout(new RowLayout(0));
        this.gui = dialog.gui();
        int val = DialogResultPrefs.sliderIndex(this.gui.gopts.get(GUIOptions.MAXRESULTS), MAXRESULTS);
        this.resultsMax = new BaseXSlider(dialog, 0, MAXRESULTS.length - 1, val);
        this.resultsMax.addActionListener(e -> this.action());
        this.resultsLabel = new BaseXLabel(" ");
        val = DialogResultPrefs.sliderIndex(this.gui.gopts.get(GUIOptions.MAXTEXT), MAXTEXT);
        this.textMax = new BaseXSlider(dialog, 0, MAXTEXT.length - 1, val);
        this.textMax.addActionListener(e -> this.action());
        this.textLabel = new BaseXLabel(" ");
        this.serial = new BaseXSerial(dialog, this.gui.context.options.get(MainOptions.SERIALIZER));
        BaseXBack p = new BaseXBack(new RowLayout());
        BaseXBack pp = new BaseXBack(new ColumnLayout(12));
        pp.add(this.resultsMax);
        pp.add(this.resultsLabel);
        p.add(new BaseXLabel(Text.MAX_NO_OF_HITS + ":"));
        p.add(pp);
        pp = new BaseXBack(new ColumnLayout(12));
        pp.add(this.textMax);
        pp.add(this.textLabel);
        p.add(new BaseXLabel(Text.SIZE_TEXT_RESULTS + ":"));
        p.add(pp);
        this.add(new BaseXLabel(Text.LIMITS + ":", true, true));
        this.add(p);
        this.add(this.serial.border(16, 0, 0, 0));
    }

    boolean action() {
        int mt = MAXTEXT[this.textMax.getValue()];
        int mr = MAXRESULTS[this.resultsMax.getValue()];
        GUIOptions gopts = this.gui.gopts;
        gopts.set(GUIOptions.MAXTEXT, mt);
        gopts.set(GUIOptions.MAXRESULTS, mr);
        this.resultsLabel.setText(mr == Integer.MAX_VALUE ? Text.ALL : new DecimalFormat("#,###,###").format(mr));
        this.textLabel.setText(mt == Integer.MAX_VALUE ? Text.ALL : Performance.format(mt));
        return true;
    }

    void init() {
        this.serial.init(this.gui.context.options.get(MainOptions.SERIALIZER));
    }

    void cancel() {
        this.gui.set(MainOptions.SERIALIZER, this.serial.options());
    }

    private static int sliderIndex(int value, int[] values) {
        int hl = values.length - 1;
        int i = -1;
        while (++i < hl && values[i] < value) {
        }
        return i;
    }
}

