/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.common.NameSpace;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.DateUtils;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HandlerHelper;
import com.bradmcevoy.http.HttpExtension;
import com.bradmcevoy.http.LockToken;
import com.bradmcevoy.http.LockableResource;
import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.PutableResource;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceHandlerHelper;
import com.bradmcevoy.http.XmlWriter;
import com.bradmcevoy.http.http11.CustomPostHandler;
import com.bradmcevoy.http.http11.DefaultETagGenerator;
import com.bradmcevoy.http.http11.ETagGenerator;
import com.bradmcevoy.http.quota.DefaultQuotaDataAccessor;
import com.bradmcevoy.http.quota.QuotaDataAccessor;
import com.bradmcevoy.http.values.SupportedReportSetList;
import com.bradmcevoy.http.values.ValueWriters;
import com.bradmcevoy.http.webdav.CopyHandler;
import com.bradmcevoy.http.webdav.DefaultDisplayNameFormatter;
import com.bradmcevoy.http.webdav.DisplayNameFormatter;
import com.bradmcevoy.http.webdav.LockHandler;
import com.bradmcevoy.http.webdav.MkColHandler;
import com.bradmcevoy.http.webdav.MoveHandler;
import com.bradmcevoy.http.webdav.PropFindHandler;
import com.bradmcevoy.http.webdav.PropPatchHandler;
import com.bradmcevoy.http.webdav.PropPatchSetter;
import com.bradmcevoy.http.webdav.PropertyMap;
import com.bradmcevoy.http.webdav.PropertySourcePatchSetter;
import com.bradmcevoy.http.webdav.PropertySourceUtil;
import com.bradmcevoy.http.webdav.ResourceTypeHelper;
import com.bradmcevoy.http.webdav.UnlockHandler;
import com.bradmcevoy.http.webdav.WebDavResourceTypeHelper;
import com.bradmcevoy.http.webdav.WebDavResponseHandler;
import com.bradmcevoy.property.PropertySource;
import com.ettrema.http.report.Report;
import com.ettrema.http.report.ReportHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDavProtocol
implements HttpExtension,
PropertySource {
    private static final Logger log = LoggerFactory.getLogger(WebDavProtocol.class);
    public static final String DAV_URI = "DAV:";
    public static final String DAV_PREFIX = "d";
    public static final NameSpace NS_DAV = new NameSpace("DAV:", "d");
    private final Set<Handler> handlers;
    private final Map<String, Report> reports;
    private final ResourceTypeHelper resourceTypeHelper;
    private final QuotaDataAccessor quotaDataAccessor;
    private final PropertyMap propertyMap;
    private final List<PropertySource> propertySources;
    private ETagGenerator eTagGenerator;
    private final HandlerHelper handlerHelper;
    private DisplayNameFormatter displayNameFormatter = new DefaultDisplayNameFormatter();
    private final MkColHandler mkColHandler;
    private final PropPatchHandler propPatchHandler;
    private List<CustomPostHandler> customPostHandlers;

    public WebDavProtocol(WebDavResponseHandler responseHandler, HandlerHelper handlerHelper) {
        this(responseHandler, handlerHelper, new WebDavResourceTypeHelper());
    }

    public WebDavProtocol(WebDavResponseHandler responseHandler, HandlerHelper handlerHelper, ResourceTypeHelper resourceTypeHelper) {
        this(handlerHelper, resourceTypeHelper, responseHandler, PropertySourceUtil.createDefaultSources(resourceTypeHelper));
    }

    public WebDavProtocol(HandlerHelper handlerHelper, ResourceTypeHelper resourceTypeHelper, WebDavResponseHandler responseHandler, List<PropertySource> extraPropertySources) {
        this(handlerHelper, resourceTypeHelper, responseHandler, extraPropertySources, new DefaultQuotaDataAccessor());
    }

    public WebDavProtocol(HandlerHelper handlerHelper, ResourceTypeHelper resourceTypeHelper, WebDavResponseHandler responseHandler, List<PropertySource> extraPropertySources, QuotaDataAccessor quotaDataAccessor) {
        this(handlerHelper, resourceTypeHelper, responseHandler, extraPropertySources, quotaDataAccessor, null);
    }

    public WebDavProtocol(HandlerHelper handlerHelper, ResourceTypeHelper resourceTypeHelper, WebDavResponseHandler responseHandler, List<PropertySource> propertySources, QuotaDataAccessor quotaDataAccessor, PropPatchSetter patchSetter) {
        this.handlerHelper = handlerHelper;
        this.eTagGenerator = new DefaultETagGenerator();
        this.handlers = new HashSet<Handler>();
        this.resourceTypeHelper = resourceTypeHelper;
        this.quotaDataAccessor = quotaDataAccessor;
        this.propertyMap = new PropertyMap(NS_DAV.getName());
        log.info("resourceTypeHelper: " + resourceTypeHelper.getClass());
        if (quotaDataAccessor == null) {
            log.info("no quota data");
        } else {
            log.info("quotaDataAccessor: " + quotaDataAccessor.getClass());
        }
        this.propertyMap.add(new ContentLengthPropertyWriter());
        this.propertyMap.add(new ContentTypePropertyWriter());
        this.propertyMap.add(new CreationDatePropertyWriter("getcreated"));
        this.propertyMap.add(new CreationDatePropertyWriter("creationdate"));
        this.propertyMap.add(new DisplayNamePropertyWriter());
        this.propertyMap.add(new LastModifiedDatePropertyWriter());
        this.propertyMap.add(new ResourceTypePropertyWriter());
        this.propertyMap.add(new EtagPropertyWriter());
        this.propertyMap.add(new SupportedLockPropertyWriter());
        this.propertyMap.add(new LockDiscoveryPropertyWriter());
        this.propertyMap.add(new MSIsCollectionPropertyWriter());
        this.propertyMap.add(new MSIsReadOnlyPropertyWriter());
        this.propertyMap.add(new MSNamePropertyWriter());
        this.propertyMap.add(new QuotaAvailableBytesPropertyWriter());
        this.propertyMap.add(new QuotaUsedBytesPropertyWriter());
        this.propertyMap.add(new SupportedReportSetProperty());
        ResourceHandlerHelper resourceHandlerHelper = new ResourceHandlerHelper(handlerHelper, responseHandler);
        ValueWriters valueWriters = new ValueWriters();
        if (propertySources == null) {
            propertySources = new ArrayList<PropertySource>();
        }
        log.debug("provided property sources: " + propertySources.size());
        this.propertySources = propertySources;
        log.debug("adding webdav as a property source to: " + this.propertySources.getClass() + " hashCode: " + this.propertySources.hashCode());
        this.addPropertySource(this);
        if (patchSetter == null) {
            log.info("creating default patcheSetter: " + PropertySourcePatchSetter.class);
            patchSetter = new PropertySourcePatchSetter(propertySources, valueWriters);
        }
        this.handlers.add(new PropFindHandler(resourceHandlerHelper, resourceTypeHelper, responseHandler, propertySources));
        this.mkColHandler = new MkColHandler(responseHandler, handlerHelper);
        this.handlers.add(this.mkColHandler);
        this.propPatchHandler = new PropPatchHandler(resourceHandlerHelper, responseHandler, patchSetter);
        this.handlers.add(this.propPatchHandler);
        this.handlers.add(new CopyHandler(responseHandler, handlerHelper, resourceHandlerHelper));
        this.handlers.add(new LockHandler(responseHandler, handlerHelper));
        this.handlers.add(new UnlockHandler(resourceHandlerHelper, responseHandler));
        this.handlers.add(new MoveHandler(responseHandler, handlerHelper, resourceHandlerHelper));
        this.reports = new HashMap<String, Report>();
        this.handlers.add(new ReportHandler(responseHandler, resourceHandlerHelper, this.reports));
    }

    @Override
    public List<CustomPostHandler> getCustomPostHandlers() {
        return this.customPostHandlers;
    }

    public void setCustomPostHandlers(List<CustomPostHandler> customPostHandlers) {
        this.customPostHandlers = customPostHandlers;
    }

    public List<PropertySource> getPropertySources() {
        return Collections.unmodifiableList(this.propertySources);
    }

    public void addPropertySource(PropertySource ps) {
        this.propertySources.add(ps);
        log.debug("adding property source: " + ps.getClass() + " new size: " + this.propertySources.size());
    }

    public void addReport(Report report) {
        this.reports.put(report.getName(), report);
    }

    @Override
    public Set<Handler> getHandlers() {
        return Collections.unmodifiableSet(this.handlers);
    }

    @Override
    public Object getProperty(QName name, Resource r) {
        Object o = this.propertyMap.getProperty(name, r);
        return o;
    }

    @Override
    public void setProperty(QName name, Object value, Resource r) {
        throw new UnsupportedOperationException("Not supported. Standard webdav properties are not writable");
    }

    @Override
    public PropertySource.PropertyMetaData getPropertyMetaData(QName name, Resource r) {
        PropertySource.PropertyMetaData propertyMetaData = this.propertyMap.getPropertyMetaData(name, r);
        return propertyMetaData;
    }

    @Override
    public void clearProperty(QName name, Resource r) {
        throw new UnsupportedOperationException("Not supported. Standard webdav properties are not writable");
    }

    @Override
    public List<QName> getAllPropertyNames(Resource r) {
        return this.propertyMap.getAllPropertyNames(r);
    }

    public DisplayNameFormatter getDisplayNameFormatter() {
        return this.displayNameFormatter;
    }

    public void setDisplayNameFormatter(DisplayNameFormatter displayNameFormatter) {
        this.displayNameFormatter = displayNameFormatter;
    }

    protected void sendStringProp(XmlWriter writer, String name, String value) {
        String s = value;
        if (s == null) {
            writer.writeProperty(null, name);
        } else {
            writer.writeProperty(null, name, s);
        }
    }

    void sendDateProp(XmlWriter writer, String name, Date date) {
        this.sendStringProp(writer, name, date == null ? null : DateUtils.formatDate(date));
    }

    public HandlerHelper getHandlerHelper() {
        return this.handlerHelper;
    }

    public QuotaDataAccessor getQuotaDataAccessor() {
        return this.quotaDataAccessor;
    }

    public Map<String, Report> getReports() {
        return this.reports;
    }

    public ResourceTypeHelper getResourceTypeHelper() {
        return this.resourceTypeHelper;
    }

    public ETagGenerator geteTagGenerator() {
        return this.eTagGenerator;
    }

    public PropertyMap getPropertyMap() {
        return this.propertyMap;
    }

    public MkColHandler getMkColHandler() {
        return this.mkColHandler;
    }

    public PropPatchHandler getPropPatchHandler() {
        return this.propPatchHandler;
    }

    public void seteTagGenerator(ETagGenerator eTagGenerator) {
        this.eTagGenerator = eTagGenerator;
    }

    class SupportedReportSetProperty
    implements PropertyMap.StandardProperty<SupportedReportSetList> {
        SupportedReportSetProperty() {
        }

        @Override
        public String fieldName() {
            return "supported-report-set";
        }

        @Override
        public SupportedReportSetList getValue(PropFindableResource res) {
            SupportedReportSetList reportSet = new SupportedReportSetList();
            for (String reportName : WebDavProtocol.this.reports.keySet()) {
                reportSet.add(reportName);
            }
            return reportSet;
        }

        @Override
        public Class getValueClass() {
            return SupportedReportSetList.class;
        }
    }

    class MSIsReadOnlyPropertyWriter
    implements PropertyMap.StandardProperty<Boolean> {
        MSIsReadOnlyPropertyWriter() {
        }

        @Override
        public String fieldName() {
            return "isreadonly";
        }

        @Override
        public Boolean getValue(PropFindableResource res) {
            return !(res instanceof PutableResource);
        }

        @Override
        public Class getValueClass() {
            return Boolean.class;
        }
    }

    class MSIsCollectionPropertyWriter
    implements PropertyMap.StandardProperty<Boolean> {
        MSIsCollectionPropertyWriter() {
        }

        @Override
        public String fieldName() {
            return "iscollection";
        }

        @Override
        public Boolean getValue(PropFindableResource res) {
            return res instanceof CollectionResource;
        }

        @Override
        public Class getValueClass() {
            return Boolean.class;
        }
    }

    class MSNamePropertyWriter
    extends DisplayNamePropertyWriter {
        MSNamePropertyWriter() {
        }

        @Override
        public String fieldName() {
            return "name";
        }
    }

    class SupportedLockPropertyWriter
    implements PropertyMap.StandardProperty<SupportedLocks> {
        SupportedLockPropertyWriter() {
        }

        @Override
        public SupportedLocks getValue(PropFindableResource res) {
            if (res instanceof LockableResource) {
                return new SupportedLocks(res);
            }
            return null;
        }

        @Override
        public String fieldName() {
            return "supportedlock";
        }

        @Override
        public Class getValueClass() {
            return SupportedLocks.class;
        }
    }

    class LockDiscoveryPropertyWriter
    implements PropertyMap.StandardProperty<LockToken> {
        LockDiscoveryPropertyWriter() {
        }

        @Override
        public LockToken getValue(PropFindableResource res) {
            if (!(res instanceof LockableResource)) {
                return null;
            }
            LockableResource lr = (LockableResource)((Object)res);
            LockToken token = lr.getCurrentLock();
            return token;
        }

        @Override
        public String fieldName() {
            return "lockdiscovery";
        }

        @Override
        public Class getValueClass() {
            return LockToken.class;
        }
    }

    class EtagPropertyWriter
    implements PropertyMap.StandardProperty<String> {
        EtagPropertyWriter() {
        }

        @Override
        public String getValue(PropFindableResource res) {
            String etag = WebDavProtocol.this.eTagGenerator.generateEtag(res);
            return etag;
        }

        @Override
        public String fieldName() {
            return "getetag";
        }

        @Override
        public Class getValueClass() {
            return String.class;
        }
    }

    class QuotaAvailableBytesPropertyWriter
    implements PropertyMap.StandardProperty<Long> {
        QuotaAvailableBytesPropertyWriter() {
        }

        @Override
        public Long getValue(PropFindableResource res) {
            if (WebDavProtocol.this.quotaDataAccessor != null) {
                return WebDavProtocol.this.quotaDataAccessor.getQuotaAvailable(res);
            }
            return null;
        }

        @Override
        public String fieldName() {
            return "quota-available-bytes";
        }

        @Override
        public Class getValueClass() {
            return Long.class;
        }
    }

    class QuotaUsedBytesPropertyWriter
    implements PropertyMap.StandardProperty<Long> {
        QuotaUsedBytesPropertyWriter() {
        }

        @Override
        public Long getValue(PropFindableResource res) {
            if (WebDavProtocol.this.quotaDataAccessor != null) {
                return WebDavProtocol.this.quotaDataAccessor.getQuotaUsed(res);
            }
            return null;
        }

        @Override
        public String fieldName() {
            return "quota-used-bytes";
        }

        @Override
        public Class getValueClass() {
            return Long.class;
        }
    }

    class ContentLengthPropertyWriter
    implements PropertyMap.StandardProperty<Long> {
        ContentLengthPropertyWriter() {
        }

        @Override
        public Long getValue(PropFindableResource res) {
            if (res instanceof GetableResource) {
                GetableResource getable = (GetableResource)((Object)res);
                Long l = getable.getContentLength();
                return l;
            }
            return null;
        }

        @Override
        public String fieldName() {
            return "getcontentlength";
        }

        @Override
        public Class getValueClass() {
            return Long.class;
        }
    }

    class ContentTypePropertyWriter
    implements PropertyMap.StandardProperty<String> {
        ContentTypePropertyWriter() {
        }

        @Override
        public String getValue(PropFindableResource res) {
            if (res instanceof GetableResource) {
                GetableResource getable = (GetableResource)((Object)res);
                String s = getable.getContentType(null);
                return s;
            }
            return "";
        }

        @Override
        public String fieldName() {
            return "getcontenttype";
        }

        @Override
        public Class getValueClass() {
            return String.class;
        }
    }

    class ResourceTypePropertyWriter
    implements PropertyMap.StandardProperty<List<QName>> {
        ResourceTypePropertyWriter() {
        }

        @Override
        public List<QName> getValue(PropFindableResource res) {
            log.trace("ResourceTypePropertyWriter:getValue");
            return WebDavProtocol.this.resourceTypeHelper.getResourceTypes(res);
        }

        @Override
        public String fieldName() {
            return "resourcetype";
        }

        @Override
        public Class getValueClass() {
            return List.class;
        }
    }

    class LastModifiedDatePropertyWriter
    implements PropertyMap.StandardProperty<Date> {
        LastModifiedDatePropertyWriter() {
        }

        @Override
        public String fieldName() {
            return "getlastmodified";
        }

        @Override
        public Date getValue(PropFindableResource res) {
            return res.getModifiedDate();
        }

        @Override
        public Class<Date> getValueClass() {
            return Date.class;
        }
    }

    class CreationDatePropertyWriter
    implements PropertyMap.StandardProperty<Date> {
        private final String fieldName;

        public CreationDatePropertyWriter(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String fieldName() {
            return this.fieldName;
        }

        @Override
        public Date getValue(PropFindableResource res) {
            return res.getCreateDate();
        }

        @Override
        public Class<Date> getValueClass() {
            return Date.class;
        }
    }

    class DisplayNamePropertyWriter
    implements PropertyMap.StandardProperty<String> {
        DisplayNamePropertyWriter() {
        }

        @Override
        public String getValue(PropFindableResource res) {
            return WebDavProtocol.this.displayNameFormatter.formatDisplayName(res);
        }

        @Override
        public String fieldName() {
            return "displayname";
        }

        @Override
        public Class<String> getValueClass() {
            return String.class;
        }
    }

    public static class SupportedLocks {
        private final PropFindableResource res;

        public SupportedLocks(PropFindableResource res) {
            this.res = res;
        }

        public PropFindableResource getResource() {
            return this.res;
        }
    }
}

