/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11.auth;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.http11.auth.DigestResponse;
import com.bradmcevoy.http.http11.auth.NonceProvider;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestHelper {
    private static final Logger log = LoggerFactory.getLogger(DigestHelper.class);
    private final NonceProvider nonceProvider;

    public DigestHelper(NonceProvider nonceProvider) {
        this.nonceProvider = nonceProvider;
    }

    public DigestResponse calculateResponse(Auth auth, String expectedRealm, Request.Method method) {
        Long nc;
        if (auth.getUser() == null || auth.getRealm() == null || auth.getNonce() == null || auth.getUri() == null) {
            log.warn("missing params");
            return null;
        }
        if ("auth".equals(auth.getQop())) {
            if (auth.getNc() == null || auth.getCnonce() == null) {
                log.warn("missing params: nc and/or cnonce");
                return null;
            }
            nc = Long.parseLong(auth.getNc(), 16);
        } else {
            nc = null;
        }
        if (expectedRealm == null) {
            throw new IllegalStateException("realm is null");
        }
        if (!expectedRealm.equals(auth.getRealm())) {
            log.warn("incorrect realm: resource: " + expectedRealm + " given: " + auth.getRealm());
            return null;
        }
        if (!Base64.isArrayByteBase64((byte[])auth.getNonce().getBytes())) {
            log.warn("nonce not base64 encoded");
            return null;
        }
        log.debug("nc: " + auth.getNc());
        String plainTextNonce = new String(Base64.decodeBase64((byte[])auth.getNonce().getBytes()));
        NonceProvider.NonceValidity validity = this.nonceProvider.getNonceValidity(plainTextNonce, nc);
        DigestResponse resp = this.toDigestResponse(auth, method);
        return resp;
    }

    public String getChallenge(String nonceValue, Auth auth, String actualRealm) {
        String nonceValueBase64 = new String(Base64.encodeBase64((byte[])nonceValue.getBytes()));
        String authenticateHeader = "Digest realm=\"" + actualRealm + "\", " + "qop=\"auth\", nonce=\"" + nonceValueBase64 + "\"";
        if (auth != null && auth.isNonceStale()) {
            authenticateHeader = authenticateHeader + ", stale=\"true\"";
        }
        return authenticateHeader;
    }

    private DigestResponse toDigestResponse(Auth auth, Request.Method m) {
        DigestResponse dr = new DigestResponse(m, auth.getUser(), auth.getRealm(), auth.getNonce(), auth.getUri(), auth.getResponseDigest(), auth.getQop(), auth.getNc(), auth.getCnonce());
        return dr;
    }
}

