/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11;

import com.bradmcevoy.common.ContentTypeService;
import com.bradmcevoy.common.DefaultContentTypeService;
import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HandlerHelper;
import com.bradmcevoy.http.HttpExtension;
import com.bradmcevoy.http.http11.CustomPostHandler;
import com.bradmcevoy.http.http11.DefaultETagGenerator;
import com.bradmcevoy.http.http11.DefaultMatchHelper;
import com.bradmcevoy.http.http11.DeleteHandler;
import com.bradmcevoy.http.http11.ETagGenerator;
import com.bradmcevoy.http.http11.GetHandler;
import com.bradmcevoy.http.http11.Http11ResponseHandler;
import com.bradmcevoy.http.http11.OptionsHandler;
import com.bradmcevoy.http.http11.PostHandler;
import com.bradmcevoy.http.http11.PutHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Http11Protocol
implements HttpExtension {
    private final Set<Handler> handlers;
    private final HandlerHelper handlerHelper;
    private List<CustomPostHandler> customPostHandlers;

    public Http11Protocol(Set<Handler> handlers, HandlerHelper handlerHelper) {
        this.handlers = handlers;
        this.handlerHelper = handlerHelper;
    }

    public Http11Protocol(Http11ResponseHandler responseHandler, HandlerHelper handlerHelper) {
        this(responseHandler, handlerHelper, null, false, null);
    }

    public Http11Protocol(Http11ResponseHandler responseHandler, HandlerHelper handlerHelper, ContentTypeService contentTypeService) {
        this(responseHandler, handlerHelper, contentTypeService, false, null);
    }

    public Http11Protocol(Http11ResponseHandler responseHandler, HandlerHelper handlerHelper, ContentTypeService contentTypeService, boolean enableOptionsAuth, ETagGenerator eTagGenerator) {
        this.handlers = new HashSet<Handler>();
        this.handlerHelper = handlerHelper;
        if (contentTypeService == null) {
            contentTypeService = new DefaultContentTypeService();
        }
        if (eTagGenerator == null) {
            eTagGenerator = new DefaultETagGenerator();
        }
        DefaultMatchHelper matchHelper = new DefaultMatchHelper(eTagGenerator);
        this.handlers.add(new OptionsHandler(responseHandler, handlerHelper, enableOptionsAuth));
        this.handlers.add(new GetHandler(responseHandler, handlerHelper, matchHelper));
        this.handlers.add(new PostHandler(responseHandler, handlerHelper));
        this.handlers.add(new DeleteHandler(responseHandler, handlerHelper));
        this.handlers.add(new PutHandler(responseHandler, handlerHelper, contentTypeService, matchHelper));
    }

    @Override
    public Set<Handler> getHandlers() {
        return this.handlers;
    }

    public HandlerHelper getHandlerHelper() {
        return this.handlerHelper;
    }

    @Override
    public List<CustomPostHandler> getCustomPostHandlers() {
        return this.customPostHandlers;
    }
}

