/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.AuthenticationService;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.ConditionalCompatibleResource;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.LockToken;
import com.bradmcevoy.http.LockableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.http11.Http11ResponseHandler;
import com.bradmcevoy.http.quota.DefaultStorageChecker;
import com.bradmcevoy.http.quota.StorageChecker;
import com.ettrema.common.LogUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerHelper {
    private static final Logger log = LoggerFactory.getLogger(HandlerHelper.class);
    private AuthenticationService authenticationService;
    private final List<StorageChecker> storageCheckers;
    private boolean enableExpectContinue = true;

    public HandlerHelper(AuthenticationService authenticationService, List<StorageChecker> storageCheckers) {
        this.authenticationService = authenticationService;
        this.storageCheckers = storageCheckers;
    }

    public HandlerHelper(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
        this.storageCheckers = new ArrayList<StorageChecker>();
        this.storageCheckers.add(new DefaultStorageChecker());
    }

    public boolean checkExpects(Http11ResponseHandler responseHandler, Request request, Response response) {
        if (this.enableExpectContinue) {
            String s = request.getExpectHeader();
            LogUtils.trace(log, "checkExpects", s);
            if (s != null && s.length() > 0) {
                response.setStatus(Response.Status.SC_CONTINUE);
                return false;
            }
            return true;
        }
        return true;
    }

    public AuthenticationService.AuthStatus checkAuthentication(HttpManager manager, Resource resource, Request request) {
        log.trace("checkAuthentication");
        AuthenticationService.AuthStatus authStatus = this.authenticationService.authenticate(resource, request);
        if (authStatus == null) {
            log.trace("checkAuthentication: null authStatus");
            return null;
        }
        log.trace("checkAuthentication: authStatus.failed =" + authStatus.loginFailed);
        return authStatus;
    }

    public boolean checkAuthorisation(HttpManager manager, Resource resource, Request request) {
        Auth auth;
        log.trace("checkAuthorisation");
        AuthenticationService.AuthStatus authStatus = this.checkAuthentication(manager, resource, request);
        if (authStatus != null && authStatus.loginFailed) {
            log.trace("checkAuthorisation: loginFailed");
            return false;
        }
        if (authStatus != null) {
            log.trace("checkAuthorisation: got auth object");
            auth = authStatus.auth;
        } else {
            log.trace("checkAuthorisation: authStatus is null, no authentication was attempted");
            auth = null;
        }
        boolean authorised = resource.authorise(request, request.getMethod(), auth);
        if (!authorised) {
            if (log.isWarnEnabled()) {
                log.warn("authorisation declined, requesting authentication: " + request.getAbsolutePath() + ". resource type: " + resource.getClass().getCanonicalName());
            }
            if (auth != null) {
                if (log.isTraceEnabled()) {
                    log.trace("  - auth: " + auth.getUser() + " tag: " + auth.getTag());
                }
            } else {
                log.trace("  - anonymous request");
            }
            return false;
        }
        return true;
    }

    public boolean doCheckRedirect(Http11ResponseHandler responseHandler, Request request, Response response, Resource resource) {
        String redirectUrl = resource.checkRedirect(request);
        if (redirectUrl != null && redirectUrl.length() > 0) {
            responseHandler.respondRedirect(response, request, redirectUrl);
            return true;
        }
        return false;
    }

    public boolean isLockedOut(Request inRequest, Resource inResource) {
        if (inResource == null || !(inResource instanceof LockableResource)) {
            return false;
        }
        LockableResource lr = (LockableResource)inResource;
        LockToken token = lr.getCurrentLock();
        if (token != null) {
            Auth auth = inRequest.getAuthorization();
            String sUser = null;
            if (auth != null) {
                sUser = auth.getUser();
            }
            if (token.info == null) {
                log.warn("Found a lock on this resource, but it has no info property so is ignored");
                return false;
            }
            String lockedByUser = token.info.lockedByUser;
            if (lockedByUser == null) {
                log.warn("Resource is locked with a null user. Ignoring the lock");
                return false;
            }
            if (!lockedByUser.equals(sUser)) {
                String value;
                if (log.isInfoEnabled()) {
                    if (auth == null) {
                        log.trace("lock owned by: " + lockedByUser);
                    } else {
                        log.trace("lock owned by: " + lockedByUser + " not by " + auth.getUser());
                    }
                }
                if ((value = inRequest.getIfHeader()) != null && value.contains("opaquelocktoken:" + token.tokenId + ">")) {
                    log.trace("Request contains valid token so operation is permitted");
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean missingLock(Request inRequest, Resource inParentcol) {
        String value = inRequest.getIfHeader();
        if (value != null && value.contains("(<DAV:no-lock>)")) {
            log.info("Contained valid token. so is unlocked");
            return true;
        }
        return false;
    }

    public StorageChecker.StorageErrorReason checkStorageOnReplace(Request request, CollectionResource parentCol, Resource replaced, String host) {
        for (StorageChecker sc : this.storageCheckers) {
            StorageChecker.StorageErrorReason res = sc.checkStorageOnReplace(request, parentCol, replaced, host);
            if (res == null) continue;
            log.warn("insufficient storage reason: " + (Object)((Object)res) + " reported by: " + sc.getClass());
            return res;
        }
        return null;
    }

    public StorageChecker.StorageErrorReason checkStorageOnAdd(Request request, CollectionResource nearestParent, Path parentPath, String host) {
        for (StorageChecker sc : this.storageCheckers) {
            StorageChecker.StorageErrorReason res = sc.checkStorageOnAdd(request, nearestParent, parentPath, host);
            if (res == null) continue;
            log.warn("insufficient storage reason: " + (Object)((Object)res) + " reported by: " + sc.getClass());
            return res;
        }
        return null;
    }

    public boolean isNotCompatible(Resource r, Request.Method m) {
        if (r instanceof ConditionalCompatibleResource) {
            ConditionalCompatibleResource ccr = (ConditionalCompatibleResource)((Object)r);
            return !ccr.isCompatible(m);
        }
        return false;
    }

    public boolean isEnableExpectContinue() {
        return this.enableExpectContinue;
    }

    public void setEnableExpectContinue(boolean enableExpectContinue) {
        this.enableExpectContinue = enableExpectContinue;
    }
}

