/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.Objects;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.path.Test;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.list.ElementList;
import org.basex.util.list.ObjectList;

public final class SeqType {
    public static final SeqType EMPTY_SEQUENCE_Z = AtomType.ITEM.seqType(Occ.ZERO);
    public static final SeqType ITEM_O = AtomType.ITEM.seqType();
    public static final SeqType ITEM_ZO = AtomType.ITEM.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType ITEM_ZM = AtomType.ITEM.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType ITEM_OM = AtomType.ITEM.seqType(Occ.ONE_OR_MORE);
    public static final SeqType ANY_ATOMIC_TYPE_O = AtomType.ANY_ATOMIC_TYPE.seqType();
    public static final SeqType ANY_ATOMIC_TYPE_ZO = AtomType.ANY_ATOMIC_TYPE.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType ANY_ATOMIC_TYPE_ZM = AtomType.ANY_ATOMIC_TYPE.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType NUMERIC_O = AtomType.NUMERIC.seqType();
    public static final SeqType NUMERIC_ZO = AtomType.NUMERIC.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType DOUBLE_O = AtomType.DOUBLE.seqType();
    public static final SeqType DOUBLE_ZO = AtomType.DOUBLE.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType DOUBLE_ZM = AtomType.DOUBLE.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType FLOAT_O = AtomType.FLOAT.seqType();
    public static final SeqType DECIMAL_O = AtomType.DECIMAL.seqType();
    public static final SeqType DECIMAL_ZO = AtomType.DECIMAL.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType INTEGER_O = AtomType.INTEGER.seqType();
    public static final SeqType INTEGER_ZO = AtomType.INTEGER.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType INTEGER_ZM = AtomType.INTEGER.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType BYTE_ZM = AtomType.BYTE.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType STRING_O = AtomType.STRING.seqType();
    public static final SeqType STRING_ZO = AtomType.STRING.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType STRING_ZM = AtomType.STRING.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType NCNAME_ZO = AtomType.NCNAME.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType LANGUAGE_O = AtomType.LANGUAGE.seqType();
    public static final SeqType UNTYPED_ATOMIC_ZO = AtomType.UNTYPED_ATOMIC.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType ANY_URI_O = AtomType.ANY_URI.seqType();
    public static final SeqType ANY_URI_ZO = AtomType.ANY_URI.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType ANY_URI_ZM = AtomType.ANY_URI.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType QNAME_O = AtomType.QNAME.seqType();
    public static final SeqType QNAME_ZO = AtomType.QNAME.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType BOOLEAN_O = AtomType.BOOLEAN.seqType();
    public static final SeqType BOOLEAN_ZO = AtomType.BOOLEAN.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType DATE_O = AtomType.DATE.seqType();
    public static final SeqType DATE_ZO = AtomType.DATE.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType DAY_TIME_DURATION_O = AtomType.DAY_TIME_DURATION.seqType();
    public static final SeqType DAY_TIME_DURATION_ZO = AtomType.DAY_TIME_DURATION.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType DATE_TIME_O = AtomType.DATE_TIME.seqType();
    public static final SeqType DATE_TIME_ZO = AtomType.DATE_TIME.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType TIME_O = AtomType.TIME.seqType();
    public static final SeqType TIME_ZO = AtomType.TIME.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType DURATION_ZO = AtomType.DURATION.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType BINARY_O = AtomType.BINARY.seqType();
    public static final SeqType HEX_BINARY_O = AtomType.HEX_BINARY.seqType();
    public static final SeqType HEX_BINARY_ZO = AtomType.HEX_BINARY.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType BASE64_BINARY_O = AtomType.BASE64_BINARY.seqType();
    public static final SeqType BASE64_BINARY_ZO = AtomType.BASE64_BINARY.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType BASE64_BINARY_ZM = AtomType.BASE64_BINARY.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType NODE_O = NodeType.NODE.seqType();
    public static final SeqType NODE_ZO = NodeType.NODE.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType NODE_ZM = NodeType.NODE.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType NODE_OM = NodeType.NODE.seqType(Occ.ONE_OR_MORE);
    public static final SeqType ATTRIBUTE_O = NodeType.ATTRIBUTE.seqType();
    public static final SeqType ATTRIBUTE_ZM = NodeType.ATTRIBUTE.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType COMMENT_O = NodeType.COMMENT.seqType();
    public static final SeqType DOCUMENT_NODE_O = NodeType.DOCUMENT_NODE.seqType();
    public static final SeqType DOCUMENT_NODE_ZO = NodeType.DOCUMENT_NODE.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType DOCUMENT_NODE_ZM = NodeType.DOCUMENT_NODE.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType ELEMENT_O = NodeType.ELEMENT.seqType();
    public static final SeqType ELEMENT_ZM = NodeType.ELEMENT.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType NAMESPACE_NODE_O = NodeType.NAMESPACE_NODE.seqType();
    public static final SeqType PROCESSING_INSTRUCTION_O = NodeType.PROCESSING_INSTRUCTION.seqType();
    public static final SeqType TEXT_ZO = NodeType.TEXT.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType TEXT_ZM = NodeType.TEXT.seqType(Occ.ZERO_OR_MORE);
    public static final FuncType FUNCTION = new FuncType(null, (SeqType[])null);
    public static final FuncType JAVA = new FuncType(null, new SeqType[0]);
    public static final MapType MAP = new MapType(AtomType.ANY_ATOMIC_TYPE, ITEM_ZM);
    public static final ArrayType ARRAY = new ArrayType(ITEM_ZM);
    public static final SeqType FUNCTION_O = FUNCTION.seqType();
    public static final SeqType FUNCTION_ZO = FUNCTION.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType FUNCTION_ZM = FUNCTION.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType PREDICATE_O = FuncType.get(BOOLEAN_O, ITEM_O).seqType();
    public static final SeqType PREDICATE_ZM = FuncType.get(BOOLEAN_O, ITEM_ZM).seqType();
    public static final SeqType BIPREDICATE_O = FuncType.get(BOOLEAN_O, ITEM_O, ITEM_O).seqType();
    public static final SeqType MAP_O = MAP.seqType();
    public static final SeqType MAP_ZO = MAP.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType MAP_ZM = MAP.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType ARRAY_O = ARRAY.seqType();
    public static final SeqType ARRAY_ZM = ARRAY.seqType(Occ.ZERO_OR_MORE);
    public final Type type;
    public final Occ occ;
    private final Test test;

    SeqType(Type type, Occ occ) {
        this(type, occ, null);
    }

    private SeqType(Type type, Occ occ, Test test) {
        this.type = type;
        this.occ = occ;
        this.test = test;
    }

    public static SeqType get(Type type, Occ occ) {
        return occ == Occ.ZERO ? EMPTY_SEQUENCE_Z : type.seqType(occ);
    }

    public static SeqType get(Type type, Occ occ, Test test) {
        return occ == Occ.ZERO || test == null || !(type instanceof NodeType) ? SeqType.get(type, occ) : new SeqType(type, occ, test);
    }

    public SeqType with(Occ oc) {
        return oc == this.occ ? this : SeqType.get(this.type, oc, this.test);
    }

    public SeqType union(Occ oc) {
        return oc == this.occ ? this : SeqType.get(this.type, this.occ.union(oc), this.test);
    }

    public boolean instance(Value value) {
        long size = value.size();
        if (!this.occ.check(size)) {
            return false;
        }
        if (size == 1L) {
            return this.instance((Item)value);
        }
        if (size == 0L) {
            return true;
        }
        SeqType st = value.seqType();
        if (st.type.instanceOf(this.type) && st.kindInstanceOf(this)) {
            return true;
        }
        for (Item item : value) {
            if (this.instance(item)) continue;
            return false;
        }
        return true;
    }

    public boolean instance(Item item) {
        return item.instanceOf(this.type) && (this.test == null || this.test.matches(item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value cast(Value value, boolean error, QueryContext qc, StaticContext sc, InputInfo ii) throws QueryException {
        long size = value.size();
        if (!this.occ.check(size)) {
            if (error) {
                throw QueryError.INVCONVERT_X_X_X.get(ii, value.seqType(), this, value);
            }
            return null;
        }
        if (size == 0L) {
            return Empty.VALUE;
        }
        try {
            if (!error && ii != null) {
                ii.internal(true);
            }
            if (size == 1L) {
                Item item = (Item)value;
                Item item2 = item.type.eq(this.type) ? item : this.type.cast(item, qc, sc, ii);
                return item2;
            }
            ValueBuilder vb = new ValueBuilder(qc);
            for (Item item : value) {
                if (item.type.eq(this.type)) {
                    vb.add(item);
                    continue;
                }
                qc.checkStop();
                vb.add(this.type.cast(item, qc, sc, ii));
            }
            Value value2 = vb.value(this.type);
            return value2;
        }
        catch (QueryException ex) {
            if (error) {
                throw ex;
            }
            Value value3 = null;
            return value3;
        }
        finally {
            if (!error && ii != null) {
                ii.internal(false);
            }
        }
    }

    public Value promote(Value value, QNm name, QueryContext qc, StaticContext sc, InputInfo ii, boolean opt) throws QueryException {
        long is;
        long size = value.size();
        ElementList items = null;
        for (long i = 0L; i < size; ++i) {
            qc.checkStop();
            Item item = value.itemAt(i);
            if (this.instance(item)) {
                if (items == null) continue;
                ((ObjectList)items).add(item);
                continue;
            }
            if (items == null) {
                items = new ItemList(Seq.initialCapacity(size));
                int j = 0;
                while ((long)j < i) {
                    ((ObjectList)items).add(value.itemAt(j));
                    ++j;
                }
            }
            this.promote(item, name, (ItemList)items, qc, sc, ii, opt);
        }
        long l = is = items != null ? (long)items.size() : value.size();
        if (!this.occ.check(is)) {
            throw QueryError.typeError((Expr)value, this, name, ii, true);
        }
        return items != null ? ((ItemList)items).value(this.type) : value;
    }

    public void promote(Item item, QNm name, ItemList items, QueryContext qc, StaticContext sc, InputInfo ii, boolean opt) throws QueryException {
        if (this.type instanceof AtomType) {
            Item item1;
            BasicIter<Item> iter = item.atomValue(qc, ii).iter();
            while ((item1 = qc.next(iter)) != null) {
                Type tp = item1.type;
                if (tp.instanceOf(this.type)) {
                    items.add(item1);
                    continue;
                }
                if (tp == AtomType.UNTYPED_ATOMIC) {
                    Item item2;
                    if (this.type.nsSensitive()) {
                        throw QueryError.NSSENS_X_X.get(ii, item.type, this.type);
                    }
                    BasicIter<Item> iter2 = this.type.cast(item1, qc, sc, ii).iter();
                    while ((item2 = qc.next(iter2)) != null) {
                        items.add(item2);
                    }
                    continue;
                }
                if (this.type == AtomType.DOUBLE && (tp == AtomType.FLOAT || tp.instanceOf(AtomType.DECIMAL))) {
                    items.add(Dbl.get(item1.dbl(ii)));
                    continue;
                }
                if (this.type == AtomType.FLOAT && tp.instanceOf(AtomType.DECIMAL)) {
                    items.add(Flt.get(item1.flt(ii)));
                    continue;
                }
                if (this.type == AtomType.STRING && item1 instanceof Uri) {
                    items.add(Str.get(item1.string(ii)));
                    continue;
                }
                throw QueryError.typeError((Expr)item, this.with(Occ.EXACTLY_ONE), name, ii, true);
            }
        } else if (item instanceof FItem && this.type instanceof FuncType) {
            items.add(((FItem)item).coerceTo((FuncType)this.type, qc, ii, opt));
        } else {
            throw QueryError.typeError((Expr)item, this.with(Occ.EXACTLY_ONE), name, ii, true);
        }
    }

    public boolean promotable(SeqType st) {
        if (this.intersect(st) != null) {
            return true;
        }
        if (this.occ.intersect(st.occ) == null) {
            return false;
        }
        Type tp = st.type;
        if (tp instanceof AtomType) {
            if (this.type.isUntyped()) {
                return !tp.nsSensitive();
            }
            return tp == AtomType.DOUBLE && (this.type.intersect(AtomType.FLOAT) != null || this.type.intersect(AtomType.DECIMAL) != null) || tp == AtomType.FLOAT && this.type.intersect(AtomType.DECIMAL) != null || tp == AtomType.STRING && this.type.intersect(AtomType.ANY_URI) != null;
        }
        return st.type instanceof FuncType && this.type instanceof FuncType;
    }

    public SeqType union(SeqType st) {
        if (this == st) {
            return this;
        }
        Type tp = st.zero() ? this.type : (this.zero() ? st.type : this.type.union(st.type));
        Occ oc = this.occ.union(st.occ);
        Test ts = st.zero() ? this.test : (this.zero() ? st.test : Test.get(this.test, st.test));
        return SeqType.get(tp, oc, ts);
    }

    public static SeqType union(Expr[] exprs, boolean zero) {
        SeqType st = null;
        for (Expr expr : exprs) {
            SeqType st2 = expr.seqType();
            if (!zero && st2.zero()) continue;
            st = st == null ? st2 : st.union(st2);
        }
        return st;
    }

    public SeqType intersect(SeqType st) {
        if (this == st) {
            return this;
        }
        Type tp = this.type.intersect(st.type);
        if (tp == null) {
            return null;
        }
        Occ oc = this.occ.intersect(st.occ);
        if (oc == null) {
            return null;
        }
        if (this.test == null || st.test == null || this.test.equals(st.test)) {
            return SeqType.get(tp, oc, this.test != null ? this.test : st.test);
        }
        Test kn = this.test.intersect(st.test);
        return kn == null ? null : SeqType.get(tp, oc, kn);
    }

    public boolean zeroOrOne() {
        return this.occ.max <= 1L;
    }

    public boolean zero() {
        return this.occ == Occ.ZERO;
    }

    public boolean one() {
        return this.occ == Occ.EXACTLY_ONE;
    }

    public boolean oneOrMore() {
        return this.occ.min >= 1L;
    }

    public boolean mayBeNumber() {
        return !this.zero() && (this.type.isNumber() || AtomType.ANY_ATOMIC_TYPE.instanceOf(this.type));
    }

    public boolean mayBeArray() {
        return !this.zero() && (this.type instanceof ArrayType || ARRAY.instanceOf(this.type));
    }

    public boolean mayBeFunction() {
        return !this.zero() && (this.type instanceof FuncType || AtomType.ANY_ATOMIC_TYPE.instanceOf(this.type));
    }

    public boolean instanceOf(SeqType st) {
        return this == st || (this.zero() ? !st.oneOrMore() : this.type.instanceOf(st.type) && this.occ.instanceOf(st.occ) && this.kindInstanceOf(st));
    }

    public boolean kindInstanceOf(SeqType st) {
        return st.test == null || this.test != null && this.test.instanceOf(st.test);
    }

    public Test test() {
        return this.test;
    }

    public boolean eq(SeqType st) {
        return this == st || this.type.eq(st.type) && this.occ == st.occ && Objects.equals(this.test, st.test);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SeqType && this.eq((SeqType)obj);
    }

    public String typeString() {
        return this.zero() ? "empty-sequence()" : (this.test != null ? this.test.toString() : this.type.toString());
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        if (!this.one() && this.type instanceof FuncType) {
            tb.add(40).add(this.typeString()).add(41);
        } else {
            tb.add(this.typeString());
        }
        if (!(this.type instanceof ListType)) {
            tb.add((Object)this.occ);
        }
        return tb.toString();
    }
}

