/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FNSpace;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class FElem
extends FNode {
    private final QNm name;
    private Atts namespaces;
    private ANode[] attributes;
    private ANode[] children;

    private FElem(QNm name) {
        super(NodeType.ELEMENT);
        this.name = name;
    }

    public static FBuilder build(QNm name) {
        return new FBuilder(new FElem(name));
    }

    public static FBuilder build(Element elem, TokenMap nsMap) {
        byte[] uri;
        Object nm;
        String nsUri = elem.getNamespaceURI();
        QNm name = new QNm(elem.getNodeName(), nsUri == null ? Token.EMPTY : Token.token(nsUri));
        FBuilder builder = FElem.build(name);
        Atts nspaces = new Atts();
        NamedNodeMap at = elem.getAttributes();
        int al = at.getLength();
        for (int a = 0; a < al; ++a) {
            Attr attr = (Attr)at.item(a);
            nm = Token.token(attr.getName());
            uri = Token.token(attr.getValue());
            if (Token.eq((byte[])nm, Token.XMLNS)) {
                nspaces.add(Token.EMPTY, uri);
                continue;
            }
            if (Token.startsWith((byte[])nm, Token.XMLNS_COLON)) {
                nspaces.add(Token.local((byte[])nm), uri);
                continue;
            }
            builder.add(new FAttr(attr));
        }
        int ns = nspaces.size();
        for (int n = 0; n < ns; ++n) {
            nsMap.put(nspaces.name(n), nspaces.value(n));
        }
        TokenMap namespaces = nsMap;
        if (namespaces == null) {
            namespaces = new TokenMap();
            FElem.nsScope(elem.getParentNode(), namespaces);
            nm = namespaces.iterator();
            while (nm.hasNext()) {
                byte[] prefix = (byte[])nm.next();
                if (nspaces.contains(prefix)) continue;
                nspaces.add(prefix, namespaces.get(prefix));
            }
        }
        byte[] prefix = name.prefix();
        uri = name.uri();
        byte[] old = namespaces.get(prefix);
        if (old == null || !Token.eq(uri, old)) {
            nspaces.add(prefix, uri);
            nsMap.put(prefix, uri);
        }
        if (!nspaces.isEmpty()) {
            builder.namespaces = nspaces;
        }
        FElem.children(elem, builder, new TokenMap());
        return builder;
    }

    FElem finish(Atts ns, ANode[] at, ANode[] ch) {
        this.namespaces = ns;
        this.attributes = at;
        this.children = ch;
        return this;
    }

    private static void nsScope(Node elem, TokenMap nsMap) {
        Node n = elem;
        while (n instanceof Element) {
            byte[] pref;
            NamedNodeMap atts = n.getAttributes();
            String prefix = n.getPrefix();
            if (prefix != null && nsMap.get(pref = Token.token(prefix)) != null) {
                nsMap.put(pref, Token.token(n.getNamespaceURI()));
            }
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                byte[] ln;
                Attr a = (Attr)atts.item(i);
                byte[] name = Token.token(a.getName());
                byte[] val = Token.token(a.getValue());
                if (Token.eq(name, Token.XMLNS)) {
                    if (nsMap.get(Token.EMPTY) != null) continue;
                    nsMap.put(Token.EMPTY, val);
                    continue;
                }
                if (!Token.startsWith(name, Token.XMLNS) || nsMap.get(ln = Token.local(name)) != null) continue;
                nsMap.put(ln, val);
            }
            n = n.getParentNode();
        }
    }

    @Override
    public Atts namespaces() {
        return this.namespaces;
    }

    @Override
    public byte[] string() {
        return FElem.string(this.children);
    }

    @Override
    public byte[] baseURI() {
        byte[] base = this.attribute(XML_BASE);
        return base != null ? base : Token.EMPTY;
    }

    @Override
    public QNm qname() {
        return this.name;
    }

    @Override
    public byte[] name() {
        return this.name.string();
    }

    @Override
    public BasicNodeIter attributeIter() {
        return ANodeList.iter(this.attributes);
    }

    @Override
    public BasicNodeIter childIter() {
        return ANodeList.iter(this.children);
    }

    @Override
    public boolean hasChildren() {
        return this.children.length != 0;
    }

    @Override
    public FNode materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) throws QueryException {
        if (this.materialized(test, ii)) {
            return this;
        }
        FBuilder elem = FElem.build(this.name);
        int ns = this.namespaces.size();
        for (int n = 0; n < ns; ++n) {
            elem.addNS(this.namespaces.name(n), this.namespaces.value(n));
        }
        for (ANode attribute : this.attributes) {
            elem.add((ANode)attribute.materialize((Predicate)test, ii, qc));
        }
        for (ANode child : this.children) {
            elem.add((ANode)child.materialize((Predicate)test, ii, qc));
        }
        return elem.finish();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FElem)) {
            return false;
        }
        FElem f = (FElem)obj;
        return this.name.eq(f.name) && Arrays.equals(this.children, f.children) && Arrays.equals(this.attributes, f.attributes) && Objects.equals(this.namespaces, f.namespaces) && super.equals(obj);
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name.string()), new ExprInfo[0]);
    }

    @Override
    public void toString(QueryString qs) {
        byte[] nm = this.name.string();
        TokenBuilder tb = new TokenBuilder().add(60).add(nm);
        int ns = this.namespaces.size();
        for (int n = 0; n < ns; ++n) {
            tb.add(32).add(new FNSpace(this.namespaces.name(n), this.namespaces.value(n)));
        }
        for (ANode attr : this.attributes) {
            tb.add(32).add(attr);
        }
        if (this.hasChildren()) {
            tb.add(62);
            ANode child = this.children[0];
            if (child.type == NodeType.TEXT && this.children.length == 1) {
                tb.add(QueryString.toValue(child.string()));
            } else {
                tb.add("...");
            }
            tb.add("</").add(nm).add(62);
        } else {
            tb.add("/>");
        }
        qs.token(tb.finish());
    }
}

