/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import java.util.BitSet;
import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.query.QueryBiConsumer;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.MergeDuplicates;
import org.basex.query.value.map.TrieBranch;
import org.basex.query.value.map.TrieLeaf;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Util;

final class TrieList
extends TrieNode {
    final int hash;
    final Item[] keys;
    final Value[] values;

    TrieList(int hash, Item[] keys, Value[] values) {
        super(keys.length);
        this.keys = keys;
        this.values = values;
        this.hash = hash;
        assert (this.verify());
    }

    TrieList(int hash, Item key1, Value value1, Item key2, Value value2) {
        this(hash, new Item[]{key1, key2}, new Value[]{value1, value2});
    }

    @Override
    TrieNode delete(int hs, Item key, int level, InputInfo ii) throws QueryException {
        if (hs == this.hash) {
            int i = this.size;
            while (i-- > 0) {
                if (!key.atomicEqual(this.keys[i], ii)) continue;
                if (this.size == 2) {
                    int o = i ^ 1;
                    return new TrieLeaf(hs, this.keys[o], this.values[o]);
                }
                int s = this.size - 1;
                Item[] ks = new Item[s];
                Array.copy(this.keys, i, ks);
                Array.copy(this.keys, i + 1, s - i, ks, i);
                Value[] vs = new Value[s];
                Array.copy(this.values, i, vs);
                Array.copy(this.values, i + 1, s - i, vs, i);
                return new TrieList(hs, ks, vs);
            }
        }
        return this;
    }

    @Override
    TrieNode put(int hs, Item key, Value value, int level, InputInfo ii) throws QueryException {
        int used;
        int b;
        if (hs == this.hash) {
            int i = this.keys.length;
            while (i-- > 0) {
                if (!key.atomicEqual(this.keys[i], ii)) continue;
                Value[] vs = (Value[])this.values.clone();
                vs[i] = value;
                return new TrieList(hs, this.keys, vs);
            }
            return new TrieList(this.hash, Array.add(this.keys, key), Array.add(this.values, value));
        }
        TrieNode[] ch = new TrieNode[32];
        int a = TrieList.key(hs, level);
        if (a == (b = TrieList.key(this.hash, level))) {
            ch[a] = this.put(hs, key, value, level + 1, ii);
            used = 1 << a;
        } else {
            ch[a] = new TrieLeaf(hs, key, value);
            ch[b] = this;
            used = 1 << a | 1 << b;
        }
        return new TrieBranch(ch, used, this.size + 1);
    }

    @Override
    Value get(int hs, Item key, int level, InputInfo ii) throws QueryException {
        if (hs == this.hash) {
            int k = this.keys.length;
            while (k-- != 0) {
                if (!key.atomicEqual(this.keys[k], ii)) continue;
                return this.values[k];
            }
        }
        return null;
    }

    @Override
    boolean contains(int hs, Item key, int level, InputInfo ii) throws QueryException {
        if (hs == this.hash) {
            int k = this.keys.length;
            while (k-- != 0) {
                if (!key.atomicEqual(this.keys[k], ii)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    TrieNode addAll(TrieNode node, int level, MergeDuplicates merge, QueryContext qc, InputInfo ii) throws QueryException {
        return node.add(this, level, merge, qc, ii);
    }

    @Override
    TrieNode add(TrieLeaf leaf, int level, MergeDuplicates merge, QueryContext qc, InputInfo ii) throws QueryException {
        int nu;
        int ok;
        qc.checkStop();
        if (this.hash == leaf.hash) {
            int k = this.keys.length;
            while (k-- > 0) {
                if (!leaf.key.atomicEqual(this.keys[k], ii)) continue;
                switch (merge) {
                    case USE_FIRST: 
                    case USE_ANY: {
                        Value[] uf = (Value[])this.values.clone();
                        uf[k] = leaf.value;
                        return new TrieList(this.hash, this.keys, uf);
                    }
                    case USE_LAST: {
                        return this;
                    }
                    case COMBINE: {
                        Value[] cm = (Value[])this.values.clone();
                        cm[k] = ValueBuilder.concat(leaf.value, cm[k], qc);
                        return new TrieList(this.hash, this.keys, cm);
                    }
                }
                throw QueryError.MERGE_DUPLICATE_X.get(ii, leaf.key);
            }
            return new TrieList(this.hash, Array.add(this.keys, leaf.key), Array.add(this.values, leaf.value));
        }
        TrieNode[] ch = new TrieNode[32];
        int k = TrieList.key(this.hash, level);
        if (k == (ok = TrieList.key(leaf.hash, level))) {
            ch[k] = this.add(leaf, level + 1, merge, qc, ii);
            nu = 1 << k;
        } else {
            ch[k] = this;
            ch[ok] = leaf;
            nu = 1 << k | 1 << ok;
        }
        return new TrieBranch(ch, nu, this.size + 1);
    }

    @Override
    TrieNode add(TrieList list, int level, MergeDuplicates merge, QueryContext qc, InputInfo ii) throws QueryException {
        int nu;
        int ok;
        qc.checkStop();
        if (this.hash == list.hash) {
            Value[] vs0 = list.values;
            Item[] ks = list.keys;
            Value[] vs = vs0;
            BitSet unmatched = new BitSet(list.size);
            unmatched.set(0, list.size);
            block5: for (int i = 0; i < this.size; ++i) {
                Item ok2 = this.keys[i];
                int j = unmatched.nextSetBit(0);
                while (j >= 0) {
                    Item k = list.keys[j];
                    if (k.atomicEqual(ok2, ii)) {
                        unmatched.clear(j);
                        switch (merge) {
                            case USE_FIRST: 
                            case USE_ANY: {
                                continue block5;
                            }
                            case USE_LAST: {
                                if (vs == vs0) {
                                    vs = (Value[])vs0.clone();
                                }
                                vs[j] = this.values[i];
                                continue block5;
                            }
                            case COMBINE: {
                                if (vs == vs0) {
                                    vs = (Value[])vs0.clone();
                                }
                                vs[j] = ValueBuilder.concat(vs[j], this.values[i], qc);
                                continue block5;
                            }
                            default: {
                                throw QueryError.MERGE_DUPLICATE_X.get(ii, k);
                            }
                        }
                    }
                    j = unmatched.nextSetBit(j + 1);
                }
                ks = Array.add(ks, ok2);
                vs = Array.add(vs, this.values[i]);
            }
            return vs == vs0 ? list : new TrieList(this.hash, ks, vs);
        }
        TrieNode[] ch = new TrieNode[32];
        int k = TrieList.key(this.hash, level);
        if (k == (ok = TrieList.key(list.hash, level))) {
            ch[k] = this.add(list, level + 1, merge, qc, ii);
            nu = 1 << k;
        } else {
            ch[k] = this;
            ch[ok] = list;
            nu = 1 << k | 1 << ok;
        }
        return new TrieBranch(ch, nu, this.size + list.size);
    }

    @Override
    TrieNode add(TrieBranch branch, int level, MergeDuplicates merge, QueryContext qc, InputInfo ii) throws QueryException {
        int k = TrieList.key(this.hash, level);
        TrieNode[] ch = branch.copyKids();
        TrieNode old = ch[k];
        TrieNode trieNode = old == null ? this : old.addAll(this, level + 1, merge, qc, ii);
        ch[k] = trieNode;
        return new TrieBranch(ch, branch.used | 1 << k, branch.size + this.size - (old != null ? old.size : 0));
    }

    @Override
    boolean verify() {
        try {
            for (int i = 1; i < this.size; ++i) {
                int j = i;
                while (j-- > 0) {
                    if (!this.keys[i].atomicEqual(this.keys[j], null)) continue;
                    return false;
                }
            }
        }
        catch (QueryException ex) {
            Util.debug(ex);
            return false;
        }
        return true;
    }

    @Override
    void keys(ItemList ks) {
        for (Item key : this.keys) {
            ks.add(key);
        }
    }

    @Override
    void values(ValueBuilder vs) {
        for (Value value : this.values) {
            vs.add(value);
        }
    }

    @Override
    void cache(boolean lazy, InputInfo ii) throws QueryException {
        for (int i = 0; i < this.size; ++i) {
            this.keys[i].cache(lazy, ii);
            this.values[i].cache(lazy, ii);
        }
    }

    @Override
    public boolean materialized(Predicate<Data> test, InputInfo ii) throws QueryException {
        for (Value value : this.values) {
            if (value.materialized(test, ii)) continue;
            return false;
        }
        return true;
    }

    @Override
    void apply(QueryBiConsumer<Item, Value> func) throws QueryException {
        for (int i = 0; i < this.size; ++i) {
            func.accept(this.keys[i], this.values[i]);
        }
    }

    @Override
    boolean instanceOf(AtomType kt, SeqType dt) {
        if (kt != null) {
            for (Value value : this.keys) {
                if (((Item)value).type.instanceOf(kt)) continue;
                return false;
            }
        }
        if (dt != null) {
            for (Value value : this.values) {
                if (dt.instance(value)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    int hash(InputInfo ii) throws QueryException {
        int h = this.hash;
        int i = this.size;
        while (--i >= 0) {
            h ^= this.values[i].hash(ii);
        }
        return h;
    }

    @Override
    boolean equal(TrieNode node, DeepEqual deep) throws QueryException {
        if (!(node instanceof TrieList) || this.size != node.size) {
            return false;
        }
        TrieList ol = (TrieList)node;
        block0: for (int i = 0; i < this.size; ++i) {
            if (deep.qc != null) {
                deep.qc.checkStop();
            }
            Item key = this.keys[i];
            for (int j = 0; j < this.size; ++j) {
                if (!key.atomicEqual(ol.keys[j], deep.info)) continue;
                if (deep.equal(this.values[i], ol.values[j])) continue block0;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    StringBuilder append(StringBuilder sb, String indent) {
        sb.append(indent).append("`-- Collision (").append(Integer.toHexString(this.hash)).append("):\n");
        int kl = this.keys.length;
        for (int k = 0; k < kl; ++k) {
            sb.append(indent).append("      ").append(this.keys[k]).append(" => ");
            sb.append(this.values[k]).append('\n');
        }
        return sb;
    }

    @Override
    StringBuilder append(StringBuilder sb) {
        int i = this.size;
        while (--i >= 0 && TrieList.more(sb)) {
            sb.append(this.keys[i]).append(": ").append(this.values[i]).append(", ");
        }
        return sb;
    }
}

