/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.value.Value;
import org.basex.query.value.array.BigArray;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.Util;

final class SmallArray
extends XQArray {
    final Value[] members;

    SmallArray(Value[] members, Type type) {
        super(type);
        this.members = members;
        assert (members.length >= 1 && members.length <= 7);
    }

    @Override
    public XQArray cons(Value head) {
        Type tp = this.union(head);
        if (this.members.length < 7) {
            Value[] newMembers = SmallArray.slice(this.members, -1, this.members.length);
            newMembers[0] = head;
            return new SmallArray(newMembers, tp);
        }
        int mid = 3;
        Value[] left = SmallArray.slice(this.members, -1, 3);
        Value[] right = SmallArray.slice(this.members, 3, this.members.length);
        left[0] = head;
        return new BigArray(left, right, tp);
    }

    @Override
    public XQArray snoc(Value last) {
        Type tp = this.union(last);
        if (this.members.length < 7) {
            Value[] newMembers = SmallArray.slice(this.members, 0, this.members.length + 1);
            newMembers[newMembers.length - 1] = last;
            return new SmallArray(newMembers, tp);
        }
        Value[] left = SmallArray.slice(this.members, 0, 4);
        Value[] right = SmallArray.slice(this.members, 4, this.members.length + 1);
        right[right.length - 1] = last;
        return new BigArray(left, right, tp);
    }

    @Override
    public Value get(long index) {
        return this.members[(int)index];
    }

    @Override
    public XQArray put(long pos, Value value) {
        Value[] values = (Value[])this.members.clone();
        values[(int)pos] = value;
        return new SmallArray(values, this.union(value));
    }

    @Override
    public long arraySize() {
        return this.members.length;
    }

    @Override
    public XQArray concat(XQArray other) {
        return other.isEmptyArray() ? this : other.prepend(this);
    }

    @Override
    public Value head() {
        return this.members[0];
    }

    @Override
    public Value last() {
        return this.members[this.members.length - 1];
    }

    @Override
    public XQArray init() {
        if (this.members.length == 1) {
            return SmallArray.empty();
        }
        return new SmallArray(SmallArray.slice(this.members, 0, this.members.length - 1), this.type);
    }

    @Override
    public XQArray tail() {
        if (this.members.length == 1) {
            return SmallArray.empty();
        }
        return new SmallArray(SmallArray.slice(this.members, 1, this.members.length), this.type);
    }

    @Override
    public boolean isEmptyArray() {
        return false;
    }

    @Override
    public XQArray reverseArray(QueryContext qc) {
        qc.checkStop();
        int n = this.members.length;
        if (n == 1) {
            return this;
        }
        Value[] values = new Value[n];
        for (int i = 0; i < n; ++i) {
            values[i] = this.members[n - 1 - i];
        }
        return new SmallArray(values, this.type);
    }

    @Override
    public XQArray insertBefore(long pos, Value value, QueryContext qc) {
        Type tp = this.union(value);
        qc.checkStop();
        int p = (int)pos;
        int n = this.members.length;
        Value[] out = new Value[n + 1];
        Array.copy(this.members, p, out);
        out[p] = value;
        Array.copy(this.members, p, n - p, out, p + 1);
        if (n < 7) {
            return new SmallArray(out, tp);
        }
        return new BigArray(SmallArray.slice(out, 0, 4), SmallArray.slice(out, 4, n + 1), tp);
    }

    @Override
    public XQArray remove(long pos, QueryContext qc) {
        qc.checkStop();
        int p = (int)pos;
        int n = this.members.length;
        if (n == 1) {
            return SmallArray.empty();
        }
        Value[] out = new Value[n - 1];
        Array.copy(this.members, p, out);
        Array.copy(this.members, p + 1, n - 1 - p, out, p);
        return new SmallArray(out, this.type);
    }

    @Override
    public XQArray subArray(long pos, long length, QueryContext qc) {
        qc.checkStop();
        int p = (int)pos;
        int n = (int)length;
        return n == 0 ? XQArray.empty() : new SmallArray(SmallArray.slice(this.members, p, p + n), this.type);
    }

    @Override
    public ListIterator<Value> iterator(final long start) {
        return new ListIterator<Value>(){
            private int index;
            {
                this.index = (int)start;
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public boolean hasNext() {
                return this.index < SmallArray.this.members.length;
            }

            @Override
            public Value next() {
                return SmallArray.this.members[this.index++];
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Value previous() {
                return SmallArray.this.members[--this.index];
            }

            @Override
            public void set(Value e) {
                throw Util.notExpected();
            }

            @Override
            public void add(Value e) {
                throw Util.notExpected();
            }

            @Override
            public void remove() {
                throw Util.notExpected();
            }
        };
    }

    @Override
    void checkInvariants() {
        int n = this.members.length;
        if (n == 0) {
            throw new AssertionError((Object)("Empty array in " + Util.className(this)));
        }
        if (n > 7) {
            throw new AssertionError((Object)("Array too big: " + n));
        }
    }

    @Override
    XQArray prepend(SmallArray array) {
        Type tp = this.type.union(array.type);
        Value[] values = array.members;
        int a = values.length;
        int b = this.members.length;
        int n = a + b;
        if (Math.min(a, b) >= 4) {
            return new BigArray(values, this.members, tp);
        }
        Value[] out = new Value[n];
        Array.copy(values, a, out);
        Array.copyFromStart(this.members, b, out, a);
        if (n <= 7) {
            return new SmallArray(out, tp);
        }
        int mid = n / 2;
        return new BigArray(SmallArray.slice(out, 0, mid), SmallArray.slice(out, mid, n), tp);
    }
}

