/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import java.util.Collections;
import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.array.SmallArray;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Util;

final class EmptyArray
extends XQArray {
    static final EmptyArray EMPTY = new EmptyArray();

    private EmptyArray() {
        super(SeqType.ARRAY);
    }

    @Override
    public void refineType(Expr expr) {
    }

    @Override
    public XQArray cons(Value head) {
        return new SmallArray(new Value[]{head}, ArrayType.get(head.seqType()));
    }

    @Override
    public XQArray snoc(Value last) {
        return new SmallArray(new Value[]{last}, ArrayType.get(last.seqType()));
    }

    @Override
    public Value get(long index) {
        throw Util.notExpected();
    }

    @Override
    public XQArray put(long pos, Value value) {
        throw Util.notExpected();
    }

    @Override
    public long arraySize() {
        return 0L;
    }

    @Override
    public XQArray concat(XQArray other) {
        return other;
    }

    @Override
    public Value head() {
        throw Util.notExpected();
    }

    @Override
    public Value last() {
        throw Util.notExpected();
    }

    @Override
    public XQArray init() {
        throw Util.notExpected();
    }

    @Override
    public XQArray tail() {
        throw Util.notExpected();
    }

    @Override
    public XQArray subArray(long pos, long length, QueryContext qc) {
        return this;
    }

    @Override
    public boolean isEmptyArray() {
        return true;
    }

    @Override
    public XQArray reverseArray(QueryContext qc) {
        return this;
    }

    @Override
    public XQArray insertBefore(long pos, Value value, QueryContext qc) {
        return new SmallArray(new Value[]{value}, ArrayType.get(value.seqType()));
    }

    @Override
    public XQArray remove(long pos, QueryContext qc) {
        throw Util.notExpected();
    }

    @Override
    public ListIterator<Value> iterator(long size) {
        return Collections.emptyListIterator();
    }

    @Override
    void checkInvariants() {
    }

    @Override
    XQArray prepend(SmallArray array) {
        return array;
    }
}

