/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.collation;

import org.basex.query.util.collation.Collation;
import org.basex.util.InputInfo;
import org.basex.util.Token;

final class NoCaseCollation
extends Collation {
    NoCaseCollation() {
    }

    @Override
    public int compare(byte[] string, byte[] compare) {
        String str = Token.string(string);
        String comp = Token.string(compare);
        int tl = str.length();
        int cl = comp.length();
        int l = Math.min(tl, cl);
        for (int i = 0; i < l; ++i) {
            int diff = NoCaseCollation.diff(str.charAt(i), comp.charAt(i));
            if (diff == 0) continue;
            return diff;
        }
        return tl - cl;
    }

    @Override
    protected int indexOf(String string, String sub, Collation.Mode mode, InputInfo ii) {
        int tl = string.length();
        int sl = sub.length();
        if (sl == 0) {
            return 0;
        }
        if (tl >= sl) {
            int t;
            int n = t = mode == Collation.Mode.ENDS_WITH ? tl - sl : 0;
            while (t < tl) {
                int s = 0;
                while (t + s < tl && NoCaseCollation.diff(string.charAt(t + s), sub.charAt(s)) == 0) {
                    if (++s != sl) continue;
                    return mode == Collation.Mode.INDEX_AFTER ? t + s : t;
                }
                if (mode == Collation.Mode.STARTS_WITH) {
                    return -1;
                }
                ++t;
            }
        }
        return -1;
    }

    private static int diff(char ch1, char ch2) {
        if (ch1 != ch2) {
            int c2;
            int c1 = ch1 >= 97 && ch1 <= 122 ? ch1 - 32 : ch1;
            int n = c2 = ch2 >= 97 && ch2 <= 122 ? ch2 - 32 : ch2;
            if (c1 != c2) {
                return c1 - c2;
            }
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof NoCaseCollation;
    }
}

