/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.scope;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.scope.AModule;
import org.basex.query.scope.LockVisitor;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.var.VarScope;

public class MainModule
extends AModule {
    public MainModule(Expr expr, VarScope vs) {
        super(vs.sc);
        this.expr = expr;
        this.vs = vs;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        cc.pushScope(this.vs);
        try {
            this.expr = this.expr.compile(cc);
        }
        finally {
            cc.removeScope(this);
        }
        return null;
    }

    public Iter iter(final QueryContext qc) throws QueryException {
        final int fp = this.vs.enter(qc);
        final Iter iter = this.expr.iter(qc);
        return new Iter(){
            boolean more = true;

            @Override
            public Item next() throws QueryException {
                if (this.more) {
                    Item item = iter.next();
                    if (item != null) {
                        return item;
                    }
                    this.more = false;
                    VarScope.exit(fp, qc);
                }
                return null;
            }

            @Override
            public Item get(long i) throws QueryException {
                return iter.get(i);
            }

            @Override
            public long size() throws QueryException {
                return iter.size();
            }

            @Override
            public Value value(QueryContext q, Expr ex) throws QueryException {
                return iter.value(qc, ex);
            }
        };
    }

    public final boolean databases(LockVisitor visitor) {
        return this.expr.accept(visitor);
    }

    @Override
    public final boolean visit(ASTVisitor visitor) {
        return this.expr.accept(visitor);
    }

    @Override
    public final void toXml(QueryPlan plan) {
        this.expr.toXml(plan);
    }

    @Override
    public final void toString(QueryString qs) {
        qs.token(this.expr);
    }
}

