/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.basex.query.QueryResource;
import org.basex.query.value.item.Uri;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;

public final class JDBCConnections
implements QueryResource {
    private int lastId = -1;
    private final TokenObjMap<AutoCloseable> conns = new TokenObjMap();

    synchronized Uri add(Connection conn, String url) {
        byte[] uri = Token.token(url + "/connection-" + ++this.lastId);
        this.conns.put(uri, conn);
        return Uri.get(uri);
    }

    synchronized Uri add(PreparedStatement stmt) throws SQLException {
        String url = Token.string(this.get(stmt.getConnection())).replaceAll("^(.+)/.+$", "$1");
        byte[] uri = Token.token(url + "/statement-" + ++this.lastId);
        this.conns.put(uri, stmt);
        return Uri.get(uri);
    }

    synchronized AutoCloseable get(Uri id) {
        return this.conns.get(id.string());
    }

    synchronized void remove(Uri id) {
        this.conns.remove(id.string());
    }

    private byte[] get(AutoCloseable ac) {
        for (byte[] id : this.conns) {
            if (this.conns.get(id) != ac) continue;
            return id;
        }
        return null;
    }

    @Override
    public void close() {
        for (AutoCloseable ac : this.conns.values()) {
            try {
                if (ac == null) continue;
                ac.close();
            }
            catch (Exception ex) {
                Util.debug(ex);
            }
        }
    }
}

