/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.java;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.basex.core.MainOptions;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.java.DynJavaCall;
import org.basex.query.func.java.JavaCandidate;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.XQJava;
import org.basex.query.value.seq.Empty;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

final class DynJavaFunc
extends DynJavaCall {
    private final String name;
    private ArrayList<Method> methods;
    private Field field;

    DynJavaFunc(Class<?> clazz, String name, String[] types, Expr[] args, StaticContext sc, InputInfo info) {
        super(clazz, types, args, sc, info);
        this.name = name;
    }

    public boolean init(boolean enforce) throws QueryException {
        IntList arities = new IntList();
        int arity = this.exprs.length;
        try {
            int al;
            Field f = this.clazz.getField(this.name);
            int n = al = DynJavaFunc.isStatic(f) ? 0 : 1;
            if (arity == al) {
                this.field = f;
            } else {
                arities.add(al);
            }
        }
        catch (NoSuchFieldException ex) {
            Util.debug(ex);
        }
        HashMap<String, ArrayList<Method>> allMethods = DynJavaFunc.methods(this.clazz);
        this.methods = DynJavaFunc.candidates(allMethods, this.name, this.types, arity, arities, false);
        if (this.field != null || !this.methods.isEmpty()) {
            return true;
        }
        if (!enforce) {
            return false;
        }
        TokenList names = new TokenList();
        for (String mthd : allMethods.keySet()) {
            names.add(mthd);
        }
        for (Field fld : this.clazz.getFields()) {
            names.add(fld.getName());
        }
        throw DynJavaFunc.noMember(this.name, this.types, arity, this.name(), arities, (byte[][])names.finish(), this.info);
    }

    @Override
    protected Value eval(QueryContext qc, MainOptions.WrapOptions wrap) throws QueryException {
        Object[] array;
        Object[] objectArray = array = this.field != null ? this.field(qc) : this.method(qc);
        if (wrap == MainOptions.WrapOptions.INSTANCE && array[1] != null) {
            return new XQJava(array[1]);
        }
        if (wrap == MainOptions.WrapOptions.VOID) {
            return Empty.VALUE;
        }
        return DynJavaFunc.toValue(array[0], qc, this.info, wrap);
    }

    private Object[] field(QueryContext qc) throws QueryException {
        Object instance = this.instance(this.values(qc), DynJavaFunc.isStatic(this.field));
        try {
            return new Object[]{this.field.get(instance), instance};
        }
        catch (IllegalArgumentException ex) {
            throw this.instanceExpected(ex);
        }
        catch (Throwable th) {
            throw this.executionError(th, new Object[0]);
        }
    }

    private Object[] method(QueryContext qc) throws QueryException {
        Method method2;
        Value[] values = this.values(qc);
        ArrayList<JavaCandidate> candidates = new ArrayList<JavaCandidate>(1);
        for (Method method2 : this.methods) {
            JavaCandidate jc = this.candidate(values, method2.getParameterTypes(), DynJavaFunc.isStatic(method2));
            if (jc == null) continue;
            jc.executable = method2;
            candidates.add(jc);
        }
        JavaCandidate jc = DynJavaFunc.bestCandidate(candidates);
        if (jc == null) {
            throw this.noCandidate(candidates, (Executable[])this.methods.toArray(Executable[]::new));
        }
        method2 = (Method)jc.executable;
        Object instance = this.instance(values, DynJavaFunc.isStatic(method2));
        if (instance instanceof QueryModule) {
            QueryModule qm = (QueryModule)instance;
            qm.staticContext = this.sc;
            qm.queryContext = qc;
        }
        try {
            return new Object[]{method2.invoke(instance, jc.arguments), instance};
        }
        catch (IllegalArgumentException ex) {
            throw this.instanceExpected(ex);
        }
        catch (Throwable th) {
            throw this.executionError(th, jc.arguments);
        }
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        DynJavaFunc f = new DynJavaFunc(this.clazz, this.name, this.types, DynJavaFunc.copyAll((CompileContext)cc, vm, (Expr[])this.exprs), this.sc, this.info);
        f.field = this.field;
        f.methods = this.methods;
        return this.copyType(f);
    }

    @Override
    String desc() {
        return QNm.eqName("java:" + DynJavaFunc.className(this.clazz), this.name);
    }

    @Override
    String name() {
        return DynJavaFunc.className(this.clazz) + ":" + this.name;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof DynJavaFunc && this.name.equals(((DynJavaFunc)obj).name) && super.equals(obj);
    }
}

