/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import org.basex.core.MainOptions;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Functions;
import org.basex.query.func.java.DynJavaCall;
import org.basex.query.func.java.JavaCandidate;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.XQJava;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.IntList;

final class DynJavaConstr
extends DynJavaCall {
    private ArrayList<Constructor<?>> constrs;

    DynJavaConstr(Class<?> clazz, String[] types, Expr[] args, StaticContext sc, InputInfo info) {
        super(clazz, types, args, sc, info);
    }

    public boolean init(boolean enforce) throws QueryException {
        IntList arities = new IntList();
        int arity = this.exprs.length;
        this.constrs = new ArrayList();
        for (Constructor<?> cnstr : this.clazz.getConstructors()) {
            Class<?>[] params = cnstr.getParameterTypes();
            int pl = params.length;
            if (pl == arity) {
                if (!DynJavaConstr.typesMatch(params, this.types)) continue;
                this.constrs.add(cnstr);
                continue;
            }
            arities.add(pl);
        }
        if (!this.constrs.isEmpty()) {
            return true;
        }
        if (!enforce) {
            return false;
        }
        throw Functions.wrongArity(this.name(), arity, arities, this.info);
    }

    @Override
    protected Value eval(QueryContext qc, MainOptions.WrapOptions wrap) throws QueryException {
        Value[] values = this.values(qc);
        ArrayList<JavaCandidate> candidates = new ArrayList<JavaCandidate>(1);
        for (Constructor<?> cnstr : this.constrs) {
            JavaCandidate jc = this.candidate(values, cnstr.getParameterTypes(), true);
            if (jc == null) continue;
            jc.executable = cnstr;
            candidates.add(jc);
        }
        JavaCandidate jc = DynJavaConstr.bestCandidate(candidates);
        if (jc == null) {
            throw this.noCandidate(candidates, (Executable[])this.constrs.toArray(Executable[]::new));
        }
        try {
            return new XQJava(((Constructor)jc.executable).newInstance(jc.arguments));
        }
        catch (Throwable th) {
            throw this.executionError(th, jc.arguments);
        }
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        DynJavaConstr c = new DynJavaConstr(this.clazz, this.types, DynJavaConstr.copyAll((CompileContext)cc, vm, (Expr[])this.exprs), this.sc, this.info);
        c.constrs = this.constrs;
        return this.copyType(c);
    }

    @Override
    String desc() {
        return QNm.eqName("java:" + DynJavaConstr.className(this.clazz), "new");
    }

    @Override
    String name() {
        return DynJavaConstr.className(this.clazz) + ":new";
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof DynJavaConstr && super.equals(obj);
    }
}

