/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.core.cmd.Rename;
import org.basex.data.Data;
import org.basex.index.resource.ResourceType;
import org.basex.index.resource.Resources;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbAccess;
import org.basex.query.up.Updates;
import org.basex.query.up.primitives.db.DBDelete;
import org.basex.query.up.primitives.db.DBRename;
import org.basex.query.up.primitives.node.ReplaceValue;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class DbRename
extends DbAccess {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        String target;
        Data data = this.toData(qc);
        String source = this.toDbPath(this.arg(1), qc);
        if (!IO.equals(source, target = this.toDbPath(this.arg(2), qc))) {
            Updates updates = qc.updates();
            IntList docs = data.resources.docs(source);
            int ds = docs.size();
            for (int d = 0; d < ds; ++d) {
                int pre = docs.get(d);
                String trg = Rename.target(data, pre, source, target);
                if (trg.isEmpty() || Strings.endsWith(trg, '/')) {
                    throw QueryError.DB_PATH_X.get(this.info, trg);
                }
                updates.add(new ReplaceValue(pre, data, this.info, Token.token(trg)), qc);
            }
            for (ResourceType type : Resources.BINARIES) {
                IOFile src = data.meta.file(source, type);
                IOFile trg = data.meta.file(target, type);
                if (src == null || trg == null) continue;
                this.rename(data, src, trg, qc);
                updates.add(new DBDelete(data, src, this.info), qc);
            }
        }
        return Empty.VALUE;
    }

    private void rename(Data data, IOFile src, IOFile trg, QueryContext qc) throws QueryException {
        if (src.isDir()) {
            if (trg.exists() && !trg.isDir()) {
                throw QueryError.DB_PATH_X.get(this.info, src);
            }
            for (IOFile f : src.children()) {
                this.rename(data, f, new IOFile(trg, f.name()), qc);
            }
        } else if (src.exists()) {
            if (trg.isDir()) {
                throw QueryError.DB_PATH_X.get(this.info, src);
            }
            qc.updates().add(new DBRename(data, src.path(), trg.path(), this.info), qc);
        }
    }
}

