/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.fn.FnSort;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ValueList;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.FItem;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class ArraySort
extends StandardFunc {
    @Override
    public XQArray item(QueryContext qc, InputInfo ii) throws QueryException {
        XQArray array = this.toArray(this.arg(0), qc);
        Collation coll = this.toCollation(this.arg(1), qc);
        FItem key = this.defined(2) ? this.toFunction(this.arg(2), 1, qc) : null;
        ValueList values = new ValueList(array.arraySize());
        for (Value value : array.members()) {
            values.add((key == null ? value : key.invoke(qc, this.info, value)).atomValue(qc, this.info));
        }
        ArrayBuilder ab = new ArrayBuilder();
        Integer[] integerArray = FnSort.sort(values, this, coll, qc);
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int order = integerArray[i];
            ab.append(array.get(order));
        }
        return ab.array(this);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr array = this.arg(0);
        if (array == XQArray.empty()) {
            return array;
        }
        SeqType st = array.seqType();
        Type type = st.type;
        if (type instanceof ArrayType) {
            if (this.defined(2)) {
                this.arg(2, arg -> this.coerceFunc((Expr)arg, cc, SeqType.ANY_ATOMIC_TYPE_ZM, ((ArrayType)type).declType));
            }
            this.exprType.assign(type);
        }
        return this;
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.HOF.in(flags) && this.defined(2) || super.has(flags);
    }
}

