/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ann;

import org.basex.query.QueryText;
import org.basex.query.func.FuncDefinition;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjMap;

public enum Annotation {
    PUBLIC("public()", Annotation.params(new SeqType[0]), QueryText.XQ_URI, false),
    PRIVATE("private()", Annotation.params(new SeqType[0]), QueryText.XQ_URI, false),
    UPDATING("updating()", Annotation.params(new SeqType[0]), QueryText.XQ_URI, false),
    _BASEX_LAZY("lazy()", Annotation.params(new SeqType[0]), QueryText.BASEX_URI),
    _BASEX_INLINE("inline([limit])", Annotation.params(SeqType.INTEGER_O), QueryText.BASEX_URI),
    _BASEX_LOCK("lock(key)", Annotation.params(SeqType.STRING_O), QueryText.BASEX_URI),
    _INPUT_CSV("csv(option[,...])", Annotation.params(SeqType.STRING_O), QueryText.INPUT_URI),
    _INPUT_HTML("html(option[,...])", Annotation.params(SeqType.STRING_O), QueryText.INPUT_URI),
    _INPUT_JSON("json(option[,...])", Annotation.params(SeqType.STRING_O), QueryText.INPUT_URI),
    _OUTPUT_ALLOW_DUPLICATE_NAMES("allow-duplicate-names(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_BYTE_ORDER_MARK("byte-order-mark(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_CDATA_SECTION_ELEMENTS("cdata-section-elements(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_CSV("csv(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_DOCTYPE_PUBLIC("doctype-public(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_DOCTYPE_SYSTEM("doctype-system(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_ENCODING("encoding(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_ESCAPE_URI_ATTRIBUTES("escape-uri-attributes(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_HTML_VERSION("html-version(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_INCLUDE_CONTENT_TYPE("include-content-type(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_INDENT("indent(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_INDENTS("indents(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_ITEM_SEPARATOR("item-separator(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_JSON("json(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_JSON_NODE_OUTPUT_METHOD("json-node-output-method(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_MEDIA_TYPE("media-type(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_METHOD("method(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_NEWLINE("newline(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_NORMALIZATION_FORM("normalization-form(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_OMIT_XML_DECLARATION("omit-xml-declaration(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_PARAMETER_DOCUMENT("parameter-document(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_STANDALONE("standalone(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_SUPPRESS_INDENTATION("suppress-indentation(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_TABULATOR("tabulator(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_UNDECLARE_PREFIXES("undeclare-prefixes(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_USE_CHARACTER_MAPS("use-character-maps(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_VERSION("version(value)", Annotation.params(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _PERM_CHECK("check([path[,map]])", Annotation.params(SeqType.STRING_O, SeqType.STRING_O), QueryText.PERM_URI),
    _PERM_ALLOW("allow(name[,...])", Annotation.params(SeqType.STRING_O), QueryText.PERM_URI, false),
    _REST_PATH("path(path)", Annotation.params(SeqType.STRING_O), QueryText.REST_URI),
    _REST_ERROR("error(code[,...])", Annotation.params(SeqType.STRING_O), QueryText.REST_URI, false),
    _REST_CONSUMES("consumes(type[,...])", Annotation.params(SeqType.STRING_O), QueryText.REST_URI, false),
    _REST_PRODUCES("produces(type[,...])", Annotation.params(SeqType.STRING_O), QueryText.REST_URI, false),
    _REST_QUERY_PARAM("query-param(name,variable[,default,...])", Annotation.params(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_O), QueryText.REST_URI, false),
    _REST_FORM_PARAM("form-param(name,variable[,default,...])", Annotation.params(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_O), QueryText.REST_URI, false),
    _REST_HEADER_PARAM("header-param(name,variable[,default,...])", Annotation.params(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_O), QueryText.REST_URI, false),
    _REST_COOKIE_PARAM("cookie-param(name,variable[,default,...])", Annotation.params(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_O), QueryText.REST_URI, false),
    _REST_ERROR_PARAM("error-param(name,variable[,default,...])", Annotation.params(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_O), QueryText.REST_URI, false),
    _REST_METHOD("method(name[,body])", Annotation.params(SeqType.STRING_O, SeqType.STRING_O), QueryText.REST_URI, false),
    _REST_SINGLE("single([key])", Annotation.params(SeqType.STRING_O), QueryText.REST_URI),
    _REST_GET("GET()", Annotation.params(new SeqType[0]), QueryText.REST_URI),
    _REST_POST("POST([body])", Annotation.params(SeqType.STRING_O), QueryText.REST_URI),
    _REST_PUT("PUT([body])", Annotation.params(SeqType.STRING_O), QueryText.REST_URI),
    _REST_DELETE("DELETE()", Annotation.params(new SeqType[0]), QueryText.REST_URI),
    _REST_HEAD("HEAD()", Annotation.params(new SeqType[0]), QueryText.REST_URI),
    _REST_OPTIONS("OPTIONS()", Annotation.params(new SeqType[0]), QueryText.REST_URI),
    _UNIT_AFTER("after([function])", Annotation.params(SeqType.STRING_O), QueryText.UNIT_URI),
    _UNIT_AFTER_MODULE("after-module()", Annotation.params(new SeqType[0]), QueryText.UNIT_URI),
    _UNIT_BEFORE("before([function])", Annotation.params(SeqType.STRING_O), QueryText.UNIT_URI),
    _UNIT_BEFORE_MODULE("before-module()", Annotation.params(new SeqType[0]), QueryText.UNIT_URI),
    _UNIT_IGNORE("ignore([message])", Annotation.params(SeqType.STRING_O), QueryText.UNIT_URI),
    _UNIT_TEST("test(['expected',error])", Annotation.params(SeqType.STRING_O, SeqType.STRING_O), QueryText.UNIT_URI),
    _WS_CONNECT("connect(path)", Annotation.params(SeqType.STRING_O), QueryText.WS_URI),
    _WS_MESSAGE("message(path,message)", Annotation.params(SeqType.STRING_O, SeqType.STRING_O), QueryText.WS_URI),
    _WS_CLOSE("close(path)", Annotation.params(SeqType.STRING_O), QueryText.WS_URI),
    _WS_HEADER_PARAM("header-param(name,variable[,default,...])", Annotation.params(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_O), QueryText.WS_URI, false),
    _WS_ERROR("error(path,message)", Annotation.params(SeqType.STRING_O, SeqType.STRING_O), QueryText.WS_URI);

    public final SeqType[] params;
    public final byte[] uri;
    public final int[] minMax;
    public final boolean single;
    private final String desc;
    public static final Annotation[] VALUES;
    private static final TokenObjMap<Annotation> MAP;

    private Annotation(String desc, SeqType[] params, byte[] uri) {
        this(desc, params, uri, true);
    }

    private Annotation(String desc, SeqType[] params, byte[] uri, boolean single) {
        this.desc = desc;
        this.params = params;
        this.uri = uri;
        this.single = single;
        this.minMax = FuncDefinition.minMax(desc, params);
    }

    public static Annotation get(QNm name) {
        return MAP.get(name.internal());
    }

    private static SeqType[] params(SeqType ... params) {
        return params;
    }

    public byte[] local() {
        return Token.token(this.desc.substring(0, this.desc.indexOf(40)));
    }

    public QNm qname() {
        return new QNm(this.id(), this.uri);
    }

    public byte[] id() {
        TokenBuilder tb = new TokenBuilder();
        if (!Token.eq(this.uri, QueryText.XQ_URI)) {
            tb.add(NSGlobal.prefix(this.uri)).add(58);
        }
        return tb.add(this.local()).finish();
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder().add(37);
        if (!Token.eq(this.uri, QueryText.XQ_URI)) {
            tb.add(NSGlobal.prefix(this.uri)).add(58);
        }
        return tb.add(this.desc.replace("()", "")).toString();
    }

    static {
        VALUES = Annotation.values();
        MAP = new TokenObjMap();
        for (Annotation value : VALUES) {
            MAP.put(new QNm(value.local(), value.uri).internal(), value);
        }
    }
}

