/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.util.NSContext;
import org.basex.query.util.UriResolver;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Uri;
import org.basex.query.value.type.SeqType;
import org.basex.util.Resolver;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.xml.sax.InputSource;

public final class StaticContext {
    public final TokenObjMap<DecFormatter> decFormats = new TokenObjMap();
    public final NSContext ns = new NSContext();
    public final boolean mixUpdates;
    public final boolean withdb;
    public Collation collation;
    public byte[] elemNS;
    public byte[] funcNS = QueryText.FN_URI;
    public QNm module;
    public boolean strip;
    public boolean ordered = true;
    public boolean orderGreatest;
    public boolean spaces;
    public boolean preserveNS = true;
    public boolean inheritNS = true;
    SeqType contextType;
    UriResolver resolver;
    private final URIResolver uriResolver;
    private Uri baseURI = Uri.EMPTY;

    public StaticContext(QueryContext qc) {
        MainOptions mopts = qc.context.options;
        this.mixUpdates = mopts.get(MainOptions.MIXUPDATES);
        this.withdb = mopts.get(MainOptions.WITHDB);
        this.uriResolver = Resolver.uris(mopts);
    }

    void namespace(String prefix, String uri) throws QueryException {
        if (prefix.isEmpty()) {
            this.elemNS = uri.isEmpty() ? null : Token.token(uri);
        } else if (uri.isEmpty()) {
            this.ns.delete(Token.token(prefix));
        } else {
            this.ns.add(Token.token(prefix), Token.token(uri), null);
        }
    }

    public Uri baseURI() {
        return this.baseURI;
    }

    public void baseURI(String uri) {
        Object string = "";
        if (uri != null) {
            if (uri.isEmpty()) {
                return;
            }
            Object object = string = IO.get(uri) instanceof IOContent ? uri : this.resolve(uri).url();
            if (!Strings.endsWith((String)string, '/') && (Strings.endsWith(uri, '.') || Strings.endsWith(uri, '/'))) {
                string = (String)string + "/";
            }
        }
        this.baseURI = Uri.get((String)string);
    }

    public IO baseIO() {
        return this.baseURI == Uri.EMPTY ? null : IO.get(Token.string(this.baseURI.string()));
    }

    public IO resolve(String path) {
        return this.resolve(path, null);
    }

    public IO resolve(String path, String uri) {
        if (this.resolver != null) {
            return this.resolver.resolve(path, uri, this.baseURI);
        }
        IO baseIO = this.baseIO();
        if (baseIO == null) {
            return IO.get(path);
        }
        if (this.uriResolver != null) {
            try {
                String id;
                Source s = this.uriResolver.resolve(path, baseIO.path());
                InputSource is = s instanceof SAXSource ? ((SAXSource)s).getInputSource() : null;
                String string = id = is != null ? is.getSystemId() : null;
                if (id != null) {
                    return IO.get(id);
                }
            }
            catch (TransformerException ex) {
                Util.debug(ex);
            }
        }
        return baseIO.merge(path);
    }

    public DecFormatter decFormat(byte[] id) throws QueryException {
        DecFormatter df = this.decFormats.get(id);
        if (df == null && Token.eq(id, Token.EMPTY)) {
            df = new DecFormatter(null, null);
            this.decFormats.put(id, df);
        }
        return df;
    }

    public String toString() {
        return Util.className(this) + "[" + this.baseIO() + "]";
    }
}

