/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.AQuery;
import org.basex.core.jobs.Job;
import org.basex.core.jobs.JobException;
import org.basex.core.locks.LockList;
import org.basex.core.locks.Locks;
import org.basex.data.Data;
import org.basex.io.parse.json.JsonConverter;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.CompileContext;
import org.basex.query.QueryCompiler;
import org.basex.query.QueryConsumer;
import org.basex.query.QueryDateTime;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QueryIOException;
import org.basex.query.QueryInfo;
import org.basex.query.QueryOptions;
import org.basex.query.QueryParser;
import org.basex.query.QueryPlan;
import org.basex.query.QueryResources;
import org.basex.query.QuerySuggest;
import org.basex.query.QuerySupplier;
import org.basex.query.QueryThreads;
import org.basex.query.StaticContext;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.func.StaticFuncs;
import org.basex.query.func.XQFunction;
import org.basex.query.func.java.JavaCall;
import org.basex.query.iter.Iter;
import org.basex.query.scope.AModule;
import org.basex.query.scope.ContextScope;
import org.basex.query.scope.LibraryModule;
import org.basex.query.scope.LockVisitor;
import org.basex.query.scope.MainModule;
import org.basex.query.scope.StaticScope;
import org.basex.query.up.Updates;
import org.basex.query.util.SharedData;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.ft.FTPosData;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FNode;
import org.basex.query.value.seq.DBNodes;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.QueryStack;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.Variables;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class QueryContext
extends Job
implements Closeable {
    public final QueryStack stack = new QueryStack();
    public final Variables vars = new Variables();
    public final StaticFuncs functions = new StaticFuncs();
    public final QueryResources resources;
    public final QueryContext parent;
    public final Context context;
    public final QueryInfo info;
    final QueryOptions options = new QueryOptions(this);
    public final QueryThreads threads = new QueryThreads();
    public final SharedData shared = new SharedData();
    public final LockList locks = new LockList();
    public QueryFocus focus = new QueryFocus();
    private QueryDateTime dateTime;
    public Updates updates;
    public FTPosData ftPosData = Prop.gui ? new FTPosData() : null;
    public FTLexer ftLexer;
    private FTOpt ftOpt;
    public int ftPos;
    public boolean scoring;
    public TokenObjMap<Collation> collations;
    public int tailCalls;
    public int maxCalls;
    private XQFunction tcFunc;
    private Value[] tcArgs;
    public int varIDs;
    public final TokenMap modParsed = new TokenMap();
    final TokenMap modDeclared = new TokenMap();
    final TokenList modStack = new TokenList();
    public MainModule main;
    public ContextScope contextScope;
    public boolean finalContext;
    private final QNmMap<Value> bindings = new QNmMap();
    private SerializerOptions sopts;
    private boolean defaultOutput;
    private boolean compiled;
    private boolean optimized;
    private boolean closed;

    public QueryContext(QueryContext parent) {
        this(parent.context, parent, parent.resources, parent.info);
        parent.pushJob(this);
        this.updates = parent.updates;
    }

    public QueryContext(Context context) {
        this(context, null, null, null);
    }

    public QueryContext(Context context, QueryContext parent, QueryResources resources, QueryInfo info) {
        this.context = context;
        this.parent = parent;
        this.info = info != null ? info : new QueryInfo(context);
        this.resources = resources != null ? resources : new QueryResources(this);
    }

    public AModule parse(String query, String uri) throws QueryException {
        return QueryParser.isLibrary(query) ? this.parseLibrary(query, uri) : this.parseMain(query, uri);
    }

    public StringList suggest(String query, Data data) {
        QuerySuggest qs = new QuerySuggest(query, this, data);
        try {
            qs.parseMain();
            return qs.complete(qs.mark);
        }
        catch (QueryException ex) {
            return qs.complete(ex.column() - 1);
        }
    }

    public MainModule parseMain(String query, String uri) throws QueryException {
        return this.parseMain(query, uri, null);
    }

    public MainModule parseMain(String query, String uri, StaticContext sc) throws QueryException {
        return this.run(this.info.parsing, () -> {
            this.info.query = query;
            this.main = new QueryParser(query, uri, this, sc).parseMain();
            return this.main;
        });
    }

    public LibraryModule parseLibrary(String query, String uri) throws QueryException {
        return this.run(this.info.parsing, () -> {
            this.info.query = query;
            return new QueryParser(query, uri, this, null).parseLibrary(true);
        });
    }

    public void assign(StaticFunc func, Expr ... args) throws QueryException {
        for (StaticFunc sf : this.functions.funcs()) {
            if (!func.info.equals(sf.info)) continue;
            sf.anns.addUnique(new Ann(sf.info, Annotation._BASEX_INLINE, (Value)Empty.VALUE));
            StaticFuncCall call = new StaticFuncCall(sf.name, args, sf.sc, sf.info).init(sf);
            this.main = new MainModule(call, new VarScope(sf.sc));
            this.updating = sf.updating();
            return;
        }
        throw QueryError.BASEX_WHICH_X.get(null, func);
    }

    public void compile() throws QueryException {
        if (this.compiled) {
            return;
        }
        this.compiled = true;
        this.run(this.info.compiling, () -> {
            this.options.compile();
            this.maxCalls = this.context.options.get(MainOptions.TAILCALLS);
            if (this.parent == null) {
                Map<String, String> map = this.context.options.toMap(MainOptions.BINDINGS);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.bind(entry.getKey(), Atm.get(entry.getValue()), null, this.main.sc);
                }
            }
            this.vars.bindExternal(this, this.bindings);
            return this.compile(false);
        });
    }

    public void optimize() throws QueryException {
        this.compile();
        if (this.optimized) {
            return;
        }
        this.optimized = true;
        this.run(this.info.optimizing, () -> {
            Value value;
            DBNodes nodes;
            StaticContext sc = this.main.sc;
            if (this.parent == null && !this.bindings.contains(QNm.EMPTY) && (nodes = this.context.current()) != null) {
                this.bind(null, this.resources.compile(nodes), null, sc);
            }
            if ((value = this.bindings.get(QNm.EMPTY)) != null) {
                this.contextScope = new ContextScope(value, sc.contextType, new VarScope(sc));
            }
            if (this.contextScope != null) {
                this.finalContext = true;
            }
            return this.compile(true);
        });
    }

    private Void compile(boolean dynamic) throws QueryException {
        this.checkStop();
        this.info.runtime = false;
        try {
            CompileContext cc = new CompileContext(this, dynamic);
            if (this.contextScope != null && dynamic) {
                try {
                    this.contextScope.compile(cc);
                    this.focus.value = this.contextScope.value(this);
                }
                catch (QueryException ex) {
                    Util.debug(ex);
                    throw ex.error() == QueryError.NOCTX_X ? QueryError.CIRCCTX.get(ex.info(), new Object[0]) : ex;
                }
            }
            if (this.main != null) {
                new QueryCompiler().compile(cc);
            } else {
                this.functions.compileAll(cc);
            }
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            throw QueryError.BASEX_OVERFLOW.get(null, ex);
        }
        finally {
            this.info.runtime = true;
        }
        return null;
    }

    public Iter iter() throws QueryException {
        this.optimize();
        return this.run(this.info.evaluating, () -> this.updating ? this.update().iter() : this.main.iter(this));
    }

    public Value value() throws QueryException {
        this.optimize();
        return this.run(this.info.evaluating, () -> this.updating ? this.update() : this.main.value(this));
    }

    public Item next(Iter iter) throws QueryException {
        this.checkStop();
        return iter.next();
    }

    public synchronized Updates updates() {
        if (this.updates == null) {
            this.updates = new Updates(false);
        }
        return this.updates;
    }

    @Override
    public void addLocks() {
        boolean local;
        LockList list;
        Locks l = this.jc().locks;
        LockList lockList = list = this.updating ? l.writes : l.reads;
        boolean bl = this.main == null || this.main.databases(new LockVisitor(list, this.contextScope == null)) ? true : (local = false);
        if (local && this.contextScope != null) {
            if (!this.finalContext) {
                list.add("internal:context");
            }
            local = this.contextScope.databases(new LockVisitor(list, true));
        }
        if (local) {
            list.add(this.locks);
        } else {
            list.addGlobal();
        }
    }

    public void bind(String name, Object value, String type, StaticContext sc) throws QueryException {
        QNm qnm;
        QNm qNm = qnm = name == null || name.isEmpty() ? QNm.EMPTY : QueryContext.qname(name, sc);
        if (!this.bindings.contains(qnm)) {
            this.bindings.put(qnm, this.cast(value, type));
        }
    }

    public void evalInfo(String string) {
        QueryContext qc = this;
        while (qc.parent != null) {
            qc = qc.parent;
        }
        qc.info.evalInfo(string);
    }

    public SerializerOptions parameters() {
        if (this.sopts == null) {
            this.sopts = new SerializerOptions(this.context.options.get(MainOptions.SERIALIZER));
            this.defaultOutput = this.main != null;
        }
        return this.sopts;
    }

    public FTOpt ftOpt() {
        if (this.ftOpt == null) {
            this.ftOpt = new FTOpt();
        }
        return this.ftOpt;
    }

    public void ftOpt(FTOpt opt) {
        this.ftOpt = opt;
    }

    public FNode toXml(boolean full) {
        QueryPlan plan = new QueryPlan(this.compiled, this.closed, full);
        if (this.main != null) {
            for (StaticScope staticScope : QueryCompiler.usedDecls(this.main)) {
                staticScope.toXml(plan);
            }
            this.main.toXml(plan);
        } else {
            this.functions.toXml(plan);
            this.vars.toXml(plan);
        }
        return plan.root();
    }

    public void updating() {
        this.updating = true;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.parent == null) {
            this.resources.close();
            this.threads.close();
        } else {
            this.parent.updates = this.updates;
            this.parent.popJob();
        }
        this.options.close();
        Performance perf = this.jc().performance;
        if (perf != null) {
            this.info.serializing.addAndGet(perf.ns());
        }
    }

    @Override
    public String shortInfo() {
        return Text.SAVE;
    }

    public Value get(Var var) {
        return this.stack.get(var);
    }

    public void set(Var var, Value value) throws QueryException {
        this.stack.set(var, value, this);
    }

    public void registerTailCall(XQFunction fn, Value[] arg) {
        this.tcFunc = fn;
        this.tcArgs = arg;
    }

    public XQFunction pollTailCall() {
        XQFunction fn = this.tcFunc;
        this.tcFunc = null;
        return fn;
    }

    public Value[] pollTailArgs() {
        Value[] as = this.tcArgs;
        this.tcArgs = null;
        return as;
    }

    public QueryDateTime dateTime() throws QueryException {
        if (this.dateTime == null) {
            this.dateTime = new QueryDateTime();
        }
        return this.dateTime;
    }

    public String toString() {
        return this.main != null ? QueryInfo.usedDecls(this.main) : this.info.query;
    }

    void cache(AQuery cmd, int max) {
        ItemList items = new ItemList();
        IntList pres = new IntList();
        Data data = this.resources.globalData();
        try {
            this.optimize();
            this.run(this.info.evaluating, () -> {
                block6: {
                    Item item;
                    Iter iter;
                    int mx;
                    block5: {
                        mx = max >= 0 ? max : Integer.MAX_VALUE;
                        iter = this.iter();
                        if (!this.defaultOutput || data == null) break block5;
                        while ((item = this.next(iter)) != null && item.data() == data && pres.size() < mx) {
                            pres.add(((DBNode)item).pre());
                        }
                        if (item == null || pres.size() == mx) break block6;
                        for (int pre : pres.finish()) {
                            items.add(new DBNode(data, pre));
                        }
                        items.add(item);
                    }
                    while ((item = this.next(iter)) != null && items.size() < mx) {
                        item.cache(false, null);
                        items.add(item);
                    }
                }
                return null;
            });
        }
        catch (JobException | QueryException ex) {
            cmd.exception = ex;
        }
        cmd.result = !items.isEmpty() ? items.value() : (!pres.isEmpty() ? new DBNodes(data, pres.finish()).ftpos(this.ftPosData) : Empty.VALUE);
    }

    private Value update() throws QueryException {
        try {
            Value value = this.main.value(this);
            if (this.updates == null || this.parent != null) {
                return value;
            }
            HashSet<Data> datas = this.updates.prepare(this);
            StringList dbs = this.updates.databases();
            ValueBuilder vb = new ValueBuilder(this);
            QueryConsumer<Value> materialize = val -> vb.add(val.materialize(d -> d != null && (datas.contains(d) || !d.inMemory() && dbs.contains(d.meta.name)), null, this));
            materialize.accept(value);
            materialize.accept(this.updates.output(true));
            if (this.context.data() != null) {
                this.context.invalidate();
            }
            this.updates.apply(this);
            return vb.value(value);
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            throw QueryError.BASEX_OVERFLOW.get(null, new Object[0]);
        }
    }

    private Value cast(Object value, String type) throws QueryException {
        E[] object = value;
        if (object instanceof String) {
            String string = (String)object;
            StringList strings = new StringList(1L);
            if (string.indexOf(1) == -1) {
                strings.add(string);
            } else {
                object = ((StringList)strings.add(string.split("\u0001"))).toArray();
            }
            if (string.indexOf(2) != -1) {
                ValueBuilder vb = new ValueBuilder(this);
                for (String str : strings) {
                    int i = str.indexOf(2);
                    String val = i == -1 ? str : str.substring(0, i);
                    String tp = i == -1 ? type : str.substring(i + 1);
                    vb.add(this.cast(val, tp));
                }
                return vb.value();
            }
        }
        if (type == null || type.isEmpty()) {
            return object instanceof Value ? (Value)object : JavaCall.toValue(object, this, null);
        }
        if (type.equalsIgnoreCase(MainOptions.MainParser.JSON.name())) {
            try {
                JsonParserOptions jp = new JsonParserOptions();
                jp.set(JsonOptions.FORMAT, JsonOptions.JsonFormat.XQUERY);
                return JsonConverter.get(jp).convert(object.toString(), "");
            }
            catch (QueryIOException ex) {
                throw ex.getCause();
            }
        }
        StaticContext sc = this.main != null ? this.main.sc : new StaticContext(this);
        SeqType st = new QueryParser(type, null, this, sc).parseSeqType();
        if (st.eq(SeqType.EMPTY_SEQUENCE_Z)) {
            return Empty.VALUE;
        }
        Type tp = st.type;
        if (object instanceof Value) {
            Value val = (Value)object;
            if (val.isItem()) {
                return tp.cast((Item)val, this, sc, null);
            }
            ValueBuilder vb = new ValueBuilder(this);
            for (Item item : val) {
                vb.add(tp.cast(item, this, sc, null));
            }
            return vb.value(tp);
        }
        if (object instanceof String[]) {
            ValueBuilder vb = new ValueBuilder(this);
            for (String string : (String[])object) {
                vb.add(tp.cast(string, this, null));
            }
            return vb.value(tp);
        }
        return tp.cast(object, this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T run(AtomicLong runtime, QuerySupplier<T> code) throws QueryException {
        Performance perf = this.jc().performance;
        if (perf == null) {
            perf = new Performance();
        } else {
            perf.ns();
        }
        try {
            T t = code.get();
            return t;
        }
        finally {
            runtime.addAndGet(perf.ns());
        }
    }

    private static QNm qname(String name, StaticContext sc) throws QueryException {
        return QNm.resolve(Token.token(Strings.startsWith(name, '$') ? name.substring(1) : name), sc);
    }
}

