/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.random;

import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.basex.io.IOFile;
import org.basex.io.random.Buffer;
import org.basex.io.random.Buffers;
import org.basex.util.Array;
import org.basex.util.Util;

public final class DataAccess
implements Closeable {
    private final Buffers buffers = new Buffers();
    private final RandomAccessFile raf;
    private long length;
    private boolean changed;
    private int off;

    public DataAccess(IOFile file) throws IOException {
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(file.file(), "rw");
            this.length = f.length();
            this.raf = f;
            this.cursor(0L);
        }
        catch (IOException ex) {
            if (f != null) {
                f.close();
            }
            throw ex;
        }
    }

    public synchronized void flush() {
        try {
            for (Buffer buffer : this.buffers.all()) {
                if (!buffer.dirty) continue;
                this.writeBlock(buffer);
            }
            if (this.changed) {
                this.raf.setLength(this.length);
                this.changed = false;
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    @Override
    public synchronized void close() {
        this.flush();
        try {
            this.raf.close();
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    public long cursor() {
        return this.buffer((boolean)false).pos + (long)this.off;
    }

    public long length() {
        return this.length;
    }

    public boolean more() {
        return this.cursor() < this.length;
    }

    public synchronized byte read1(long pos) {
        this.cursor(pos);
        return this.read1();
    }

    public synchronized byte read1() {
        return (byte)this.read();
    }

    public synchronized int read4(long pos) {
        this.cursor(pos);
        return this.read4();
    }

    public synchronized int read4() {
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    public synchronized long read5(long pos) {
        this.cursor(pos);
        return this.read5();
    }

    public synchronized long read5() {
        return ((long)this.read() << 32) + ((long)this.read() << 24) + (long)(this.read() << 16) + (long)(this.read() << 8) + (long)this.read();
    }

    public synchronized int readNum(long pos) {
        this.cursor(pos);
        return this.readNum();
    }

    public synchronized byte[] readToken(long pos) {
        this.cursor(pos);
        return this.readToken();
    }

    public synchronized byte[] readToken() {
        int l = this.readNum();
        return this.readBytes(l);
    }

    public synchronized byte[] readBytes(long pos, int len) {
        this.cursor(pos);
        return this.readBytes(len);
    }

    public synchronized byte[] readBytes(int len) {
        int l = len;
        int ll = 4096 - this.off;
        byte[] data = new byte[l];
        Array.copyToStart(this.buffer((boolean)false).data, this.off, Math.min(l, ll), data);
        if (l > ll) {
            l -= ll;
            while (l > 4096) {
                Array.copyFromStart(this.buffer((boolean)true).data, 4096, data, ll);
                ll += 4096;
                l -= 4096;
            }
            Array.copyFromStart(this.buffer((boolean)true).data, l, data, ll);
        }
        this.off += l;
        return data;
    }

    public void cursor(long pos) {
        this.off = (int)(pos & 0xFFFL);
        long b = pos - (long)this.off;
        if (!this.buffers.cursor(b)) {
            return;
        }
        Buffer buffer = this.buffers.current();
        try {
            if (buffer.dirty) {
                this.writeBlock(buffer);
            }
            buffer.pos = b;
            this.raf.seek(buffer.pos);
            if (buffer.pos < this.raf.length()) {
                this.raf.readFully(buffer.data, 0, (int)Math.min(this.length - buffer.pos, 4096L));
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    public synchronized int readNum() {
        int value = this.read();
        switch (value & 0xC0) {
            case 0: {
                return value;
            }
            case 64: {
                return (value - 64 << 8) + this.read();
            }
            case 128: {
                return (value - 128 << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
            }
        }
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    public void write5(long pos, long value) {
        this.cursor(pos);
        this.write((byte)(value >>> 32));
        this.write((byte)(value >>> 24));
        this.write((byte)(value >>> 16));
        this.write((byte)(value >>> 8));
        this.write((byte)value);
    }

    public void write4(long pos, int value) {
        this.cursor(pos);
        this.write4(value);
    }

    public void write4(int value) {
        this.write(value >>> 24);
        this.write(value >>> 16);
        this.write(value >>> 8);
        this.write(value);
    }

    public void writeNum(int value) {
        if (value < 0 || value > 0x3FFFFFFF) {
            this.write(192);
            this.write(value >>> 24);
            this.write(value >>> 16);
            this.write(value >>> 8);
        } else if (value > 16383) {
            this.write(value >>> 24 | 0x80);
            this.write(value >>> 16);
            this.write(value >>> 8);
        } else if (value > 63) {
            this.write(value >>> 8 | 0x40);
        }
        this.write(value);
    }

    public void writeBytes(byte[] data, int offset, int len) {
        int l;
        int last = offset + len;
        for (int o = offset; o < last; o += l) {
            Buffer buffer = this.buffer();
            l = Math.min(last - o, 4096 - this.off);
            Array.copy(data, o, l, buffer.data, this.off);
            buffer.dirty = true;
            this.off += l;
            long nl = buffer.pos + (long)this.off;
            if (nl <= this.length) continue;
            this.length(nl);
        }
    }

    public void writeToken(long pos, byte[] value) {
        this.cursor(pos);
        int len = value.length;
        this.writeNum(len);
        this.writeBytes(value, 0, len);
    }

    public long free(long pos, int size) {
        int os;
        this.cursor(pos + (long)os);
        for (os = this.readNum(pos) + (int)(this.cursor() - pos); pos + (long)os < this.length && os < size && this.read() == 255; ++os) {
        }
        long o = pos;
        if (pos + (long)os == this.length) {
            this.length(pos);
        } else {
            int t = size;
            if (os < size) {
                this.cursor(pos);
                t = 0;
                o = this.length;
            } else {
                this.cursor(pos + (long)size);
            }
            while (t++ < os) {
                this.write(255);
            }
        }
        return o;
    }

    private synchronized void length(long len) {
        if (len != this.length) {
            this.changed = true;
            this.length = len;
        }
    }

    private int read() {
        Buffer buffer = this.buffer();
        return buffer.data[this.off++] & 0xFF;
    }

    private void write(int value) {
        Buffer buffer = this.buffer();
        buffer.dirty = true;
        buffer.data[this.off++] = (byte)value;
        long nl = buffer.pos + (long)this.off;
        if (nl > this.length) {
            this.length(nl);
        }
    }

    private void writeBlock(Buffer buffer) throws IOException {
        long pos = buffer.pos;
        long len = Math.min(4096L, this.length - pos);
        this.raf.seek(pos);
        this.raf.write(buffer.data, 0, (int)len);
        buffer.dirty = false;
    }

    private Buffer buffer() {
        return this.buffer(this.off == 4096);
    }

    private Buffer buffer(boolean next) {
        if (next) {
            this.cursor(this.buffers.current().pos + 4096L);
        }
        return this.buffers.current();
    }
}

