/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConverter;
import org.basex.query.QueryError;
import org.basex.query.QueryIOException;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenSet;

public final class JsonParser
extends InputParser {
    private static final String[] CTRL = new String[]{"NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL", "BS", "TAB", "LF", "VT", "FF", "CR", "SO", "SI", "DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB", "CAN", "EM", "SUB", "ESC", "FS", "GS", "RS", "US"};
    private final JsonConverter conv;
    private final boolean liberal;
    private final boolean escape;
    private final JsonParserOptions.JsonDuplicates duplicates;
    private final TokenBuilder tb = new TokenBuilder();

    public JsonParser(String input, JsonParserOptions opts, JsonConverter conv) {
        super(input);
        this.liberal = opts.get(JsonParserOptions.LIBERAL);
        this.escape = opts.get(JsonParserOptions.ESCAPE);
        JsonParserOptions.JsonDuplicates dupl = opts.get(JsonParserOptions.DUPLICATES);
        this.duplicates = dupl != null ? dupl : (opts.get(JsonOptions.FORMAT) == JsonOptions.JsonFormat.BASIC ? JsonParserOptions.JsonDuplicates.RETAIN : JsonParserOptions.JsonDuplicates.USE_FIRST);
        this.conv = conv;
    }

    public void parse() throws QueryIOException {
        this.consume(65279);
        this.skipWs();
        try {
            this.value();
        }
        catch (StackOverflowError er) {
            Util.debug(er);
            throw this.error("Input is too deeply nested", new Object[0]);
        }
        if (this.more()) {
            throw this.error("Unexpected trailing content: %", this.remaining());
        }
    }

    private void value() throws QueryIOException {
        if (this.pos >= this.length) {
            throw this.eof(", expected JSON value.");
        }
        switch (this.curr()) {
            case '[': {
                this.array();
                break;
            }
            case '{': {
                this.object();
                break;
            }
            case '\"': {
                this.conv.stringLit(this.string());
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.conv.numberLit(this.number());
                break;
            }
            default: {
                if (this.consume("true")) {
                    this.conv.booleanLit(Token.TRUE);
                } else if (this.consume("false")) {
                    this.conv.booleanLit(Token.FALSE);
                } else if (this.consume("null")) {
                    this.conv.nullLit();
                } else {
                    throw this.error("Unexpected JSON value: '%'", this.remaining());
                }
                this.skipWs();
            }
        }
    }

    private void object() throws QueryIOException {
        this.consumeWs('{', true);
        this.conv.openObject();
        if (!this.consumeWs('}', false)) {
            TokenSet set = new TokenSet();
            do {
                byte[] key;
                boolean dupl;
                if ((dupl = set.contains(key = !this.liberal || this.curr() == '\"' ? this.string() : this.unquoted())) && this.duplicates == JsonParserOptions.JsonDuplicates.REJECT) {
                    throw this.error(QueryError.JSON_DUPL_X_X_X, "Key \"%\" occurs more than once", new Object[]{key});
                }
                boolean add = !dupl || this.duplicates != JsonParserOptions.JsonDuplicates.USE_FIRST;
                this.conv.openPair(key, add);
                this.consumeWs(':', true);
                this.value();
                this.conv.closePair(add);
                set.put(key);
            } while (this.consumeWs(',', false) && (!this.liberal || this.curr() != '}'));
            this.consumeWs('}', true);
        }
        this.conv.closeObject();
    }

    private void array() throws QueryIOException {
        this.consumeWs('[', true);
        this.conv.openArray();
        if (!this.consumeWs(']', false)) {
            do {
                this.conv.openItem();
                this.value();
                this.conv.closeItem();
            } while (this.consumeWs(',', false) && (!this.liberal || this.curr() != ']'));
            this.consumeWs(']', true);
        }
        this.conv.closeArray();
    }

    private byte[] unquoted() throws QueryIOException {
        int cp;
        int n = cp = this.more() ? this.input.codePointAt(this.pos) : -1;
        if (cp < 0 || !Character.isJavaIdentifierStart(cp)) {
            throw this.error("Expected unquoted string, found %", this.remaining());
        }
        this.tb.reset();
        do {
            this.tb.add(cp);
        } while (Character.isJavaIdentifierPart(cp = this.input.codePointAt(this.pos += cp < 65536 ? 1 : 2)));
        this.skipWs();
        return this.tb.toArray();
    }

    private byte[] number() throws QueryIOException {
        this.tb.reset();
        char ch = this.consume();
        this.tb.add(ch);
        if (ch == '-') {
            ch = this.consume();
            if (ch < '0' || ch > '9') {
                throw this.error("Number expected after '-'", new Object[0]);
            }
            this.tb.add(ch);
        }
        boolean zero = ch == '0';
        ch = this.curr();
        if (zero && ch >= '0' && ch <= '9') {
            throw this.error("No digit allowed after '0'", new Object[0]);
        }
        block4: while (true) {
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.tb.add(ch);
                    ++this.pos;
                    ch = this.curr();
                    continue block4;
                }
                case '.': 
                case 'E': 
                case 'e': {
                    break block4;
                }
                default: {
                    this.skipWs();
                    return this.tb.toArray();
                }
            }
            break;
        }
        if (this.consume(46)) {
            this.tb.add(46);
            ch = this.curr();
            if (ch < '0' || ch > '9') {
                throw this.error("Number expected after '.'", new Object[0]);
            }
            do {
                this.tb.add(ch);
                ++this.pos;
            } while ((ch = this.curr()) >= '0' && ch <= '9');
            if (ch != 'e' && ch != 'E') {
                this.skipWs();
                return this.tb.toArray();
            }
        }
        this.tb.add(this.consume());
        ch = this.curr();
        if (ch == '-' || ch == '+') {
            this.tb.add(this.consume());
            ch = this.curr();
        }
        if (ch < '0' || ch > '9') {
            throw this.error("Exponent expected", new Object[0]);
        }
        do {
            this.tb.add(this.consume());
        } while ((ch = this.curr()) >= '0' && ch <= '9');
        this.skipWs();
        return this.tb.toArray();
    }

    private byte[] string() throws QueryIOException {
        if (!this.consume(34)) {
            throw this.error("Expected string, found '%'", Character.valueOf(this.curr()));
        }
        this.tb.reset();
        int high = 0;
        while (this.pos < this.length) {
            int ch;
            int p;
            block24: {
                block23: {
                    p = this.pos;
                    ch = this.consume();
                    if (ch == 34) {
                        if (high != 0) {
                            this.add(high, this.pos - 7, p);
                        }
                        this.skipWs();
                        return this.tb.toArray();
                    }
                    if (ch != 92) break block23;
                    ch = this.consume();
                    switch (ch) {
                        case 34: 
                        case 47: 
                        case 92: {
                            break block24;
                        }
                        case 98: {
                            ch = 8;
                            break block24;
                        }
                        case 102: {
                            ch = 12;
                            break block24;
                        }
                        case 110: {
                            ch = 10;
                            break block24;
                        }
                        case 114: {
                            ch = 13;
                            break block24;
                        }
                        case 116: {
                            ch = 9;
                            break block24;
                        }
                        case 117: {
                            if (this.pos + 4 >= this.length) {
                                throw this.eof(", expected four-digit hex value");
                            }
                            ch = 0;
                            for (int i = 0; i < 4; ++i) {
                                char x = this.consume();
                                if (x >= '0' && x <= '9') {
                                    ch = 16 * ch + x - 48;
                                    continue;
                                }
                                if (x >= 'a' && x <= 'f') {
                                    ch = 16 * ch + x + 10 - 97;
                                    continue;
                                }
                                if (x >= 'A' && x <= 'F') {
                                    ch = 16 * ch + x + 10 - 65;
                                    continue;
                                }
                                throw this.error("Illegal hexadecimal digit: '%'", Character.valueOf(x));
                            }
                            break block24;
                        }
                        default: {
                            throw this.error("Unknown character escape: '\\%'", ch);
                        }
                    }
                }
                if (!this.liberal && ch <= 31) {
                    throw this.error("Non-escaped control character: '\\%'", CTRL[ch]);
                }
            }
            if (high != 0) {
                if (ch >= 56320 && ch <= 57343) {
                    ch = (high - 55296 << 10) + ch - 56320 + 65536;
                } else {
                    this.add(high, p, this.pos);
                }
                high = 0;
            }
            if (ch >= 55296 && ch <= 56319) {
                high = (char)ch;
                continue;
            }
            this.add(ch, p, this.pos);
        }
        throw this.eof(" in string literal");
    }

    private void add(int ch, int s, int e) {
        if (this.escape) {
            if (ch == 92) {
                this.tb.add("\\\\");
            } else if (ch == 8) {
                this.tb.add("\\b");
            } else if (ch == 12) {
                this.tb.add("\\f");
            } else if (ch == 10) {
                this.tb.add("\\n");
            } else if (ch == 13) {
                this.tb.add("\\r");
            } else if (ch == 9) {
                this.tb.add("\\t");
            } else if (XMLToken.valid(ch)) {
                this.tb.add(ch);
            } else {
                this.tb.add(92).add(117).add(Token.HEX_TABLE[ch >> 12 & 0xF]).add(Token.HEX_TABLE[ch >> 8 & 0xF]);
                this.tb.add(Token.HEX_TABLE[ch >> 4 & 0xF]).add(Token.HEX_TABLE[ch & 0xF]);
            }
        } else if (XMLToken.valid(ch)) {
            this.tb.add(ch);
        } else if (this.conv.fallback == null) {
            this.tb.add(65533);
        } else {
            this.tb.add(this.conv.fallback.convert(this.input.substring(s, e)));
        }
    }

    private void skipWs() {
        block3: while (this.pos < this.length) {
            switch (this.input.charAt(this.pos)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\u00a0': {
                    ++this.pos;
                    continue block3;
                }
            }
            return;
        }
    }

    private boolean consumeWs(char ch, boolean err) throws QueryIOException {
        if (this.consume(ch)) {
            this.skipWs();
            return true;
        }
        if (err) {
            throw this.error("Expected '%', found '%'", Character.valueOf(ch), Character.valueOf(this.curr()));
        }
        return false;
    }

    private QueryIOException eof(String desc) throws QueryIOException {
        throw this.error("Unexpected end of input%", desc);
    }

    private QueryIOException error(String msg, Object ... ext) {
        return this.error(QueryError.JSON_PARSE_X_X_X, msg, ext);
    }

    private QueryIOException error(QueryError err, String msg, Object ... ext) {
        InputInfo ii = new InputInfo(this);
        return new QueryIOException(err.get(ii, ii.line(), ii.column(), Util.inf(msg, ext)));
    }
}

