/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.QueryIOException;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;

public final class JsonAttsConverter
extends JsonXmlConverter {
    JsonAttsConverter(JsonParserOptions opts) throws QueryIOException {
        super(opts);
    }

    @Override
    void openObject() {
        this.openOuter(JsonConstants.OBJECT);
    }

    @Override
    void closeObject() {
        this.closeOuter();
    }

    @Override
    void openPair(byte[] key, boolean add) {
        this.addValues.add(add);
        if (add) {
            this.openInner(Q_PAIR);
            this.name = this.shared.token(key);
            this.curr.add(Q_NAME, this.name);
        }
    }

    @Override
    void closePair(boolean add) {
        if (add) {
            this.closeInner();
            this.name = null;
        }
        this.addValues.pop();
    }

    @Override
    void openArray() {
        this.openOuter(JsonConstants.ARRAY);
    }

    @Override
    void closeArray() {
        this.closeOuter();
    }

    @Override
    void openItem() {
        this.openInner(Q_ITEM);
    }

    @Override
    void closeItem() {
        this.closeInner();
    }

    @Override
    void addValue(byte[] type, byte[] value) {
        if (this.addValues.peek()) {
            this.element(type).add(value != null ? this.shared.token(value) : null);
        }
    }

    private void openOuter(byte[] type) {
        this.stack.push(this.element(type));
    }

    private void closeOuter() {
        this.stack.pop();
    }

    private void openInner(QNm type) {
        this.curr = FElem.build(type);
        this.stack.push(this.curr);
    }

    private void closeInner() {
        this.curr = (FBuilder)this.stack.pop();
        if (!this.stack.isEmpty()) {
            this.curr = ((FBuilder)this.stack.peek()).add(this.curr);
        }
    }

    private FBuilder element(byte[] type) {
        if (this.curr == null) {
            this.curr = FElem.build(Q_JSON);
        }
        this.processType(this.curr, type);
        return this.curr;
    }
}

