/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.dialog.DialogLine;
import org.basex.gui.dialog.DialogSort;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.layout.BaseXScrollBar;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.GUICode;
import org.basex.gui.listener.LinkListener;
import org.basex.gui.text.ReplaceContext;
import org.basex.gui.text.SearchBar;
import org.basex.gui.text.SearchContext;
import org.basex.gui.text.Syntax;
import org.basex.gui.text.SyntaxJS;
import org.basex.gui.text.SyntaxJSON;
import org.basex.gui.text.SyntaxXML;
import org.basex.gui.text.SyntaxXQuery;
import org.basex.gui.text.TextEditor;
import org.basex.gui.text.TextIterator;
import org.basex.gui.text.TextRenderer;
import org.basex.io.IO;
import org.basex.query.QueryText;
import org.basex.query.func.FuncDefinition;
import org.basex.query.func.Functions;
import org.basex.util.History;
import org.basex.util.Prop;
import org.basex.util.SmartStrings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;

public class TextPanel
extends BaseXPanel {
    private final Timer caretTimer;
    public final TextEditor editor;
    public final History hist;
    private final TextRenderer rend;
    private final BaseXScrollBar scroll;
    private final boolean editable;
    protected SearchBar search;
    private LinkListener linkListener;
    private int clicks;
    private final GUICode computeHeight = new GUICode(){

        @Override
        public void execute(Object down) {
            TextPanel.this.rend.computeHeight();
            TextPanel.this.updateScrollpos.execute((Boolean)down != false ? 2 : 0);
        }
    };
    private final GUICode updateScrollpos = new GUICode(){

        @Override
        public void execute(Object align) {
            TextPanel.this.scroll(TextPanel.this.rend.cursorY(), (Integer)align);
        }
    };
    private int lastCol = -1;
    private final GUICode resizeCode = new GUICode(){

        @Override
        public void execute(Object arg) {
            TextPanel.this.rend.computeHeight();
            TextPanel.this.scroll.pos(TextPanel.this.scroll.pos());
            TextPanel.this.rend.repaint();
        }
    };
    private static final ArrayList<ArrayList<Map.Entry<String, String>>> LISTS = new ArrayList();

    public TextPanel(BaseXWindow win, boolean editable) {
        this(win, "", editable);
    }

    public TextPanel(BaseXWindow win, String text, boolean editable) {
        super(win);
        GUICommand[] gUICommandArray;
        this.editable = editable;
        this.editor = new TextEditor(this.gui);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(!editable);
        this.setBackground(GUIConstants.BACK);
        this.setOpaque(editable);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (TextPanel.this.isEnabled()) {
                    TextPanel.this.caret(true);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                TextPanel.this.caret(false);
            }
        });
        this.setFont(GUIConstants.dmfont);
        this.layout(new BorderLayout());
        this.scroll = new BaseXScrollBar(this);
        this.rend = new TextRenderer(this.editor, this.scroll, editable, this.gui);
        this.add((Component)this.rend, "Center");
        this.add((Component)this.scroll, "East");
        this.setText(text);
        this.hist = new History(editable ? this.editor.text() : null);
        if (editable) {
            GUICommand[] gUICommandArray2 = new GUICommand[18];
            gUICommandArray2[0] = new FindCmd();
            gUICommandArray2[1] = new FindNextCmd();
            gUICommandArray2[2] = new FindPrevCmd();
            gUICommandArray2[3] = new MatchCaseCmd();
            gUICommandArray2[4] = new WholeWordCmd();
            gUICommandArray2[5] = new RegExCmd();
            gUICommandArray2[6] = new MultiLineCmd();
            gUICommandArray2[7] = null;
            gUICommandArray2[8] = new GotoCmd();
            gUICommandArray2[9] = null;
            gUICommandArray2[10] = new UndoCmd();
            gUICommandArray2[11] = new RedoCmd();
            gUICommandArray2[12] = null;
            gUICommandArray2[13] = new AllCmd();
            gUICommandArray2[14] = new CutCmd();
            gUICommandArray2[15] = new CopyCmd();
            gUICommandArray2[16] = new PasteCmd();
            gUICommandArray = gUICommandArray2;
            gUICommandArray2[17] = new DelCmd();
        } else {
            GUICommand[] gUICommandArray3 = new GUICommand[12];
            gUICommandArray3[0] = new FindCmd();
            gUICommandArray3[1] = new FindNextCmd();
            gUICommandArray3[2] = new FindPrevCmd();
            gUICommandArray3[3] = new MatchCaseCmd();
            gUICommandArray3[4] = new WholeWordCmd();
            gUICommandArray3[5] = new RegExCmd();
            gUICommandArray3[6] = new MultiLineCmd();
            gUICommandArray3[7] = null;
            gUICommandArray3[8] = new GotoCmd();
            gUICommandArray3[9] = null;
            gUICommandArray3[10] = new AllCmd();
            gUICommandArray = gUICommandArray3;
            gUICommandArray3[11] = new CopyCmd();
        }
        new BaseXPopup(this, gUICommandArray);
        this.caretTimer = new Timer(500, e -> this.rend.caret(!this.rend.caret()));
    }

    public void setText(String t) {
        this.setText(Token.token(t));
    }

    public void setText(byte[] t) {
        this.setText(t, t.length);
        this.resetError();
    }

    public final String searchString() {
        String string = this.editor.selected();
        return string.indexOf(10) == -1 ? string : "";
    }

    public final int[] caretPos() {
        return this.rend.caretPos();
    }

    public final void setText(byte[] text, int size) {
        byte[] txt = text;
        if (Token.contains(text, 13)) {
            int ns = 0;
            for (int r = 0; r < size; ++r) {
                byte b = text[r];
                if (b == 13) continue;
                text[ns++] = b;
            }
            txt = Arrays.copyOf(text, ns);
        } else if (text.length != size) {
            txt = Arrays.copyOf(text, size);
        }
        if (this.editor.text(txt) && this.hist != null) {
            this.hist.store(txt, this.editor.pos(), 0);
        }
        if (this.isShowing()) {
            this.resizeCode.invokeLater();
        }
    }

    protected final void setSyntax(IO file, boolean opened) {
        this.setSyntax(!opened || file.hasSuffix(IO.XQSUFFIXES) ? new SyntaxXQuery() : (file.hasSuffix(".json") ? new SyntaxJSON() : (file.hasSuffix(IO.JSSUFFIXES) ? new SyntaxJS() : (file.hasSuffix(this.gui.gopts.xmlSuffixes()) || file.hasSuffix(IO.HTMLSUFFIXES) || file.hasSuffix(IO.XSLSUFFIXES) || file.hasSuffix(".bxs") ? new SyntaxXML() : Syntax.SIMPLE))));
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setSyntax(Syntax syntax) {
        this.rend.setSyntax(syntax);
    }

    public final void setCaret(int pos) {
        this.editor.pos(pos);
        this.updateScrollpos.invokeLater(1);
        this.caret(true);
    }

    private int getCaret() {
        return this.editor.pos();
    }

    public final byte[] getText() {
        return this.editor.text();
    }

    public final boolean selected() {
        return this.editor.isSelected();
    }

    @Override
    public final void setFont(Font f) {
        super.setFont(f);
        if (this.rend != null) {
            this.rend.setFont(f);
            this.computeHeight.invokeLater(true);
        }
    }

    public final void resetError() {
        this.editor.error(-1);
        this.rend.repaint();
    }

    public final void error(int pos) {
        this.editor.error(pos);
        this.rend.repaint();
    }

    public final void comment() {
        int caret = this.editor.pos();
        if (this.editor.comment(this.rend.getSyntax())) {
            this.hist.store(this.editor.text(), caret, this.editor.pos());
        }
        this.computeHeight.invokeLater(true);
    }

    public final void toCase(TextEditor.Case cs) {
        int caret = this.editor.pos();
        if (this.editor.toCase(cs)) {
            this.hist.store(this.editor.text(), caret, this.editor.pos());
        }
        this.computeHeight.invokeLater(true);
    }

    public final void bracket() {
        this.setCaret(this.editor.bracket());
    }

    public final void sort() {
        int caret = this.editor.pos();
        DialogSort ds = new DialogSort(this.gui);
        if (!ds.ok() || !this.editor.sort()) {
            return;
        }
        this.hist.store(this.editor.text(), caret, this.editor.pos());
        this.computeHeight.invokeLater(true);
        this.repaint();
    }

    public final void format() {
        int caret = this.editor.pos();
        if (this.editor.format(this.rend.getSyntax())) {
            this.hist.store(this.editor.text(), caret, this.editor.pos());
        }
        this.computeHeight.invokeLater(true);
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.rend.setEnabled(enabled);
        this.scroll.setEnabled(enabled);
        this.caret(enabled);
    }

    private void selectAll() {
        this.editor.selectAll();
        this.rend.repaint();
    }

    public final void setLinkListener(LinkListener ll) {
        this.linkListener = ll;
    }

    final void setSearch(SearchBar s) {
        this.search = s;
    }

    public final SearchBar getSearch() {
        return this.search;
    }

    final void search(SearchContext sc, boolean jump) {
        this.rend.search(sc, jump);
    }

    final void replace(ReplaceContext rc) {
        try {
            int[] select = this.rend.replace(rc);
            if (rc.text != null) {
                boolean sel = this.editor.isSelected();
                this.setText(rc.text);
                this.editor.select(select[0], select[sel ? 1 : 0]);
                this.release(Action.CHECK);
            }
            this.gui.status.setText(Text.STRINGS_REPLACED, true);
        }
        catch (Exception ex) {
            String msg = Util.message(ex).replaceAll(Prop.NL + ".*", "");
            this.gui.status.setText(Text.REGULAR_EXPR + ": " + msg, false);
        }
    }

    protected final void jump(SearchBar.SearchDir dir, boolean select) {
        SwingUtilities.invokeLater(() -> this.scroll(this.rend.jump(dir, select), 1));
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
        this.gui.cursor(GUIConstants.CURSORTEXT);
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        this.gui.cursor(GUIConstants.CURSORARROW);
    }

    @Override
    public final void mouseMoved(MouseEvent e) {
        if (this.linkListener == null) {
            return;
        }
        TextIterator iter = this.rend.jump(e.getPoint());
        this.gui.cursor(iter.link() != null ? GUIConstants.CURSORHAND : GUIConstants.CURSORARROW);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        TextIterator iter;
        String link;
        if (!SwingUtilities.isLeftMouseButton(e) || this.linkListener == null) {
            return;
        }
        this.editor.endSelection();
        if (!this.editor.isSelected() && (link = (iter = this.rend.jump(e.getPoint())).link()) != null) {
            this.linkListener.linkClicked(link);
        }
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.clicks == 1) {
            this.select(e.getPoint(), false);
            int y = Math.max(20, Math.min(e.getY(), this.getHeight() - 20));
            if (y != e.getY()) {
                this.scroll.pos(this.scroll.pos() + e.getY() - y);
            }
        }
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        if (SwingUtilities.isMiddleMouseButton(e)) {
            ArrayList<Object> clips;
            if (this.editor.isSelected()) {
                this.copy();
                this.editor.noSelect();
                this.rend.repaint();
            } else if (this.editable && this.isEnabled() && !(clips = BaseXLayout.fromClipboard(null)).isEmpty()) {
                this.paste(clips.get(0).toString());
            }
            return;
        }
        if (!this.isEnabled() || !this.isFocusable()) {
            return;
        }
        this.requestFocusInWindow();
        this.caret(true);
        boolean shift = e.isShiftDown();
        boolean selected = this.editor.isSelected();
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.clicks = e.getClickCount();
            if (this.clicks == 1) {
                if (shift) {
                    this.editor.startSelection(true);
                }
                this.select(e.getPoint(), !shift);
            } else if (this.clicks == 2) {
                this.editor.selectWord();
            } else {
                this.editor.selectLine();
            }
        } else if (!selected) {
            this.select(e.getPoint(), true);
        }
    }

    private void select(Point point, boolean start) {
        this.editor.select(this.rend.jump(point).pos(), start);
        this.rend.repaint();
    }

    private boolean specialKey(KeyEvent e) {
        if (BaseXKeys.PREVTAB.is(e)) {
            this.gui.editor.tab(false);
        } else if (BaseXKeys.NEXTTAB.is(e)) {
            this.gui.editor.tab(true);
        } else if (BaseXKeys.CLOSETAB.is(e)) {
            this.gui.editor.close(null);
        } else if (this.search != null && BaseXKeys.ESCAPE.is(e)) {
            this.search.deactivate(true);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        byte[] tmp;
        if (this.specialKey(e) || BaseXKeys.modifier(e)) {
            e.consume();
            return;
        }
        this.caret(true);
        int fh = this.rend.fontHeight();
        if (BaseXKeys.SCROLLDOWN.is(e)) {
            this.scroll.pos(this.scroll.pos() + fh);
            return;
        }
        if (BaseXKeys.SCROLLUP.is(e)) {
            this.scroll.pos(this.scroll.pos() - fh);
            return;
        }
        boolean selected = this.editor.isSelected();
        int pos = this.editor.pos();
        boolean shift = e.isShiftDown();
        boolean down = true;
        boolean consumed = true;
        int lc = Integer.MIN_VALUE;
        byte[] txt = this.editor.text();
        if (BaseXKeys.NEXTWORD.is(e)) {
            this.editor.nextWord(shift);
        } else if (BaseXKeys.PREVWORD.is(e)) {
            this.editor.prevWord(shift);
            down = false;
        } else if (BaseXKeys.TEXTSTART.is(e)) {
            this.editor.textStart(shift);
            down = false;
        } else if (BaseXKeys.TEXTEND.is(e)) {
            this.editor.textEnd(shift);
        } else if (BaseXKeys.LINESTART.is(e)) {
            this.editor.lineStart(shift);
            down = false;
        } else if (BaseXKeys.LINEEND.is(e)) {
            this.editor.lineEnd(shift);
        } else if (BaseXKeys.PREVPAGE_RO.is(e) && !this.hist.active()) {
            lc = this.editor.linesUp(this.getHeight() / fh, false, this.lastCol);
            down = false;
        } else if (BaseXKeys.NEXTPAGE_RO.is(e) && !this.hist.active()) {
            lc = this.editor.linesDown(this.getHeight() / fh, false, this.lastCol);
        } else if (BaseXKeys.PREVPAGE.is(e) && !BaseXKeys.sc(e)) {
            lc = this.editor.linesUp(this.getHeight() / fh, shift, this.lastCol);
            down = false;
        } else if (BaseXKeys.NEXTPAGE.is(e) && !BaseXKeys.sc(e)) {
            lc = this.editor.linesDown(this.getHeight() / fh, shift, this.lastCol);
        } else if (BaseXKeys.NEXTLINE.is(e) && !BaseXKeys.MOVEDOWN.is(e)) {
            lc = this.editor.linesDown(1, shift, this.lastCol);
        } else if (BaseXKeys.PREVLINE.is(e) && !BaseXKeys.MOVEUP.is(e)) {
            lc = this.editor.linesUp(1, shift, this.lastCol);
            down = false;
        } else if (BaseXKeys.NEXTCHAR.is(e)) {
            this.editor.next(shift);
        } else if (BaseXKeys.PREVCHAR.is(e)) {
            this.editor.previous(shift);
            down = false;
        } else {
            consumed = false;
        }
        int n = this.lastCol = lc == Integer.MIN_VALUE ? -1 : lc;
        if (this.hist.active()) {
            if (BaseXKeys.COMPLETE.is(e)) {
                this.complete();
                return;
            }
            if (BaseXKeys.MOVEDOWN.is(e)) {
                this.editor.move(true);
            } else if (BaseXKeys.MOVEUP.is(e)) {
                this.editor.move(false);
            } else if (BaseXKeys.DUPLLINES.is(e)) {
                this.editor.duplLines();
            } else if (BaseXKeys.DELLINES.is(e)) {
                this.editor.deleteLines();
            } else if (BaseXKeys.DELNEXTWORD.is(e)) {
                this.editor.deleteNext(true);
            } else if (BaseXKeys.DELLINEEND.is(e)) {
                this.editor.deleteNext(false);
            } else if (BaseXKeys.DELNEXT.is(e)) {
                this.editor.delete();
            } else if (BaseXKeys.DELPREVWORD.is(e)) {
                this.editor.deletePrev(true);
                down = false;
            } else if (BaseXKeys.DELLINESTART.is(e)) {
                this.editor.deletePrev(false);
                down = false;
            } else if (BaseXKeys.DELPREV.is(e)) {
                this.editor.deletePrev();
                down = false;
            } else {
                consumed = false;
            }
        }
        if (consumed) {
            e.consume();
        }
        if (txt != (tmp = this.editor.text())) {
            this.hist.store(tmp, pos, this.editor.pos());
            this.computeHeight.invokeLater(down);
        } else if (pos != this.editor.pos() || selected != this.editor.isSelected()) {
            this.updateScrollpos.invokeLater(down ? 2 : 0);
        }
    }

    private void scroll(int y, int align) {
        if (y != -1) {
            int h = this.getHeight();
            int m = y + (this.rend.fontHeight() << 1) - h;
            int p = this.scroll.pos();
            if (p < m || p > y) {
                this.scroll.pos(align == 0 ? y : (align == 1 ? y - h / 2 : m));
            }
        }
        this.rend.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        boolean selected;
        if (!this.hist.active() || BaseXKeys.control(e) || BaseXKeys.DELNEXT.is(e) || BaseXKeys.DELPREV.is(e) || BaseXKeys.ESCAPE.is(e) || BaseXKeys.CUT2.is(e)) {
            return;
        }
        int caret = this.editor.pos();
        StringBuilder sb = new StringBuilder(1).append(e.getKeyChar());
        boolean indent = BaseXKeys.TAB.is(e) && this.editor.indent(sb, e.isShiftDown());
        boolean bl = selected = this.editor.isSelected() && !indent;
        if (selected) {
            this.editor.delete();
        }
        int move = BaseXKeys.ENTER.is(e) ? this.editor.enter(sb) : this.editor.add(sb, selected);
        this.hist.store(this.editor.text(), caret, this.editor.pos());
        if (move != 0) {
            this.editor.pos(Math.min(this.editor.size(), caret + move));
        }
        this.computeHeight.invokeLater(true);
        e.consume();
    }

    protected void release(Action action) {
    }

    public final void refreshLayout(Font f) {
        this.setFont(f);
        this.scroll.refreshLayout();
    }

    private void paste(String string) {
        int pos = this.editor.pos();
        if (this.editor.isSelected()) {
            this.editor.delete();
        }
        this.editor.insert(string);
        this.finish(pos);
    }

    private boolean copy() {
        boolean copy;
        String txt = this.editor.selected();
        boolean bl = copy = !txt.isEmpty();
        if (copy) {
            BaseXLayout.toClipboard(txt);
        }
        return copy;
    }

    private void finish(int old) {
        if (old != -1) {
            this.hist.store(this.editor.text(), old, this.editor.pos());
        }
        this.computeHeight.invokeLater(true);
        this.release(Action.CHECK);
    }

    private void caret(boolean start) {
        this.caretTimer.stop();
        if (start) {
            this.caretTimer.start();
        }
        this.rend.caret(start);
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent e) {
        this.scroll.pos(this.scroll.pos() + e.getUnitsToScroll() * 20);
        this.rend.repaint();
    }

    @Override
    public final void componentResized(ComponentEvent e) {
        this.resizeCode.invokeLater();
    }

    private void search(boolean next) {
        boolean vis = this.search.isVisible();
        this.search.activate(this.searchString(), false, false);
        this.jump(vis ? (next ? SearchBar.SearchDir.FORWARD : SearchBar.SearchDir.BACKWARD) : SearchBar.SearchDir.CURRENT, true);
    }

    private void gotoLine() {
        byte[] last = this.editor.text();
        int ll = last.length;
        int cr = this.getCaret();
        int l = 1;
        for (int e = 0; e < ll && e < cr; e += Token.cl(last, e)) {
            if (last[e] != 10) continue;
            ++l;
        }
        DialogLine dl = new DialogLine(this.gui, l);
        if (!dl.ok()) {
            return;
        }
        int el = dl.line();
        l = 1;
        int p = 0;
        for (int e = 0; e < ll && l < el; e += Token.cl(last, e)) {
            if (last[e] != 10) continue;
            p = e + 1;
            ++l;
        }
        this.setCaret(p);
        this.gui.editor.posCode.invokeLater();
    }

    private void complete() {
        int l;
        if (this.selected()) {
            return;
        }
        int caret = this.editor.pos();
        int start = this.editor.completionStart();
        String input = Token.string(Token.substring(this.editor.text(), start, caret)).toLowerCase(Locale.ENGLISH);
        ArrayList pairs = new ArrayList();
        Consumer<Map.Entry> add = pair -> {
            for (Map.Entry p : pairs) {
                if (p == null || !((String)p.getValue()).equals(pair.getValue())) continue;
                return;
            }
            pairs.add(pair);
        };
        int ll = LISTS.size();
        for (l = 0; l < ll; ++l) {
            pairs.add(null);
            for (Map.Entry<String, String> pair2 : LISTS.get(l)) {
                String name = pair2.getKey();
                if (!name.startsWith(input) && !name.replace(":", "").startsWith(input)) continue;
                add.accept(pair2);
            }
        }
        if (pairs.size() != ll + 1) {
            pairs.add(null);
            for (l = 0; l < ll; ++l) {
                for (Map.Entry<String, String> pair2 : LISTS.get(l)) {
                    if (!SmartStrings.charsOccurIn(pair2.getKey(), input)) continue;
                    add.accept(pair2);
                }
            }
        }
        int p = 0;
        while (p < pairs.size()) {
            if (pairs.get(p) == null && (p == 0 || p + 1 == pairs.size() || pairs.get(p + 1) == null)) {
                pairs.remove(p);
                continue;
            }
            ++p;
        }
        if (pairs.size() == 1) {
            this.complete((String)((Map.Entry)pairs.get(0)).getValue(), start);
        } else if (!pairs.isEmpty()) {
            JPopupMenu pm = new JPopupMenu();
            ActionListener al = ae -> this.complete(ae.getActionCommand().replaceAll("^.*?] ", ""), start);
            for (Map.Entry entry : pairs) {
                JMenuItem mi;
                if (entry == null) {
                    pm.addSeparator();
                } else {
                    mi = new JMenuItem((String)entry.getValue());
                    pm.add(mi);
                    mi.addActionListener(al);
                }
                if (pm.getComponentCount() < 15) continue;
                mi = new JMenuItem("... " + Util.info(Text.RESULTS_X, pairs.size()));
                mi.setEnabled(false);
                pm.add(mi);
                break;
            }
            int[] cursor = this.rend.cursor();
            pm.show(this, cursor[0], cursor[1]);
            MenuElement[] me = new MenuElement[]{pm, (JMenuItem)pm.getComponent(0)};
            MenuSelectionManager.defaultManager().setSelectedPath(me);
        }
    }

    private void complete(String string, int start) {
        int pos = this.editor.pos();
        this.editor.complete(string, start);
        this.finish(pos);
    }

    static {
        for (int l = 0; l < 5; ++l) {
            LISTS.add(new ArrayList());
        }
        TokenMap map = Util.properties("completions.properties");
        for (byte[] key : map) {
            LISTS.get(0).add(new AbstractMap.SimpleEntry<String, String>(Token.string(key), Token.string(map.get(key))));
        }
        for (FuncDefinition fd : Functions.DEFINITIONS) {
            String func = fd.toString();
            String name = func.replaceAll("^fn:|\\(.*", "");
            String value = name + (func.contains("()") ? "()" : "(_)");
            BiConsumer<Integer, String> add = (i, string) -> LISTS.get((int)i).add(new AbstractMap.SimpleEntry<String, String>(string.toLowerCase(Locale.ENGLISH), value));
            if (fd.uri() == QueryText.FN_URI) {
                add.accept(1, name.replaceAll("(.)[^-A-Z]*-?", "$1"));
                add.accept(2, name);
                continue;
            }
            add.accept(3, name.replaceAll("(:?.)[^-:A-Z]*-?", "$1"));
            add.accept(4, name);
        }
    }

    private class GotoCmd
    extends GUIPopupCmd {
        GotoCmd() {
            super(Text.GO_TO_LINE + "...", BaseXKeys.GOTOLINE);
        }

        @Override
        public void execute() {
            TextPanel.this.gotoLine();
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.search != null;
        }
    }

    private class MultiLineCmd
    extends GUIPopupCmd {
        MultiLineCmd() {
            super(Text.MULTI_LINE, BaseXKeys.MULTILINE);
        }

        @Override
        public void execute() {
            TextPanel.this.search.toggle(TextPanel.this.search.multi);
        }

        @Override
        public boolean toggle() {
            return true;
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.search != null && TextPanel.this.search.multi.isEnabled();
        }

        @Override
        public boolean selected(GUI main) {
            return TextPanel.this.search.multi.isSelected();
        }
    }

    private class RegExCmd
    extends GUIPopupCmd {
        RegExCmd() {
            super(Text.REGULAR_EXPR, BaseXKeys.REGEX);
        }

        @Override
        public void execute() {
            TextPanel.this.search.toggle(TextPanel.this.search.regex);
        }

        @Override
        public boolean toggle() {
            return true;
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.search != null;
        }

        @Override
        public boolean selected(GUI main) {
            return TextPanel.this.search.regex.isSelected();
        }
    }

    private class WholeWordCmd
    extends GUIPopupCmd {
        WholeWordCmd() {
            super(Text.WHOLE_WORD, BaseXKeys.WHOLEWORD);
        }

        @Override
        public void execute() {
            TextPanel.this.search.toggle(TextPanel.this.search.word);
        }

        @Override
        public boolean toggle() {
            return true;
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.search != null && TextPanel.this.search.word.isEnabled();
        }

        @Override
        public boolean selected(GUI main) {
            return TextPanel.this.search.word.isSelected();
        }
    }

    private class MatchCaseCmd
    extends GUIPopupCmd {
        MatchCaseCmd() {
            super(Text.MATCH_CASE, BaseXKeys.MATCHCASE);
        }

        @Override
        public void execute() {
            TextPanel.this.search.toggle(TextPanel.this.search.mcase);
        }

        @Override
        public boolean toggle() {
            return true;
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.search != null;
        }

        @Override
        public boolean selected(GUI main) {
            return TextPanel.this.search.mcase.isSelected();
        }
    }

    private class FindPrevCmd
    extends GUIPopupCmd {
        FindPrevCmd() {
            super(Text.FIND_PREVIOUS, BaseXKeys.FINDPREV1, BaseXKeys.FINDPREV2);
        }

        @Override
        public void execute() {
            TextPanel.this.search(false);
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.search != null;
        }
    }

    private class FindNextCmd
    extends GUIPopupCmd {
        FindNextCmd() {
            super(Text.FIND_NEXT, BaseXKeys.FINDNEXT1, BaseXKeys.FINDNEXT2);
        }

        @Override
        public void execute() {
            TextPanel.this.search(true);
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.search != null;
        }
    }

    private class FindCmd
    extends GUIPopupCmd {
        FindCmd() {
            super(Text.FIND + "\u2026", BaseXKeys.FIND);
        }

        @Override
        public void execute() {
            TextPanel.this.search.activate(TextPanel.this.searchString(), true, false);
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.search != null;
        }
    }

    private class AllCmd
    extends GUIPopupCmd {
        AllCmd() {
            super(Text.SELECT_ALL, BaseXKeys.SELECTALL);
        }

        @Override
        public void execute() {
            TextPanel.this.selectAll();
        }
    }

    private class DelCmd
    extends GUIPopupCmd {
        DelCmd() {
            super(Text.DELETE, BaseXKeys.DELNEXT);
        }

        @Override
        public void execute() {
            int pos = TextPanel.this.editor.pos();
            TextPanel.this.editor.delete();
            TextPanel.this.finish(pos);
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.hist.active() && TextPanel.this.editor.isSelected();
        }
    }

    private class PasteCmd
    extends GUIPopupCmd {
        PasteCmd() {
            super(Text.PASTE, BaseXKeys.PASTE1, BaseXKeys.PASTE2);
        }

        @Override
        public void execute() {
            ArrayList<Object> contents = BaseXLayout.fromClipboard(null);
            if (!contents.isEmpty()) {
                TextPanel.this.paste(contents.get(0).toString());
            }
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.hist.active() && !BaseXLayout.fromClipboard(null).isEmpty();
        }
    }

    private class CopyCmd
    extends GUIPopupCmd {
        CopyCmd() {
            super(Text.COPY, BaseXKeys.COPY1, BaseXKeys.COPY2);
        }

        @Override
        public void execute() {
            TextPanel.this.copy();
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.editor.isSelected();
        }
    }

    private class CutCmd
    extends GUIPopupCmd {
        CutCmd() {
            super(Text.CUT, BaseXKeys.CUT1, BaseXKeys.CUT2);
        }

        @Override
        public void execute() {
            int pos = TextPanel.this.editor.pos();
            if (!TextPanel.this.copy()) {
                return;
            }
            TextPanel.this.editor.delete();
            TextPanel.this.finish(pos);
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.hist.active() && TextPanel.this.editor.isSelected();
        }
    }

    private class RedoCmd
    extends GUIPopupCmd {
        RedoCmd() {
            super(Text.REDO, BaseXKeys.REDOSTEP);
        }

        @Override
        public void execute() {
            if (!TextPanel.this.hist.active()) {
                return;
            }
            byte[] t = TextPanel.this.hist.next();
            if (t == null) {
                return;
            }
            TextPanel.this.editor.text(t);
            TextPanel.this.editor.pos(TextPanel.this.hist.caret());
            TextPanel.this.finish(-1);
        }

        @Override
        public boolean enabled(GUI main) {
            return !TextPanel.this.hist.last();
        }
    }

    private class UndoCmd
    extends GUIPopupCmd {
        UndoCmd() {
            super(Text.UNDO, BaseXKeys.UNDOSTEP);
        }

        @Override
        public void execute() {
            if (!TextPanel.this.hist.active()) {
                return;
            }
            byte[] t = TextPanel.this.hist.prev();
            if (t == null) {
                return;
            }
            TextPanel.this.editor.text(t);
            TextPanel.this.editor.pos(TextPanel.this.hist.caret());
            TextPanel.this.finish(-1);
        }

        @Override
        public boolean enabled(GUI main) {
            return !TextPanel.this.hist.first();
        }
    }

    public static enum Action {
        CHECK,
        PARSE,
        EXECUTE,
        TEST;

    }
}

