/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Text;
import org.basex.core.jobs.Job;
import org.basex.gui.GUI;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXMem;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.ColumnLayout;
import org.basex.util.Performance;
import org.basex.util.Util;

public final class DialogProgress
extends BaseXDialog
implements ActionListener {
    private static final int MAX = 600;
    private final Timer timer = new Timer(100, this);
    private BaseXLabel info;
    private BaseXButton cancel;
    private BaseXMem mem;
    private Command command;
    private JProgressBar bar;

    private DialogProgress(GUI gui, Command cmd) {
        super(gui, "");
        this.init(gui, cmd);
    }

    private DialogProgress(BaseXDialog dialog, Command cmd) {
        super(dialog, "");
        this.init(dialog, cmd);
    }

    private void init(BaseXWindow win, Command cmd) {
        this.info = new BaseXLabel(" ", true, true);
        this.set(this.info, "North");
        if (cmd.supportsProg()) {
            this.bar = new JProgressBar(0, 600);
            this.set(this.bar, "Center");
        } else {
            this.bar = null;
        }
        BaseXLayout.setWidth(this.info, 600);
        BaseXBack s = new BaseXBack(new BorderLayout()).border(10, 0, 0, 0);
        BaseXBack m = new BaseXBack(new ColumnLayout(5));
        this.mem = new BaseXMem(this, false);
        m.add(new BaseXLabel(Text.MEMUSED_C));
        m.add(this.mem);
        s.add((Component)m, "West");
        if (cmd.stoppable()) {
            this.cancel = new BaseXButton(this, Text.B_CANCEL);
            s.add((Component)this.cancel, "East");
        }
        this.set(s, "South");
        this.command = cmd;
        this.timer.start();
        this.pack();
        this.setLocationRelativeTo(win.component());
    }

    @Override
    public void cancel() {
        if (this.cancel != null) {
            this.cancel.setEnabled(false);
        }
        this.command.stop();
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.timer.stop();
        this.command = null;
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Job job = this.command.active();
        this.setTitle(job.shortInfo());
        String detail = job.detailedInfo();
        this.info.setText(detail.isEmpty() ? " " : detail);
        this.mem.repaint();
        if (this.bar != null) {
            this.bar.setValue((int)(job.progressInfo() * 600.0));
        }
    }

    static void execute(BaseXDialog dialog, Command ... cmds) {
        DialogProgress.execute(dialog, null, cmds);
    }

    public static void execute(GUI gui, Command ... cmds) {
        DialogProgress.execute(gui, null, null, cmds);
    }

    static void execute(BaseXDialog dialog, Runnable post, Command ... cmds) {
        DialogProgress.execute(dialog.gui(), dialog, post, cmds);
    }

    private static void execute(GUI gui, BaseXDialog dialog, Runnable post, Command ... cmds) {
        for (Command cmd : cmds) {
            boolean newData = cmd.newData(gui.context);
            if (newData) {
                gui.notify.init();
            }
            DialogProgress wait = dialog != null ? new DialogProgress(dialog, cmd) : new DialogProgress(gui, cmd);
            new Thread(() -> {
                String info;
                Performance perf = new Performance();
                gui.updating = cmd.updating(gui.context);
                boolean ok = true;
                try {
                    cmd.execute(gui.context);
                    info = cmd.info();
                }
                catch (BaseXException ex) {
                    ok = false;
                    info = Util.message(ex);
                }
                finally {
                    gui.updating = false;
                }
                String time = perf.toString();
                gui.info.setInfo(info, cmd, time, ok, true);
                gui.status.setText(cmd + ": " + time, true);
                wait.dispose();
                if (!ok) {
                    BaseXDialog.error(gui, info.equals(Text.INTERRUPTED) ? Text.COMMAND_CANCELED : info);
                }
            }).start();
            wait.setVisible(true);
            if (newData) {
                gui.notify.init();
            } else if (cmd.updating(gui.context)) {
                gui.notify.update();
            }
            gui.editor.refreshContextLabel();
        }
        if (dialog != null && dialog.isVisible()) {
            dialog.action(dialog);
        }
        if (post != null) {
            SwingUtilities.invokeLater(post);
        }
    }
}

