/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.gui.GUI;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.RowLayout;
import org.basex.gui.layout.TableLayout;
import org.basex.util.options.Options;

public class DialogOptions
extends BaseXBack {
    private final GUI gui;
    private final BaseXCheckBox autooptimize;
    private final BaseXCheckBox updindex;
    private final BaseXTextField maxlen;
    private final BaseXTextField maxcats;
    private final BaseXTextField splitsize;

    DialogOptions(BaseXDialog dialog, Data data) {
        this.gui = dialog.gui();
        if (data != null) {
            MetaData meta = data.meta;
            this.maxlen = new BaseXTextField(dialog, Integer.toString(meta.maxlen));
            this.maxcats = new BaseXTextField(dialog, Integer.toString(meta.maxcats));
            this.splitsize = new BaseXTextField(dialog, Integer.toString(meta.splitsize));
            this.updindex = new BaseXCheckBox(dialog, Text.UPD_INDEX, meta.updindex);
            this.autooptimize = new BaseXCheckBox(dialog, Text.AUTOOPTIMIZE, meta.autooptimize);
        } else {
            MainOptions opts = this.gui.context.options;
            this.maxlen = new BaseXTextField(dialog, MainOptions.MAXLEN, (Options)opts);
            this.maxcats = new BaseXTextField(dialog, MainOptions.MAXCATS, (Options)opts);
            this.splitsize = new BaseXTextField(dialog, MainOptions.SPLITSIZE, (Options)opts);
            this.updindex = new BaseXCheckBox(dialog, Text.UPD_INDEX, MainOptions.UPDINDEX, opts);
            this.autooptimize = new BaseXCheckBox(dialog, Text.AUTOOPTIMIZE, MainOptions.AUTOOPTIMIZE, opts);
        }
        this.maxlen.setColumns(8);
        this.maxcats.setColumns(8);
        this.splitsize.setColumns(8);
        BaseXBack p = new BaseXBack(new TableLayout(4, 2, 6, 4));
        p.border(12, 0, 0, 0);
        p.add(new BaseXLabel(MainOptions.MAXLEN.name() + ":", true, true));
        p.add(this.maxlen);
        p.add(new BaseXLabel(MainOptions.MAXCATS.name() + ":", true, true));
        p.add(this.maxcats);
        p.add(new BaseXLabel(MainOptions.SPLITSIZE.name() + ":", true, true));
        p.add(this.splitsize);
        this.border(8);
        this.layout(new RowLayout());
        this.add(new BaseXLabel(Text.INDEX_CREATION).border(0, 0, 8, 0).large());
        this.add(this.updindex);
        this.add(this.autooptimize);
        this.add(p);
        this.add(new BaseXLabel(data != null ? Text.H_DB_OPTIONS_X : "").border(12, 0, 0, 0));
    }

    boolean action() {
        return this.maxlen.check() & this.maxcats.check() & this.splitsize.check();
    }

    void setOptions(Data data) {
        if (data != null) {
            MetaData meta = data.meta;
            meta.maxlen = Integer.parseInt(this.maxlen.getText());
            meta.maxcats = Integer.parseInt(this.maxcats.getText());
        } else {
            this.gui.set(MainOptions.MAXLEN, Integer.parseInt(this.maxlen.getText()));
            this.gui.set(MainOptions.MAXCATS, Integer.parseInt(this.maxcats.getText()));
        }
        this.gui.set(MainOptions.UPDINDEX, this.updindex.isSelected());
        this.gui.set(MainOptions.AUTOOPTIMIZE, this.autooptimize.isSelected());
        this.gui.set(MainOptions.SPLITSIZE, Integer.parseInt(this.splitsize.getText()));
    }
}

