/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.data.NSNode;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Atts;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class Namespaces {
    private final TokenSet prefixes;
    private final TokenSet uris;
    private final NSNode root;
    private final IntList defaults = new IntList(2L);
    private int level = 1;
    private NSNode current;

    public Namespaces() {
        this.prefixes = new TokenSet();
        this.uris = new TokenSet();
        this.current = this.root = new NSNode(-1);
    }

    Namespaces(DataInput in) throws IOException {
        this.prefixes = new TokenSet(in);
        this.uris = new TokenSet(in);
        this.current = this.root = new NSNode(in, null);
    }

    void write(DataOutput out) throws IOException {
        this.prefixes.write(out);
        this.uris.write(out);
        this.root.write(out);
    }

    public boolean isEmpty() {
        return this.uris.isEmpty();
    }

    public int size() {
        return this.uris.size();
    }

    byte[] prefix(int id) {
        return this.prefixes.key(id);
    }

    public byte[] uri(int id) {
        return this.uris.key(id);
    }

    public int uriId(byte[] uri) {
        return this.uris.id(uri);
    }

    byte[] defaultNs(int ndocs) {
        int ch = this.root.children();
        if (ch == 0) {
            return Token.EMPTY;
        }
        if (ch != ndocs) {
            return null;
        }
        int id = 0;
        for (int c = 0; c < ch; ++c) {
            NSNode child = this.root.child(c);
            int[] values = child.values();
            if (child.children() > 0 || child.pre() != 1 || values.length != 2 || this.prefix(values[0]).length != 0) {
                return null;
            }
            if (c == 0) {
                id = values[1];
                continue;
            }
            if (id == values[1]) continue;
            return null;
        }
        return this.uri(id);
    }

    public int uriIdForPrefix(byte[] prefix, boolean element) {
        if (this.isEmpty()) {
            return 0;
        }
        return prefix.length == 0 ? (element ? this.defaults.get(this.level) : 0) : this.uriId(prefix, this.current);
    }

    public int uriIdForPrefix(byte[] prefix, int pre, Data data) {
        return this.uriId(prefix, this.current.find(pre, data));
    }

    private int uriId(byte[] prefix, NSNode node) {
        int prefId = this.prefixes.id(prefix);
        if (prefId == 0) {
            return 0;
        }
        for (NSNode nd = node; nd != null; nd = nd.parent()) {
            int uriId = nd.uri(prefId);
            if (uriId == 0) continue;
            return uriId;
        }
        return 0;
    }

    Atts values(int pre, Data data) {
        int[] values = this.current.find(pre, data).values();
        int nl = values.length;
        Atts as = new Atts(nl / 2);
        for (int n = 0; n < nl; n += 2) {
            as.add(this.prefix(values[n]), this.uri(values[n + 1]));
        }
        return as;
    }

    void root(int pre, Data data) {
        int p;
        LinkedList<NSNode> cand = new LinkedList<NSNode>();
        NSNode nd = this.root;
        cand.add(nd);
        while ((p = nd.find(pre)) > -1) {
            nd = nd.child(p);
            cand.add(0, nd);
        }
        nd = this.root;
        if (cand.size() > 1) {
            int ancPre = pre;
            NSNode curr = (NSNode)cand.remove(0);
            while (ancPre > -1 && nd == this.root) {
                while (ancPre > curr.pre()) {
                    ancPre = data.parent(ancPre, data.kind(ancPre));
                }
                if (ancPre == curr.pre()) {
                    nd = curr;
                }
                if (cand.isEmpty()) continue;
                curr = (NSNode)cand.remove(0);
            }
        }
        int uriId = this.uriIdForPrefix(Token.EMPTY, pre, data);
        this.defaults.set(this.level, uriId);
        this.defaults.set(this.level - 1, uriId);
        this.current = nd;
    }

    ArrayList<NSNode> cache(int pre) {
        ArrayList<NSNode> list = new ArrayList<NSNode>();
        Namespaces.addNodes(this.root, list, pre);
        return list;
    }

    private static void addNodes(NSNode node, List<NSNode> list, int pre) {
        int n;
        int size = node.children();
        for (n = Math.max(0, node.find(pre)); n > 0 && (n == size || node.child(n).pre() >= pre); --n) {
        }
        while (n < size) {
            NSNode child = node.child(n);
            if (child.pre() >= pre) {
                list.add(child);
            }
            Namespaces.addNodes(child, list, pre);
            ++n;
        }
    }

    void cursor(NSNode node) {
        this.current = node;
    }

    NSNode cursor() {
        return this.current;
    }

    public void open() {
        int nu = this.defaults.get(this.level);
        this.defaults.set(++this.level, nu);
    }

    public void open(int pre, Atts atts) {
        this.open();
        if (!atts.isEmpty()) {
            NSNode nd = new NSNode(pre);
            this.current.add(nd);
            this.current = nd;
            int as = atts.size();
            for (int a = 0; a < as; ++a) {
                byte[] prefix = atts.name(a);
                byte[] uri = atts.value(a);
                int prefId = this.prefixes.put(prefix);
                int uriId = this.uris.put(uri);
                nd.add(prefId, uriId);
                if (prefix.length != 0) continue;
                this.defaults.set(this.level, uriId);
            }
        }
    }

    public int add(int pre, byte[] prefix, byte[] uri, Data data) {
        int prefId = this.prefixes.put(prefix);
        int uriId = this.uris.put(uri);
        NSNode nd = this.current.find(pre, data);
        if (nd.pre() != pre) {
            NSNode child = new NSNode(pre);
            nd.add(child);
            nd = child;
        }
        nd.add(prefId, uriId);
        return uriId;
    }

    public void close(int pre) {
        NSNode nd;
        while (this.current.pre() >= pre && (nd = this.current.parent()) != null) {
            this.current = nd;
        }
        --this.level;
    }

    public void delete(byte[] uri) {
        int id = this.uris.id(uri);
        if (id != 0) {
            this.current.delete(id);
        }
    }

    void delete(int pre, int size, Data data) {
        NSNode nd = this.current.find(pre, data);
        if (nd.pre() == pre) {
            nd = nd.parent();
        }
        while (nd != null) {
            nd.delete(pre, size);
            nd = nd.parent();
        }
        this.root.decrementPre(pre, size);
    }

    byte[] table(int start, int end) {
        if (this.root.children() == 0) {
            return Token.EMPTY;
        }
        Table t = new Table();
        t.header.add(DataText.TABLENS);
        t.header.add(DataText.TABLEPRE);
        t.header.add(DataText.TABLEDIST);
        t.header.add(DataText.TABLEPREF);
        t.header.add(DataText.TABLEURI);
        for (int i = 0; i < 3; ++i) {
            t.align.add(true);
        }
        this.root.table(t, start, end, this);
        return t.contents.isEmpty() ? Token.EMPTY : t.finish();
    }

    public byte[] info() {
        TokenObjMap<TokenList> map = new TokenObjMap<TokenList>();
        this.root.info(map, this);
        TokenBuilder tb = new TokenBuilder();
        for (byte[] key : map) {
            tb.add("  ");
            TokenList values = map.get(key).sort();
            int ks = values.size();
            if (ks > 1 || ((byte[])values.get(0)).length != 0) {
                if (values.size() != 1) {
                    tb.add("(");
                }
                for (int k = 0; k < ks; ++k) {
                    if (k != 0) {
                        tb.add(", ");
                    }
                    tb.add((byte[])values.get(k));
                }
                if (ks != 1) {
                    tb.add(")");
                }
                tb.add(" = ");
            }
            tb.addExt("\"%\"" + Text.NL, new Object[]{key});
        }
        return tb.finish();
    }

    String toString(int start, int end) {
        return this.root.toString(this, start, end);
    }

    public String toString() {
        return this.toString(0, Integer.MAX_VALUE);
    }
}

