/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.basex.core.Databases;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ABackup;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.io.out.BufferOutput;
import org.basex.util.DateTime;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class CreateBackup
extends ABackup {
    private int total;
    private int curr;

    public CreateBackup(String pattern) {
        this(pattern, (String)null);
    }

    public CreateBackup(String pattern, String comment) {
        super(pattern != null ? pattern : "", comment);
    }

    @Override
    protected boolean run() {
        StringList names;
        String pattern = this.args[0];
        String comment = this.args[1];
        if (!pattern.isEmpty() && !Databases.validPattern(pattern)) {
            return this.error(Text.NAME_INVALID_X, pattern);
        }
        StringList stringList = names = pattern.isEmpty() ? new StringList("") : this.context.listDBs(pattern);
        if (names.isEmpty()) {
            return this.error(Text.DB_NOT_FOUND_X, pattern);
        }
        boolean ok = true;
        for (String name : names) {
            if (!name.isEmpty() && MetaData.file(this.soptions.dbPath(name), "upd").exists()) {
                this.info(Text.DB_UPDATED_X, name);
                ok = false;
                continue;
            }
            try {
                CreateBackup.backup(name, comment, true, this.soptions, this);
                this.info(Text.DB_BACKUP_X, name, this.jc().performance);
            }
            catch (IOException ex) {
                Util.debug(ex);
                this.info(Text.DB_NOT_BACKUP_X, name);
                ok = false;
            }
        }
        return ok;
    }

    public static void backup(String db, String comment, boolean compress, StaticOptions sopts, CreateBackup cmd) throws IOException {
        IOFile dbpath = sopts.dbPath(db);
        StringList files = sopts.dbFiles(db);
        if (cmd != null) {
            cmd.total = files.size();
        }
        String name = db + "-" + DateTime.format(new Date(), DateTime.DATETIME) + ".zip";
        IOFile backup = sopts.dbPath(name);
        try (BufferOutput bo = new BufferOutput(backup);
             ZipOutputStream out = new ZipOutputStream(bo);){
            if (comment != null) {
                out.setComment((String)(comment.length() > 100 ? comment.substring(0, 100) + "..." : comment));
            }
            out.setLevel(compress ? 1 : 0);
            byte[] data = new byte[4096];
            for (String file : files) {
                if (!file.equals("upd.basex")) {
                    String path = Prop.WIN ? file.replace('\\', '/') : file;
                    out.putNextEntry(new ZipEntry(db + "/" + path));
                    try (FileInputStream in = new FileInputStream(new File(dbpath.file(), file));){
                        int c;
                        while ((c = in.read(data)) != -1) {
                            out.write(data, 0, c);
                        }
                    }
                    out.closeEntry();
                }
                if (cmd == null) continue;
                ++cmd.curr;
            }
        }
    }

    @Override
    public void addLocks() {
        this.addLocks(this.jc().locks.writes, 0);
    }

    @Override
    public String shortInfo() {
        return Text.BACKUP;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    public double progressInfo() {
        return (double)this.curr / (double)this.total;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(Commands.Cmd.CREATE + " " + Commands.CmdCreate.BACKUP).args();
    }
}

