/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Databases;
import org.basex.core.Text;
import org.basex.core.cmd.AUser;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.User;
import org.basex.core.users.Users;

public final class AlterPassword
extends AUser {
    public AlterPassword(String name, String pw) {
        super(name, pw);
    }

    @Override
    protected boolean run() {
        String name = this.args[0];
        String pass = this.args[1];
        if (!Databases.validName(name)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        Users users = this.context.users;
        User user = users.get(name);
        if (user == null) {
            return this.error(Text.UNKNOWN_USER_X, name);
        }
        user.password(pass);
        users.write();
        return this.info(Text.PW_CHANGED_X, name);
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(Commands.Cmd.ALTER + " " + Commands.CmdAlter.PASSWORD).arg(0);
        if (!cb.password()) {
            cb.arg(1);
        }
    }
}

