/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import org.basex.build.csv.CsvParserOptions;
import org.basex.build.html.HtmlOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.cmd.BinaryPut;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.Put;
import org.basex.http.HTTPConnection;
import org.basex.http.HTTPStatus;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTExec;
import org.basex.http.rest.RESTSession;
import org.basex.util.http.MediaType;
import org.basex.util.options.Options;

final class RESTPut {
    private RESTPut() {
    }

    public static RESTExec get(RESTSession session) throws IOException {
        JsonParserOptions opts;
        HTTPConnection conn = session.conn;
        String db = conn.db();
        if (db.isEmpty()) {
            throw HTTPStatus.NO_DATABASE_SPECIFIED.get(new Object[0]);
        }
        RESTCmd.assignOptions(session);
        MainOptions options = conn.context.options;
        ServletInputStream is = conn.request.getInputStream();
        MediaType mt = conn.mediaType();
        boolean xml = true;
        if (mt.isJSON()) {
            opts = new JsonParserOptions();
            opts.assign(mt);
            options.set(MainOptions.JSONPARSER, (Options)opts);
            options.set(MainOptions.PARSER, (Enum)MainOptions.MainParser.JSON);
        } else if (mt.isCSV()) {
            opts = new CsvParserOptions();
            opts.assign(mt);
            options.set(MainOptions.CSVPARSER, (Options)opts);
            options.set(MainOptions.PARSER, (Enum)MainOptions.MainParser.CSV);
        } else if (mt.is(MediaType.TEXT_HTML)) {
            opts = new HtmlOptions();
            opts.assign(mt);
            options.set(MainOptions.HTMLPARSER, (Options)opts);
            options.set(MainOptions.PARSER, (Enum)MainOptions.MainParser.HTML);
        } else if (!mt.is(MediaType.ALL_ALL) && !mt.isXml()) {
            xml = false;
        }
        String path = conn.dbpath();
        if (path.isEmpty()) {
            session.clear();
            if (xml) {
                session.add((Command)new CreateDB(db), (InputStream)is);
            } else {
                session.add((Command)new CreateDB(db)).add((Command)new BinaryPut(db), (InputStream)is);
            }
        } else if (xml) {
            session.add((Command)new Put(path), (InputStream)is);
        } else {
            session.add((Command)new Delete(path)).add((Command)new BinaryPut(path), (InputStream)is);
        }
        return new RESTExec(session, true);
    }
}

