/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.basex.core.MainOptions;
import org.basex.http.HTTPConnection;
import org.basex.io.IOContent;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryException;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Strings;
import org.basex.util.http.MediaType;
import org.basex.util.http.Payload;

public final class RequestContext {
    public final HttpServletRequest request;
    private Map<String, String[]> strings;
    private Map<String, Value> values;
    private Map<String, Value> form;
    private IOContent body;

    public RequestContext(HttpServletRequest request) {
        this.request = request;
    }

    public String queryString() {
        return this.request.getQueryString();
    }

    public Map<String, String[]> queryStrings() throws IOException {
        try {
            if (this.strings == null) {
                this.strings = this.request.getParameterMap();
            }
            return this.strings;
        }
        catch (RuntimeException ex) {
            throw new IOException(ex);
        }
    }

    public Map<String, Value> queryValues() throws IOException {
        if (this.values == null) {
            this.values = new HashMap<String, Value>();
            this.queryStrings().forEach((key, value) -> {
                ItemList items = new ItemList();
                for (String string : value) {
                    items.add((Object)Atm.get((String)string));
                }
                this.values.put((String)key, items.value((Type)AtomType.UNTYPED_ATOMIC));
            });
        }
        return this.values;
    }

    public Map<String, Value> formValues(MainOptions options) throws QueryException, IOException {
        if (this.form == null) {
            this.form = new HashMap<String, Value>();
            MediaType mt = HTTPConnection.mediaType(this.request);
            if (mt.is(MediaType.MULTIPART_FORM_DATA)) {
                this.addMultipart(mt, options, this.form);
            } else if (mt.is(MediaType.APPLICATION_X_WWW_FORM_URLENCODED)) {
                this.addURLEncoded(this.form);
            }
        }
        return this.form;
    }

    public IOContent body() throws IOException {
        if (this.body == null) {
            this.body = new IOContent(BufferInput.get((InputStream)this.request.getInputStream()).content());
        }
        return this.body;
    }

    private void addMultipart(MediaType type, MainOptions options, Map<String, Value> map) throws QueryException, IOException {
        try (ArrayInput is = this.body().inputStream();){
            map.putAll(new Payload((InputStream)is, true, null, options).multiForm(type));
        }
    }

    private void addURLEncoded(Map<String, Value> map) throws IOException {
        for (String param : Strings.split((String)this.body().toString(), (char)'&')) {
            String[] parts = Strings.split((String)param, (char)'=', (int)2);
            if (parts.length != 2) continue;
            Atm atm = Atm.get((String)URLDecoder.decode(parts[1], StandardCharsets.UTF_8));
            map.merge(parts[0], (Value)atm, (value1, value2) -> {
                ItemList items = new ItemList();
                for (Item item : value1) {
                    items.add((Object)item);
                }
                for (Item item : value2) {
                    items.add((Object)item);
                }
                return items.value();
            });
        }
    }
}

