/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.similarity;

import java.util.function.Function;
import org.basex.util.FTToken;
import org.basex.util.Token;

public final class Levenshtein {
    private static final int MAX = 50;
    private final int maxErrors;
    private int[][] matrix;

    public Levenshtein() {
        this(0);
    }

    public Levenshtein(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public static Object similar(byte[] token, Object[] objects) {
        return Levenshtein.similar(token, objects, Function.identity());
    }

    public static Object similar(byte[] token, Object[] objects, Function<Object, Object> prepare) {
        Object similar = null;
        int err = Integer.MAX_VALUE;
        Levenshtein ls = new Levenshtein();
        for (Object obj : objects) {
            int d;
            byte[] compare = Token.token(prepare.apply(obj));
            if (compare == null || (d = ls.distance(token, compare, 0)) >= err) continue;
            similar = obj;
            err = d;
        }
        return err != Integer.MAX_VALUE ? similar : null;
    }

    public boolean similar(byte[] token, byte[] compare) {
        return this.similar(token, compare, this.maxErrors);
    }

    public boolean similar(byte[] token, byte[] compare, int max) {
        return this.distance(token, compare, max) != Integer.MAX_VALUE;
    }

    private int distance(byte[] token, byte[] compare, int max) {
        int k;
        int sl = compare.length;
        int tl = token.length;
        int clen = 0;
        int tlen = 0;
        for (int c = 0; c < sl; c += Token.cl(compare, c)) {
            ++clen;
        }
        for (int t = 0; t < tl; t += Token.cl(token, t)) {
            ++tlen;
        }
        int dlen = Math.abs(clen - tlen);
        if (max == 0 && (tlen < 4 || clen < 4) || tlen > 50 || clen > 50) {
            return dlen == 0 && Levenshtein.same(token, compare) ? 0 : Integer.MAX_VALUE;
        }
        int n = k = max == 0 ? Math.max(1, clen >> 2) : max;
        if (dlen > k) {
            return Integer.MAX_VALUE;
        }
        int[][] mx = this.matrix;
        if (mx == null) {
            mx = new int[52][52];
            int ml = mx.length;
            for (int m = 0; m < ml; ++m) {
                mx[0][m] = m;
                mx[m][0] = m;
            }
            this.matrix = mx;
        }
        int f = -1;
        int g = -1;
        for (int t = 0; t < tlen; t += Token.cl(token, t)) {
            int tn = FTToken.noDiacritics(Token.lc(Token.cp(token, t)));
            int d = Integer.MAX_VALUE;
            for (int c = 0; c < clen; c += Token.cl(compare, c)) {
                int cn = FTToken.noDiacritics(Token.lc(Token.cp(compare, c)));
                int e = Levenshtein.m(mx[t][c + 1] + 1, mx[t + 1][c] + 1, mx[t][c] + (tn == cn ? 0 : 1));
                if (tn == g && cn == f) {
                    e = mx[t][c];
                }
                mx[t + 1][c + 1] = e;
                d = Math.min(d, e);
                g = cn;
            }
            if (d > k) {
                return Integer.MAX_VALUE;
            }
            f = tn;
        }
        int d = mx[tlen][clen];
        return d <= k ? d : Integer.MAX_VALUE;
    }

    public static double distance(int[] cps1, int[] cps2) {
        int l1 = cps1.length;
        int l2 = cps2.length;
        int lMax = Math.max(l1, l2);
        if (lMax == 0) {
            return 1.0;
        }
        int[][] m = new int[lMax + 1][lMax + 1];
        int f2 = -1;
        int f1 = -1;
        for (int p1 = 0; p1 < lMax; ++p1) {
            int c1 = p1 < l1 ? cps1[p1] : 0;
            for (int p2 = 0; p2 < lMax; ++p2) {
                int c2 = p2 < l2 ? cps2[p2] : 0;
                int c = Levenshtein.m(m[p1][p2 + 1] + 1, m[p1 + 1][p2] + 1, m[p1][p2] + (c1 == c2 ? 0 : 1));
                if (c1 == f1 && c2 == f2) {
                    c = m[p1][p2];
                }
                m[p1 + 1][p2 + 1] = c;
                f1 = c2;
            }
            f2 = c1;
        }
        return (double)(lMax - m[lMax][lMax]) / (double)lMax;
    }

    private static int m(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    private static boolean same(byte[] token, byte[] compare) {
        int tl = token.length;
        int cl = compare.length;
        int c = 0;
        for (int t = 0; t < tl && c < cl; t += Token.cl(token, t), c += Token.cl(compare, c)) {
            if (Token.lc(FTToken.noDiacritics(Token.cp(token, t))) == Token.lc(FTToken.noDiacritics(Token.cp(compare, t)))) continue;
            return false;
        }
        return true;
    }
}

