/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.http;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;

public final class MediaType
implements Comparable<MediaType> {
    private static final HashMap<String, MediaType> MEDIATYPES = new HashMap();
    private static final String MULTIPART = "multipart";
    private static final String TEXT = "text";
    private static final String XQUERY = "xquery";
    private static final String CSV = "csv";
    private static final String COMMA_SEPARATED_VALUES = "comma-separated-values";
    private static final String XML_SUFFIX = "+xml";
    private static final String JSON_SUFFIX = "+json";
    public static final MediaType ALL_ALL;
    public static final MediaType APPLICATION_X_WWW_FORM_URLENCODED;
    public static final MediaType APPLICATION_HTML_XML;
    public static final MediaType APPLICATION_JSON;
    public static final MediaType APPLICATION_OCTET_STREAM;
    public static final MediaType APPLICATION_XML;
    public static final MediaType APPLICATION_XML_EPE;
    public static final MediaType MULTIPART_FORM_DATA;
    public static final MediaType TEXT_CSV;
    public static final MediaType TEXT_HTML;
    public static final MediaType TEXT_PLAIN;
    public static final MediaType TEXT_XML;
    public static final MediaType TEXT_XML_EPE;
    private final String main;
    private final String sub;
    private final HashMap<String, String> parameters = new HashMap();

    public MediaType(String string) {
        int p = string.indexOf(59);
        String type = p == -1 ? string : string.substring(0, p);
        int s = type.indexOf(47);
        this.main = s == -1 ? type : type.substring(0, s);
        String string2 = this.sub = s == -1 ? "" : type.substring(s + 1);
        if (p != -1) {
            for (String param : Strings.split(string.substring(p + 1), ';')) {
                String v;
                String[] kv = Strings.split(param, '=', 2);
                String k = kv[0].trim().toLowerCase(Locale.ENGLISH);
                String string3 = v = kv.length < 2 ? "" : kv[1].trim();
                if (Strings.startsWith(v, '\"')) {
                    v = v.replaceAll("^\"|\"$", "").replaceAll("\\\\(.)", "$1");
                }
                this.parameters.put(k, v);
            }
        }
    }

    public String main() {
        return this.main;
    }

    public String sub() {
        return this.sub;
    }

    public String type() {
        return this.sub.isEmpty() ? this.main : this.main + "/" + this.sub;
    }

    public String parameter(String name) {
        return this.parameters.get(name);
    }

    public Set<Map.Entry<String, String>> parameters() {
        return this.parameters.entrySet();
    }

    public boolean isMultipart() {
        return this.main.equals(MULTIPART);
    }

    public boolean isText() {
        return this.main.equals(TEXT);
    }

    public boolean isXQuery() {
        return this.sub.equals(XQUERY);
    }

    public boolean isCSV() {
        return this.sub.equals(CSV) || this.sub.equals(COMMA_SEPARATED_VALUES);
    }

    public boolean isXml() {
        return this.is(TEXT_XML) || this.is(TEXT_XML_EPE) || this.is(APPLICATION_XML) || this.is(APPLICATION_XML_EPE) || this.sub.endsWith(XML_SUFFIX);
    }

    public boolean isJSON() {
        return this.is(APPLICATION_JSON) || this.sub.endsWith(JSON_SUFFIX);
    }

    public boolean matches(MediaType pattern) {
        return Strings.eq(pattern.main(), this.main, "*") && Strings.eq(pattern.sub(), this.sub, "*");
    }

    public boolean is(MediaType type) {
        return this.main.equals(type.main) && this.sub.equals(type.sub);
    }

    @Override
    public int compareTo(MediaType type) {
        int cmp = MediaType.compareTo(this.main, type.main);
        return cmp == 0 ? MediaType.compareTo(this.sub, type.sub) : cmp;
    }

    private static int compareTo(String type1, String type2) {
        return type1.equals(type2) ? 0 : (type1.equals("*") ? 1 : (type2.equals("*") ? -1 : type1.compareTo(type2)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.type());
        this.parameters.forEach((key, value) -> sb.append("; ").append((String)key).append('=').append((String)value));
        return sb.toString();
    }

    public static MediaType get(String path) {
        int s = path.lastIndexOf(47);
        int d = path.lastIndexOf(46);
        String suffix = d <= s ? "" : path.substring(d + 1).toLowerCase(Locale.ENGLISH);
        return MEDIATYPES.getOrDefault(suffix, APPLICATION_OCTET_STREAM);
    }

    static {
        HashMap<String, MediaType> cache = new HashMap<String, MediaType>();
        TokenMap map = Util.properties("media-types.properties");
        for (byte[] key : map) {
            String suffix = Token.string(key);
            String type = Token.string(map.get(key));
            MEDIATYPES.put(suffix, cache.computeIfAbsent(type, MediaType::new));
        }
        ALL_ALL = new MediaType("*/*");
        APPLICATION_X_WWW_FORM_URLENCODED = new MediaType("application/x-www-form-urlencoded");
        APPLICATION_HTML_XML = new MediaType("application/html+xml");
        APPLICATION_JSON = new MediaType("application/json");
        APPLICATION_OCTET_STREAM = new MediaType("application/octet-stream");
        APPLICATION_XML = new MediaType("application/xml");
        APPLICATION_XML_EPE = new MediaType("application/xml-external-parsed-entity");
        MULTIPART_FORM_DATA = new MediaType("multipart/form-data");
        TEXT_CSV = new MediaType("text/csv");
        TEXT_HTML = new MediaType("text/html");
        TEXT_PLAIN = new MediaType("text/plain");
        TEXT_XML = new MediaType("text/xml");
        TEXT_XML_EPE = new MediaType("text/xml-external-parsed-entity");
    }
}

