/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.Token;
import org.basex.util.hash.ASet;

public class TokenSet
extends ASet
implements Iterable<byte[]> {
    protected byte[][] keys;

    public TokenSet() {
        this(8L);
    }

    public TokenSet(long capacity) {
        super(capacity);
        this.keys = new byte[this.capacity()][];
    }

    public TokenSet(byte[] ... keys) {
        this(keys.length);
        for (byte[] key : keys) {
            this.add(key);
        }
    }

    public TokenSet(String ... keys) {
        this(keys.length);
        for (String key : keys) {
            this.add(key);
        }
    }

    public TokenSet(DataInput in) throws IOException {
        this.read(in);
    }

    public void read(DataInput in) throws IOException {
        this.keys = in.readTokens();
        this.next = in.readNums();
        this.buckets = in.readNums();
        this.size = in.readNum();
    }

    public void write(DataOutput out) throws IOException {
        out.writeTokens(this.keys);
        out.writeNums(this.next);
        out.writeNums(this.buckets);
        out.writeNum(this.size);
    }

    public final boolean add(byte[] key) {
        return this.index(key) > 0;
    }

    public final boolean add(String key) {
        return this.add(Token.token(key));
    }

    public final int put(byte[] key) {
        int id = this.index(key);
        return Math.abs(id);
    }

    public final boolean contains(byte[] key) {
        return this.id(key) > 0;
    }

    public final int id(byte[] key) {
        int b = Token.hash(key) & this.capacity() - 1;
        int id = this.buckets[b];
        while (id != 0) {
            if (Token.eq(key, this.keys[id])) {
                return id;
            }
            id = this.next[id];
        }
        return 0;
    }

    public final byte[] key(int id) {
        return this.keys[id];
    }

    public int remove(byte[] key) {
        int b = Token.hash(key) & this.capacity() - 1;
        int p = 0;
        int id = this.buckets[b];
        while (id != 0) {
            if (Token.eq(key, this.keys[id])) {
                if (p == 0) {
                    this.buckets[b] = this.next[id];
                } else {
                    this.next[p] = this.next[this.next[p]];
                }
                this.keys[id] = null;
                return id;
            }
            p = id;
            id = this.next[id];
        }
        return 0;
    }

    private int index(byte[] key) {
        int h = Token.hash(key);
        int b = h & this.capacity() - 1;
        int id = this.buckets[b];
        while (id != 0) {
            if (Token.eq(key, this.keys[id])) {
                return -id;
            }
            id = this.next[id];
        }
        int s = this.size++;
        if (this.checkCapacity()) {
            b = h & this.capacity() - 1;
        }
        this.next[s] = this.buckets[b];
        this.keys[s] = key;
        this.buckets[b] = s;
        return s;
    }

    @Override
    protected int hash(int id) {
        return Token.hash(this.keys[id]);
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Array.copyOf(this.keys, newSize);
    }

    @Override
    public void clear() {
        Arrays.fill((Object[])this.keys, null);
        super.clear();
    }

    @Override
    public final Iterator<byte[]> iterator() {
        return new ArrayIterator<byte[]>((Object[])this.keys, 1, this.size);
    }

    public String toString() {
        return this.toString((Object[])this.keys);
    }
}

