/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.EnumMap;
import java.util.Objects;
import org.basex.data.MetaData;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.ft.ThesList;
import org.basex.query.value.node.FBuilder;
import org.basex.util.Token;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.Language;
import org.basex.util.ft.StemDir;
import org.basex.util.ft.StopWords;
import org.basex.util.list.StringList;

public final class FTOpt
extends ExprInfo {
    private final EnumMap<FTFlag, Boolean> map = new EnumMap(FTFlag.class);
    public FTCase cs;
    public StemDir sd;
    public StopWords sw;
    public ThesList th;
    public Language ln;
    public int errors = -1;

    public FTOpt assign(FTOpt opt) {
        opt.map.forEach((key, value) -> this.map.computeIfAbsent((FTFlag)((Object)key), k -> value));
        if (this.cs == null) {
            this.cs = opt.cs;
        }
        if (this.sw == null) {
            this.sw = opt.sw;
        }
        if (this.sd == null) {
            this.sd = opt.sd;
        }
        if (this.ln == null) {
            this.ln = opt.ln;
        }
        if (this.th == null) {
            this.th = opt.th;
        } else if (opt.th != null) {
            this.th.merge(opt.th);
        }
        if (this.errors == -1) {
            this.errors = opt.errors;
        }
        return this;
    }

    public FTOpt assign(MetaData md) {
        this.set(FTFlag.DC, md.diacritics);
        this.set(FTFlag.ST, md.stemming);
        this.cs = md.casesens ? FTCase.SENSITIVE : FTCase.INSENSITIVE;
        this.ln = md.language;
        return this;
    }

    public void set(FTFlag flag, boolean value) {
        this.map.put(flag, value);
    }

    public boolean isSet(FTFlag flag) {
        return this.map.containsKey((Object)flag);
    }

    public boolean is(FTFlag flag) {
        Boolean b = this.map.get((Object)flag);
        return b != null && b != false;
    }

    public FTOpt copy() {
        return new FTOpt().assign(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FTOpt)) {
            return false;
        }
        FTOpt f = (FTOpt)obj;
        return this.map.equals((Object)f.map) && this.cs == f.cs && Objects.equals(this.sd, f.sd) && this.errors == f.errors && Objects.equals(this.sw, f.sw) && Objects.equals(this.th, f.th) && Objects.equals(this.ln, f.ln);
    }

    @Override
    public void toXml(QueryPlan plan) {
        FBuilder elem = plan.create(this, new Object[]{"wildcards", (byte[])(this.is(FTFlag.WC) ? Token.TRUE : null), "fuzzy", (byte[])(this.is(FTFlag.FZ) ? Token.TRUE : null), "errors", this.errors != -1 ? Integer.valueOf(this.errors) : null, "case", this.cs, "stemming", (byte[])(this.is(FTFlag.ST) || this.sd != null ? Token.TRUE : null), "language", this.ln, "thesaurus", (byte[])(this.th != null ? Token.TRUE : null)});
        if (!elem.isEmpty()) {
            plan.add(elem, new ExprInfo[0]);
        }
    }

    @Override
    public void toString(QueryString qs) {
        StringList list = new StringList();
        if (this.is(FTFlag.WC)) {
            list.add("wildcards");
        }
        if (this.is(FTFlag.FZ)) {
            list.add(this.errors != -1 ? "fuzzy " + this.errors + " errors" : "fuzzy");
        }
        if (this.cs == FTCase.LOWER) {
            list.add("lowercase");
        } else if (this.cs == FTCase.UPPER) {
            list.add("uppercase");
        } else if (this.cs == FTCase.SENSITIVE) {
            list.add("case sensitive");
        }
        if (this.is(FTFlag.DC)) {
            list.add("diacritics sensitive");
        }
        if (this.is(FTFlag.ST) || this.sd != null) {
            list.add("stemming");
        }
        if (this.ln != null) {
            list.add("language \"" + this.ln + "\"");
        }
        if (this.th != null) {
            list.add("thesaurus at " + this.th);
        }
        for (String opt : list) {
            qs.token("using").token(opt);
        }
    }
}

