/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.io.IOException;
import java.util.EnumMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.api.dom.BXAttr;
import org.basex.api.dom.BXComm;
import org.basex.api.dom.BXDoc;
import org.basex.api.dom.BXElem;
import org.basex.api.dom.BXNode;
import org.basex.api.dom.BXPI;
import org.basex.api.dom.BXText;
import org.basex.build.MemBuilder;
import org.basex.build.xml.DOMWrapper;
import org.basex.core.MainOptions;
import org.basex.io.IOContent;
import org.basex.io.in.DataInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FComm;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FPI;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public enum NodeType implements Type
{
    NODE("node", AtomType.ITEM, Type.ID.NOD),
    TEXT("text", NODE, Type.ID.TXT){

        @Override
        public ANode cast(Object value, QueryContext qc, InputInfo ii) {
            if (value instanceof BXText) {
                return ((BXNode)value).getNode();
            }
            if (value instanceof Text) {
                return new FTxt((Text)value);
            }
            return new FTxt(Token.token(value));
        }
    }
    ,
    PROCESSING_INSTRUCTION("processing-instruction", NODE, Type.ID.PI){

        @Override
        public ANode cast(Object value, QueryContext qc, InputInfo ii) throws QueryException {
            if (value instanceof BXPI) {
                return ((BXNode)value).getNode();
            }
            if (value instanceof ProcessingInstruction) {
                return new FPI((ProcessingInstruction)value);
            }
            Matcher m = this.matcher("<\\?(.*?) (.*)\\?>", value, ii);
            return new FPI(new QNm(m.group(1)), Token.token(m.group(2)));
        }
    }
    ,
    ELEMENT("element", NODE, Type.ID.ELM){

        @Override
        public ANode cast(Object value, QueryContext qc, InputInfo ii) throws QueryException {
            if (value instanceof BXElem) {
                return ((BXNode)value).getNode();
            }
            if (value instanceof Element) {
                return FElem.build((Element)value, null).finish();
            }
            try {
                return new DBNode(new IOContent(Token.token(value))).childIter().next();
            }
            catch (IOException ex) {
                throw QueryError.NODEERR_X_X.get(ii, this, ex);
            }
        }
    }
    ,
    DOCUMENT_NODE("document-node", NODE, Type.ID.DOC){

        @Override
        public ANode cast(Object value, QueryContext qc, InputInfo ii) throws QueryException {
            if (value instanceof BXDoc) {
                return ((BXNode)value).getNode();
            }
            try {
                if (value instanceof Document) {
                    DOMWrapper dom = new DOMWrapper((Document)value, "", new MainOptions());
                    return new DBNode(MemBuilder.build(dom));
                }
                if (value instanceof DocumentFragment) {
                    DocumentFragment df = (DocumentFragment)value;
                    String bu = df.getBaseURI();
                    return FDoc.build(bu != null ? bu : "", df).finish();
                }
                byte[] token = Token.token(value);
                return Token.startsWith(token, 60) ? new DBNode(new IOContent(token)) : FDoc.build().add(token).finish();
            }
            catch (IOException ex) {
                throw QueryError.NODEERR_X_X.get(ii, this, ex);
            }
        }
    }
    ,
    DOCUMENT_NODE_ELEMENT("document-node(element())", DOCUMENT_NODE, Type.ID.DEL){

        @Override
        public ANode cast(Object value, QueryContext qc, InputInfo ii) throws QueryException {
            return DOCUMENT_NODE.cast(value, qc, ii);
        }
    }
    ,
    ATTRIBUTE("attribute", NODE, Type.ID.ATT){

        @Override
        public ANode cast(Object value, QueryContext qc, InputInfo ii) throws QueryException {
            if (value instanceof BXAttr) {
                return ((BXNode)value).getNode();
            }
            if (value instanceof Attr) {
                return new FAttr((Attr)value);
            }
            Matcher m = this.matcher(" ?(.*?)=\"(.*)\"", value, ii);
            return new FAttr(new QNm(m.group(1)), Token.token(m.group(2)));
        }
    }
    ,
    COMMENT("comment", NODE, Type.ID.COM){

        @Override
        public ANode cast(Object value, QueryContext qc, InputInfo ii) throws QueryException {
            if (value instanceof BXComm) {
                return ((BXNode)value).getNode();
            }
            if (value instanceof Comment) {
                return new FComm((Comment)value);
            }
            Matcher m = this.matcher("<!--(.*?)-->", value, ii);
            return new FComm(Token.token(m.group(1)));
        }
    }
    ,
    NAMESPACE_NODE("namespace-node", NODE, Type.ID.NSP),
    SCHEMA_ELEMENT("schema-element", NODE, Type.ID.SCE),
    SCHEMA_ATTRIBUTE("schema-attribute", NODE, Type.ID.SCA);

    private static final NodeType[] VALUES;
    public static final NodeType[] LEAF_TYPES;
    private final byte[] name;
    private final Type parent;
    private final Type.ID id;
    private EnumMap<Occ, SeqType> seqTypes;
    private QNm qnm;

    private NodeType(String name, Type parent, Type.ID id) {
        this.name = Token.token(name);
        this.parent = parent;
        this.id = id;
    }

    @Override
    public final boolean isNumber() {
        return false;
    }

    @Override
    public final boolean isUntyped() {
        return this != PROCESSING_INSTRUCTION && this != COMMENT && this != NODE;
    }

    @Override
    public final boolean isNumberOrUntyped() {
        return this != PROCESSING_INSTRUCTION && this != COMMENT && this != NODE;
    }

    @Override
    public boolean isStringOrUntyped() {
        return true;
    }

    @Override
    public final boolean isSortable() {
        return true;
    }

    @Override
    public final ANode cast(Item item, QueryContext qc, StaticContext sc, InputInfo ii) throws QueryException {
        if (item.type == this) {
            return (ANode)item;
        }
        throw QueryError.typeError(item, this, ii);
    }

    @Override
    public ANode cast(Object value, QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.FUNCCAST_X_X.get(ii, this, value);
    }

    @Override
    public ANode read(DataInput in, QueryContext qc) throws IOException, QueryException {
        return this.cast(in.readToken(), qc, null);
    }

    @Override
    public final SeqType seqType(Occ occ) {
        if (this.seqTypes == null) {
            this.seqTypes = new EnumMap(Occ.class);
        }
        return this.seqTypes.computeIfAbsent(occ, o -> new SeqType(this, (Occ)((Object)o)));
    }

    public final QNm qname() {
        if (this.qnm == null) {
            this.qnm = new QNm(this.name);
        }
        return this.qnm;
    }

    @Override
    public final boolean eq(Type type) {
        return this == type;
    }

    @Override
    public final boolean instanceOf(Type type) {
        return type.oneOf(this, AtomType.ITEM) || type instanceof NodeType && this.parent.instanceOf(type);
    }

    @Override
    public final Type union(Type type) {
        return this == type ? this : (type instanceof NodeType ? NODE : AtomType.ITEM);
    }

    @Override
    public final NodeType intersect(Type type) {
        return this.instanceOf(type) ? this : (type.instanceOf(this) ? (NodeType)type : null);
    }

    @Override
    public final AtomType atomic() {
        return this.oneOf(PROCESSING_INSTRUCTION, COMMENT) ? AtomType.STRING : (this == NODE ? AtomType.ANY_ATOMIC_TYPE : AtomType.UNTYPED_ATOMIC);
    }

    @Override
    public final Type.ID id() {
        return this.id;
    }

    @Override
    public boolean nsSensitive() {
        return false;
    }

    @Override
    public final String toString() {
        return this.toString("");
    }

    final Matcher matcher(String pattern, Object value, InputInfo ii) throws QueryException {
        Matcher m = Pattern.compile(pattern).matcher(Token.string(Token.token(value)));
        if (m.find()) {
            return m;
        }
        throw QueryError.NODEERR_X_X.get(ii, this, value);
    }

    public final String toString(String arg) {
        return new TokenBuilder().add(this.name).add(40).add(arg).add(41).toString();
    }

    public static NodeType find(QNm name) {
        if (name.uri().length == 0) {
            byte[] ln = name.local();
            for (NodeType type : VALUES) {
                if (!Token.eq(ln, type.name)) continue;
                return type;
            }
        }
        return null;
    }

    static {
        VALUES = NodeType.values();
        LEAF_TYPES = new NodeType[]{ATTRIBUTE, COMMENT, NAMESPACE_NODE, PROCESSING_INSTRUCTION, TEXT};
    }
}

